//---------------------------------------------------------------------------


#pragma hdrstop

#include "SearchBroker.h"
#include "Preferences.h"
#include <cassert>
//---------------------------------------------------------------------------


#pragma package(smart_init)


SearchBroker::SearchBroker( TCppWebBrowser* view )
 : view_(view), sites_(Preferences::instance().sites()) {}

void SearchBroker::doSearch( const SearchRequest & request ) {
  assert( 0 <= request.siteId && request.siteId < (int)sites_->size() );

  if (lastRequest_ == request ) { return; }

  URLString url = sites_->at(request.siteId).url( request.word );

  view_->Navigate( const_cast<wchar_t*>(url.c_str()), 0,0,0,0 );

  lastRequest_ = request;
}//doSearch


