//---------------------------------------------------------------------------

#ifndef SearchBrokerH
#define SearchBrokerH
//---------------------------------------------------------------------------
#include "Site.h"
#include "SHDocVw_OCX.h"

//---------------------------------------------------------------------------

struct SearchRequest {
  SearchRequest() : siteId(-1) {}
  SearchRequest( int newSiteId, const std::string & newWord )
    : siteId(newSiteId), word(newWord) {}

  int siteId;
  std::string word;
};

inline bool operator==( const SearchRequest & lhs,
                        const SearchRequest & rhs ) {
  return ((lhs.siteId == rhs.siteId) && (lhs.word == rhs.word));
}//==

inline bool operator!=( const SearchRequest & lhs,
                        const SearchRequest & rhs ) {
  return !(lhs == rhs);
}//!=

class SearchBroker {
public:
  SearchBroker( TCppWebBrowser* view );

  void doSearch( const SearchRequest & request );
  const SiteList* sites() const { return sites_; }
private:
  const SiteList* sites_;
  SearchRequest lastRequest_;
  TCppWebBrowser* view_;
};

#endif
