/*
 * Decompiled with CFR 0.152.
 */
package jp.fraction.hatena.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.fraction.hatena.HatenaContext;
import jp.fraction.hatena.node.AbstractPatternNode;

public class ListNode
extends AbstractPatternNode {
    private Pattern pattern = Pattern.compile("^([\\-\\+]+)([^>\\-\\+].*)$");

    public Pattern getPattern() {
        return this.pattern;
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c) {
        return this.parse(html, c, false);
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c, boolean open) {
        String line = c.nextLine();
        Matcher m = this.getMatcher(line);
        return this.parse(html, c, open, m);
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c, boolean open, Matcher m) {
        String line = c.nextLine();
        if (!m.matches()) {
            return html;
        }
        int level = m.group(1).length();
        String type = "-".equals(m.group(1).substring(0, 1)) ? "ul" : "ol";
        html.append("<" + type + ">");
        while (c.hasNext() && (m = this.getMatcher(line = c.nextLine())).matches()) {
            String nl;
            if (m.group(1).length() > level) {
                html = HatenaContext.LIST_NODE.parse(html, c, true, m);
                continue;
            }
            if (m.group(1).length() < level) break;
            c.shiftLine();
            String contents = m.group(2);
            if (c.hasNext() && (m = this.getMatcher(nl = c.nextLine())).matches() && m.group(1).length() > level) {
                html.append("<li>");
                html.append(contents);
                continue;
            }
            html.append("<li>");
            html.append(contents);
            html.append("</li>");
        }
        html.append("</" + type + ">");
        if (open) {
            html.append("</li>");
            open = false;
        }
        return html;
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c, Matcher m) {
        return this.parse(html, c, false, m);
    }
}

