<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_Charset extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Charset() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		// charsetタグ内文字列
		$charset_strings	= '';
		// 出力コード指定行を取得(旧バージョン互換)
		if( preg_match_all( '/\\$this->setOutputCharset\\([^\\)]*?\\)\\;/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$charset_strings	= preg_replace( '/\\$this->setOutputCharset\\(/','', $target );
					$charset_strings	= preg_replace( '/\\)\\;/','', $charset_strings );
					$charset_strings	= str_replace("'","",$charset_strings);
					$charset_strings	= str_replace('"','',$charset_strings);
					$charset_strings	= trim($charset_strings);
					$creator->out_body_strings = str_replace( $target, "", $creator->out_body_strings );
				}
			}
			// 出力コード指定行を取得
			preg_match_all( '/\\{charset\\:[^\\}]*?\\}/'
				, $creator->out_body_strings
				, $output_array
				, PREG_PATTERN_ORDER );
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$charset_strings			= preg_replace( '/\\{charset\\:/','', $target );
					$charset_strings			= preg_replace( '/\\}/','', $charset_strings );
					$creator->out_body_strings	= str_replace( $target, "", $creator->out_body_strings );
					$charset_strings_strings	= trim($charset_strings);
				}
			}
		} else if ( preg_match_all( '/\\{charset\\:[^\\}]*?\\}/'
				, $creator->out_body_strings
				, $output_array
				, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$charset_strings	= preg_replace( '/\\{charset\\:/','', $target );
					$charset_strings	= preg_replace( '/\\}/','', $charset_strings );
					$creator->out_body_strings = str_replace( $target, "", $creator->out_body_strings );
					$charset_strings	= trim($charset_strings);
				}
			}
		} else {
			if ( $creator->agent_type == 'pc' ){
				$charset_strings	= 'UTF-8';
			} else {
				$charset_strings	= 'SJIS-win';
			}
		}

		$charset_array	= explode( " ", $charset_strings );
		// 最初の項は必ず文字コード
		$charset			= trim(array_shift($charset_array));
		$convert_kana		= '';
		$internal_charset	= 'UTF-8';
		$output_handler		= 'mb_output_handler';
		$detect_order		= 'UTF-8,EUC-JP,SJIS,SJIS-win,JIS,UTF-7';
		$language			= 'japanese';
		// 残りの項の解析
		foreach( $charset_array as $str ) {
			if( strlen(trim($str)) > 0 ) {
				list( $key, $val )	= explode('=',trim($str));
				$key	= trim($key);
				$val	= trim($val);
				if( strlen($val) == 0 ) {
					// 単一項目ならconvert_kanaと判断する（下位互換）
					$convert_kana	= $key;
				} else if( 'internal_charset' == $key ){
					$internal_charset	= $val;
				} else if( 'output_handler' == $key ) {
					$output_handler		= $val;
				} else if( 'convert_kana' == $key ) {
					$convert_kana		= $val;
				} else if( 'detect_order' == $key ) {
					$detect_order		= $val;
				} else if( 'language' == $key ) {
					$language			= $val;
				}
			}
		}
		// 互換の為creatorにも設定
		$creator->output_charset	= $charset;
		$creator->convert_kana		= $convert_kana;
		$creator->output_handler	= $output_handler;
		$creator->internal_charset	= $internal_charset;
		$creator->detect_order		= $detect_order;
		$creator->output_language	= $language;
		// 前処理の文字コードフラッシュコードを追加
		$process_code = "ob_start('".$output_handler."');\n";
		$process_code .= "ob_implicit_flush( false );\n";
		$process_code .= "mb_language('".$language."');\n";
		$process_code .= "mb_detect_order('".$detect_order."');\n";
		$process_code .= "mb_internal_encoding('".$internal_charset."');\n";
		if( !is_array($creator->preview_process_hash) ){
			$creator->preview_process_hash	= array();
		}
		if( !is_array($creator->preview_process_hash[$this->priority]) ){
			$creator->preview_process_hash[$this->priority]	= array();
		}
		array_push( $creator->preview_process_hash[$this->priority], $process_code );
		
		// 表示文字列に対する処理実行コードを記述
		if( !is_array($creator->convert_view_process_hash) ){
			$creator->convert_view_process_hash	= array();
		}
		if( !is_array($creator->convert_view_process_hash[$this->priority]) ){
			$creator->convert_view_process_hash[$this->priority]	= array();
		}
		if( strlen( trim( $convert_kana ) ) > 0 ) {
			$process_code = '$outstr = mb_convert_kana( $outstr, "' . $convert_kana . '" );'."\n";
			array_push( $creator->convert_view_process_hash[$this->priority], $process_code );
		} else if ( 'docomo' == $creator->agent_type || 'docomo2' == $creator->agent_type || 'softbank' == $creator->agent_type || 'au' == $creator->agent_type ) {
			$process_code = '$outstr = mb_convert_kana( $outstr, "kna" );'."\n";
			if( 'docomo2' == $creator->agent_type ) {
				// ユーザーエージェントがdocomo2でボディがxml宣言で始まっているならヘッダー追加
				$process_code .= 'if( preg_match(\'/\\\\<\\\\?xml/\',$outstr) > 0 ){ '
					. 'header(\'Content-Type: application/xhtml+xml;charset=Shift_JIS\'); echo "\n";'."\n"
					. ' }'."\n"
				;
			}
			array_push( $creator->convert_view_process_hash[$this->priority], $process_code );
		}
		
	}
}
?>