<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
if( file_exists(DIR_PATH_LIB
	.DIRECTORY_SEPARATOR."cms"
	.DIRECTORY_SEPARATOR."package_define.inc.php") ) {
	require_once( DIR_PATH_LIB
		.DIRECTORY_SEPARATOR."cms"
		.DIRECTORY_SEPARATOR."package_define.inc.php");
}
class spider_tags_CmsPage extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_CmsPage() {
		$this->priority	= 1;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){

		// ユーザーエージェントタイプ確認
		$agent_type	= $creator->agent_type;
		
		// CMSページファイルパスの確定
		$base_uri		= APPLICATION_BASE_URI;
		if( !preg_match( '/\\/$/', $base_uri ) ) {
			$base_uri	= APPLICATION_BASE_URI.'/';
		}
		$request_uri	= $_SERVER['REQUEST_URI'];
		if( preg_match( '/\\?/', $request_uri ) ) {
			list( $request_uri, $params )	= explode('?',$request_uri);
		}
		if( preg_match( '/\\/$/', $request_uri ) ) {
			$request_uri	.= 'index.php';
		}
		$page_file_path		= DIR_PATH_CMS_PAGE
			.DIRECTORY_SEPARATOR.$creator->agent_type
			.DIRECTORY_SEPARATOR
			.str_replace('/',DIRECTORY_SEPARATOR,str_replace( $base_uri, "/", $request_uri ))
		;
		$page_file_path	= str_replace(DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR
			,DIRECTORY_SEPARATOR,$page_file_path);
		
		// CMSページファイルの内容を取得
		$cms_page_contents	= '';
		if( file_exists($page_file_path) ) {
			$lines	= file($page_file_path);
			$cms_page_contents	= implode('',$lines );
		} else {
			$cms_page_contents	= 'ご利用のブラウザではこのページを閲覧できません。['.$creator->agent_type.']'
//				."<br />\n"
//				.APPLICATION_BASE_URI
//				."<br />\n"
//				.$_SERVER['REQUEST_URI']
//				."<br />\n"
//				.str_replace('/',DIRECTORY_SEPARATOR,$_SERVER['REQUEST_URI'])
//				."<br />\n"
//				.$page_file_path
			;
		}
		
		// CMSタグ変換を確認
		preg_match_all( '/\\{cms\\-page\\}/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				if( DIR_PATH_CMS_TARGET == APPLICATION_BASE_PATH ) {
					$creator->out_body_strings = preg_replace( '/\\{cms\\-page\\}/'
						,$cms_page_contents, $creator->out_body_strings );
					$creator->has_cms_page			= true;
					$creator->cms_page_file_path	= $page_file_path;
				} else {
					$creator->out_body_strings = preg_replace( '/\\{cms\\-page\\}/'
						,'', $creator->out_body_strings );
				}
			}
		}
	}
	
}
?>