<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_PageTitle extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_PageTitle() {
		$this->priority	= 60;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		$page_title	= '';
		// ページ名指定行を取得(旧バージョン互換)
		if(preg_match_all( '/\\$this->setPageTitle\\([^\\)]*?\\)\\;/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$page_title	= preg_replace( '/\\$this->setPageTitle\\(/','', $target );
					$page_title	= preg_replace( '/\\)\\;/','', $page_title );
					$page_title	= str_replace("'","",$page_title);
					$page_title	= str_replace('"','',$page_title);
					$action_strings = str_replace( $target, "", $creator->out_body_strings );
				}
			}
		}
		// ページ名指定行を取得
		if( preg_match_all( '/\\{page\\-title\\:[^\\}]*?\\}/'
			, $creator->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$page_title	= preg_replace( '/\\{page\\-title\\:/','', $target );
					$page_title	= preg_replace( '/\\}/','', $page_title );
					$creator->out_body_strings = str_replace( $target, "", $creator->out_body_strings );
					$page_title	= trim($page_title);
				}
			}
		}
		// 互換の為creatorに設定
		$creator->page_title	= $page_title;
		// 前処理追加:互換性の為ページタイトルをセット
		$process_code	= '$page_title="'.str_replace("'","\\'",$page_title).'";'."\n";
		$process_code	.= '$request_object->setAttribute("page_title",$page_title );'."\n";
		if( !is_array($creator->preview_process_hash) ){
			$creator->preview_process_hash	= array();
		}
		if( !is_array($creator->preview_process_hash[$this->priority]) ){
			$creator->preview_process_hash[$this->priority]	= array();
		}
		array_push( $creator->preview_process_hash[$this->priority], $process_code );
	}
}
?>