<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_RewriteDocumentRoot extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_RewriteDocumentRoot() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		
		if( preg_match('/\\{rewrite-document-root\\:[fF][aA][lL][sS][eE]\\}/', $creator->out_body_strings ) > 0
			|| preg_match('/\\{rewrite-document-root\\:[nN][oO]\\}/', $creator->out_body_strings ) > 0 ) {
			// falseかnoが指定されているなら書き換えない
			$creator->out_body_strings = preg_replace( '/\\{rewrite-document-root\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $creator->out_body_strings );
		} else {
			// 明示的に否定していないなら暗黙的に書き換える
			$creator->out_body_strings = preg_replace( '/\\{rewrite-document-root\\:[^\\}]*?\\}/'
				, "", $creator->out_body_strings );
			$replace_uri	= APPLICATION_BASE_URI;
			if( preg_match('/\\/$/', APPLICATION_BASE_URI) > 0 ) {
				$replace_uri	= preg_replace('/\\/$/','',$replace_uri);
			}
			// src書き換え
			$process_code = 'if( preg_match_all( \'/[sS][rR][cC]\\\\=([\\\'"])(\\/[^\\\'"]+)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array as $output ) { ';
			$process_code .= 'foreach ( $output as $target ) { ';
			$process_code .= 'if( preg_match(\'/\'.str_replace("/","\\/",\''.$replace_uri.'\').\'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$repstr = preg_replace(\'/[sS][rR][cC]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'src=${1}'.$replace_uri.'${2}${3}\',$target); '."\n";
			$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}}';
			
			// href書き換え
			$process_code .= 'if( preg_match_all( \'/[hH][rR][eE][fF]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array as $output ) { ';
			$process_code .= 'foreach ( $output as $target ) { ';
			$process_code .= 'if( preg_match(\'/\'.str_replace("/","\\/",\''.$replace_uri.'\').\'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$repstr = preg_replace(\'/[hH][rR][eE][fF]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'href=${1}'.$replace_uri.'${2}${3}\',$target); '."\n";
			$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}}';
			
			// action書き換え
			$process_code .= 'if( preg_match_all( \'/[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array as $output ) { ';
			$process_code .= 'foreach ( $output as $target ) { ';
			$process_code .= 'if( preg_match(\'/\'.str_replace("/","\\/",\''.$replace_uri.'\').\'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$repstr = preg_replace(\'/[aA][cC][tT][iI][oO][nN]\\\\=([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'action=${1}'.$replace_uri.'${2}${3}\',$target); '."\n";
			$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}}';
			
			// window.open()書き換え
			$process_code .= 'if( preg_match_all( \'/window\\\\.open\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array as $output ) { ';
			$process_code .= 'foreach ( $output as $target ) { ';
			$process_code .= 'if( preg_match(\'/\'.str_replace("/","\\/",\''.$replace_uri.'\').\'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$repstr = preg_replace(\'/window\\\\.open\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'window.open(${1}'.$replace_uri.'${2}${3}\',$target); '."\n";
			$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}}';
	
			// url()書き換え
			$process_code .= 'if( preg_match_all( \'/url\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\'';
			$process_code .= ', $outstr';
			$process_code .= ', $output_array';
			$process_code .= ', PREG_PATTERN_ORDER ) > 0 ) { ';
			$process_code .= 'foreach ( $output_array as $output ) { ';
			$process_code .= 'foreach ( $output as $target ) { ';
			$process_code .= 'if( preg_match(\'/\'.str_replace("/","\\/",\''.$replace_uri.'\').\'/\', $target ) == 0 ) { '."\n";
			$process_code .= '$repstr = preg_replace(\'/url\\\\(([\\\'"])(\\/[^\\\'"]*)([\\\'"])/\',\'url(${1}'.$replace_uri.'${2}${3}\',$target); '."\n";
			$process_code .= '$outstr = str_replace( $target, $repstr, $outstr );'."\n";
			$process_code .= ' }'."\n";
			$process_code .= '}}}';
			
			if( !is_array($creator->convert_view_process_hash) ){
				$creator->convert_view_process_hash	= array();
			}
			if( !is_array($creator->convert_view_process_hash[$this->priority]) ){
				$creator->convert_view_process_hash[$this->priority]	= array();
			}
			array_push( $creator->convert_view_process_hash[$this->priority], $process_code );
		}
		
	}
}
?>