<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_SetAttribute extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_SetAttribute() {
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		// 変数タグ
		$vars_tags_aray			= array();
		preg_match_all( '/\\{set\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER );
		foreach ( $vars_tags_aray as $vars_tags ) {
			foreach ( $vars_tags as $vars_tag ) {
				$var_name	= preg_replace( '/\\{set\\:/','', $vars_tag );
				$var_name	= preg_replace( '/\\}$/','', $var_name );
				$var_name	= trim( $var_name );
				list( $var_name, $var_value)	= explode( ' ', $var_name );
				$var_name	= trim( $var_name );
				$var_value	= trim( $var_value );
				if( strlen(trim($var_name)) > 0 && strlen(trim($var_value)) > 0 ) {
					// 名前と値を両方指定されている場合のみ変換
					$rep_string = "<?php ";
					if( preg_match('/^\\".+?\\"$/',$var_value) || preg_match('/^\\\'.+?\\\\\'$/',$var_value) ) {
						// 値がクォーテーションで囲まれている場合は中の値をそのまま登録する
						$rep_string .= '$tmp='.$var_value.'; ';
						$rep_string .= '$request_object->setAttribute( "' . $var_name . '",$tmp ); ';
					} else {
						// 値がクォーテーションで囲まれていない場合は、スコープから変数を探して登録
						list( $obj_name, $at_name )		= explode('::',$var_value);
						list( $obj_name, $method_name )	= explode('->',$obj_name);
						$rep_string .= '$tmp=$request_object->getAttribute( "' . $obj_name . '" ); ';
						$rep_string	.= '$type=gettype($tmp); ';
						if( strlen(trim($method_name)) > 0 ) {
							$rep_string	.= 'if(\'object\'==$type) { $tmp=$tmp->'.$method_name.'; } ';
							if ( strlen(trim($at_name)) > 0 ) {
								$rep_string	.= 'if(\'array\'==$type) { $tmp=$tmp[\''.$at_name.'\']; } ';
								$rep_string	.= 'if(\'object\'==$type) { $tmp=$tmp->'.$at_name.'; } ';
							}
						} else 	if ( strlen(trim($at_name)) > 0 ) {
							$rep_string	.= 'if(\'array\'==$type) { $tmp=$tmp[\''.$at_name.'\']; } ';
							$rep_string	.= 'if(\'object\'==$type) { $tmp=$tmp->'.$at_name.'; } ';
						}
						$rep_string .= '$request_object->setAttribute( "' . $var_name . '", $tmp ); ';
					}
					$rep_string .= " ?>";
					$result_strings = str_replace( $vars_tag, $rep_string, $result_strings );
				} else {
					// 名前か値どちらかがカラ文字の場合は変換しない
				}
			}
		}
	}
}
?>