<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_Write extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Write() {
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		// 変数タグ
		$vars_tags_aray			= array();
		preg_match_all( '/\\{write\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER );
		$valiable_counter	= 0;
		foreach ( $vars_tags_aray as $vars_tags ) {
			foreach ( $vars_tags as $vars_tag ) {
				$var_name	= preg_replace( '/\\{write\\:/','', $vars_tag );
				$var_name	= preg_replace( '/\\}$/','', $var_name );
				$var_name	= trim( $var_name );
				$repstr		= $this->parseString( $var_name, $valiable_counter );
				$result_strings	= str_replace( $vars_tag, $repstr, $result_strings );
				$valiable_counter++;
			}
		}
	}
	/**
	 * 文字列解析
	 */
	function parseString(  $strings, $prefix=1  ) {

		// 出力オプションの確認
		$is_noescape	= false;
		$is_nl2br		= false;
		$is_nl2null		= false;
		$is_escape_nl	= false;
		$is_escape_sq	= false;
		$is_escape_dq	= false;
		$is_urlencode	= false;
		if( strpos( $strings, 'noescape' ) !== false ) {
			$is_noescape	= true;
			$strings		= str_replace('noescape','',$strings);
		}
		if( strpos( $strings, 'ln2br' ) !== false || strpos( $strings, 'nl2br' ) !== false ) {
			$is_nl2br		= true;
			$strings		= str_replace('ln2br','',$strings);
			$strings		= str_replace('nl2br','',$strings);
		}
		if( strpos( $strings, 'nl2null' ) !== false ) {
			$is_nl2null		= true;
			$strings		= str_replace('nl2null','',$strings);
		}
		if( strpos( $strings, 'escape-nl' ) !== false ) {
			$is_escape_nl	= true;
			$strings		= str_replace('escape-nl','',$strings);
		}
		if( strpos( $strings, 'escape-sq' ) !== false ) {
			$is_escape_sq	= true;
			$strings		= str_replace('escape-sq','',$strings);
		}
		if( strpos( $strings, 'escape-dq' ) !== false ) {
			$is_escape_dq	= true;
			$strings		= str_replace('escape-dq','',$strings);
		}
		if( strpos( $strings, 'urlencode' ) !== false ) {
			$is_urlencode	= true;
			$strings		= str_replace('urlencode','',$strings);
		}

		// 内部で利用されている変数を全て取り出す
		$var_name_array		= array();
		// 単一要素式
		$pos=0;
		for( $i=0; $i<strlen($strings); $i++ ) {
			$char	= substr($strings,$i,1);
			if( '+' == $char || '-' == $char
				|| '*' == $char || '/' == $char
				|| '(' == $char || ')' == $char
				|| '[' == $char || ']' == $char
				|| ',' == $char ) {
				// 演算子が登場したらひとつ前までを文字列切り出し
				$str	= substr( $strings, $pos, $i-$pos );
				$pos	= $i+1;
				if( '(' != $char && strlen( trim($str) ) > 0 ) {
					// 関数名でなければ追加
					$var_name_array[trim($str)]	= '';
				} else if( '(' == $char && strlen( trim($str) ) > 0 ) {
					// 関数名の場合
					if( preg_match('/\\:\\:/',$str) > 0 ) {
						// オブジェクトメソッドの場合はオブジェクト名のみ追加
						list( $obj_name, $method_name ) = explode('::',$str);
						$var_name_array[trim($obj_name)]	= '';
					}
				}
			}
		}
		// ループ最後のポジションから最後の要素を切り出し
		$str	= substr( $strings, $pos, $i-$pos );
		if( strlen( trim($str) ) > 0 ) {
			$var_name_array[trim($str)]	= '';
		}


		// 変数一時格納配列
		$temporary_valiable_getter_array	= array();
		
		// 変数の変換を確認
		$vcounter	= 0;
		foreach( $var_name_array as $key => $value ) {
			if( strlen($key) > 0 ) {
				if( is_numeric( $key ) ) {
					// 変数が数字なら変換対象としない
					$var_name_array[$key]	= $key;
				} else {
					// 変数が文字列の場合
					$tmp_name	= '$____tw__' . sprintf('%03d',$prefix) . sprintf('%03d',$vcounter);
					$var_name_array[$key]	= $tmp_name;
					if( preg_match('/^\\\'(.)*\\\'$/',$key) > 0 ) {
						// シングルクォートされているなら固定文字列
						$str	= $tmp_name. '='.$key.';'."\n";
						array_push( $temporary_valiable_getter_array, $str );
					} else {
						list( $vname, $vparam )		= explode('::',$key);
						// 一時編集取得文字列作成
						$str	= $tmp_name. '=$request_object->getAttribute(\''.$vname.'\');'."\n";
						$str	.= 'if( is_null('.$tmp_name.') ){'."\n";
						$str	.= "\t".$tmp_name. '=\''.$vname.'\';'."\n";
						$str	.= '} else if(\'array\'==gettype('.$tmp_name.')) {'."\n";
						if( is_numeric($vparam) ) {
							$str	.= "\t".$tmp_name. '='.$tmp_name.'['.$vparam.'];'."\n";
						} else if( strlen(trim($vparam)) > 0 ){
							$str	.= "\t".$tmp_name. '='.$tmp_name.'[\''.$vparam.'\'];'."\n";
						}
						$str	.= '} else if(\'object\'==gettype('.$tmp_name.')) {'."\n";
						if( is_numeric($vparam) ) {
							// オブジェクトの場合、数値は許可できません。(変数名、メソッド名は数値から始められない)
							$str	.= "\t".'$request_object->addError(\'オブジェクトの添え字には数字を指定できません。\');'."\n";
						} else if( strlen(trim($vparam)) > 0 ){
							$str	.= "\t".$tmp_name. '='.$tmp_name.'->'.$vparam.';'."\n";
						}
						$str	.= '}'."\n";
						array_push( $temporary_valiable_getter_array, $str );
					}
					$vcounter++;
				}
			}
		}
		// 変数配列を文字列の長い順にソート
		$order_array	= array();
		foreach( $var_name_array as $key => $value ) {
			if( !is_array( $order_array[strlen($key)] ) ) {
				$order_array[strlen($key)]	= array();
			}
			array_push($order_array[strlen($key)],$key);
		}
		krsort($order_array);
		$new_var_name_array		= array();
		foreach( $order_array as $item_array ) {
			foreach( $item_array as $name ) {
				$new_var_name_array[$name]	= $var_name_array[$name];
			}
		}
		
		// 渡された文字列の置換
		foreach( $new_var_name_array as $key => $value ) {
			$strings	= str_replace( $key, $value, $strings );
			$strings	= str_replace( $value.'::', $value.'->', $strings );
		}
		
		// オプション指定の処理
		if( $is_nl2br ) {
			$strings	= 'nl2br('.$strings.')';
		}
		if( $is_escape_sq ) {
			$strings	= 'str_replace("\'","\\\'",'.$strings.')';
		}
		if( $is_escape_dq ) {
			$strings	= 'str_replace(\'"\',\'\\"\','.$strings.')';
		}
		if( $is_escape_nl ) {
			$strings	= 'str_replace("\\n","\\\n",str_replace("\\r","\\n",str_replace("\\r\\n","\\n",'.$strings.')))';
		}
		if( $is_nl2null ) {
			$strings	= 'str_replace("\\n","",str_replace("\\r","",str_replace("\\r\\n","",'.$strings.')))';
		}
		if( $is_urlencode ) {
			$strings	= 'urlencode('.$strings.')';
		}
		if( !$is_noescape && !$is_nl2br && !$is_escape_sq && !$is_escape_dq && !$is_escape_nl ) {
			$strings	= 'htmlspecialchars('.$strings.')';
		}

		// 変数取り出し文字列を冒頭に追加
		$strings	= '<?php ' . implode("",$temporary_valiable_getter_array)
			.' if(is_object('.$strings.')||is_array('.$strings.')){ print_r( '.$strings.' ); }else{ echo '.$strings.'; } ?>';
		
		return $strings;

	}
}
?>