<?php
/**
 * 妥当性検査用の静的メソッドを保持するライブラリクラス
 * @package util ユーティリティパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class ValidateFunctions {
    function ValidateFunctions() {
    }
	/**
	 * 渡された年、月、日がカレンダーで有効な日付であるか検査します。
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $year 西暦年
	 * @param $month 月
	 * @param $day 日
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableDate( $year, $month, $day ) {
		if( strlen( trim( $year ) ) == 0 
				|| strlen( trim( $month ) ) == 0 
				|| strlen( trim( $day ) ) == 0 ) {
			return false;
		} else if ( !preg_match("/^[0-9]+$/", $year )
					|| !preg_match("/^[0-9]+$/", $month ) 
					|| !preg_match("/^[0-9]+$/", $day ) ){
			return false;
		} else if ( ( $year < 1900 || $year > 2050 ) 
					|| ( $month < 1 || $month > 12 ) 
					|| ( $day < 1 || $day > 31 ) ) {
			return false;
		} else if ( $month == 2 && $day == 29 ) {
			// 閏年の確認
			if ( ( $year % 400 ) == 0 ) {
				return true;
			} else if ( ( $year % 100 ) == 0 ) {
				return false;
			} else if ( ( $year % 4 ) == 0 ) {
				return true;
			} else {
				return false;
			}
		} else if ( $month == 2 && $day > 29 ) {
			return false;
		} else if ( ( $month == 4 || $month == 6 || $month == 9 || $month == 11 )
					 && $day == 31 ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 渡された年月日フォーマットがカレンダーで有効な日付であるか検査します。
	 * 有効であればtrue、無効であればfalseを返します。
	 * @param $date_strings 日付フォーマット文字列
	 * @return boolean 有効であればtrue、無効であればfalse
	 */
	function isAvailableDateFormat( $date_string ) {
		list( $year, $month, $day )	= explode('-',$date_string);
		return isAvailableDate( $year, $month, $day );
	}
	/**
	 * 電話番号の書式チェックを行います
	 */
	function validateTelephoneNumber( &$request, $telephone_area_code, $telephone_city_code, $telephone_code, $item_name ) {
		$telephone_len		= strlen( $telephone_area_code ) 
								+ strlen( $telephone_city_code )  
								+ strlen( $telephone_code );
		if ( $telephone_len == 0 ) {
			$telephone_area_code 	= ""; 
			$telephone_city_code 	= ""; 
			$telephone_code			= "";
			$telephone_number		= "";
		} elseif ( $telephone_len > 0 ) {
			if ( strlen( $telephone_area_code) == 0 
					|| strlen( $telephone_city_code) == 0 
					|| strlen( $telephone_code) == 0 ) {
				$request->addError($item_name.'は市外局番・市内局番・局番を全て半角数字で入力してください。');
			} else {
				$telephone_number	= $telephone_area_code
										. "-" . $telephone_city_code
										. "-" . $telephone_code;
				
				if( !preg_match('/^[0-9]{1,5}$/',$telephone_area_code) ) {
					$request->addError($item_name.'(市外局番)は半角数字のみで入力してください。');
				}
				if( !preg_match('/^[0-9]{1,5}$/',$telephone_city_code) ) {
					$request->addError($item_name.'(市内局番)は半角数字のみで入力してください。');
				}
				if( !preg_match('/^[0-9]{1,5}$/',$telephone_code) ) {
					$request->addError($item_name.'(局番)は半角数字のみで入力してください。');
				}
				if( !$request->isError() ) {
					$telephone_number = $telephone_area_code . "-" . $telephone_city_code . "-" . $telephone_code;
				}
			}
		}
		return $telephone_number;
	}
}
?>