<?php
/*
 * spider.inc.php
 * @version 1.0.01
 * 
 * if you need, change $DIR_PATH_SPIDER_DATA for your Env.
 */
/* Data Directory Absolute Path force */
//$DIR_PATH_SPIDER_DATA			= '';
/* Base URI force definition */
//$SPIDER_DEFINE_BASE_URI		= '';
/* active page file folder   */
define('DIR_NAME_PAGES', 'pages');

/*
 * Common Process. you need not to edit.
 */
$script_filename	= str_replace( '/', DIRECTORY_SEPARATOR, $_SERVER['SCRIPT_FILENAME'] );
if ( $script_filename == __FILE__ ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'You can\'t access this file direct!' );
}
/*
 * application base path
 */
define( 'APPLICATION_BASE_PATH', dirname(__FILE__ ) );
/*
 * If spider folder is not defined, search spider folder.
 */
if( !isset( $DIR_PATH_SPIDER_DATA ) || strlen( trim( $DIR_PATH_SPIDER_DATA ) ) == 0 ) {
	$DIR_PATH_SPIDER_DATA	= null;
	$targetDir				= dirname(__FILE__);
	$rootPathLength			= 1;
	if(isset($_ENV) && isset($_ENV['OS']) && preg_match('/[wW][iI][nN]/',$_ENV['OS'] ) > 0 ) {
		$rootPathLength	= 3;
	}
	while( strlen($targetDir) > $rootPathLength ) {
		$DIR_PATH_SPIDER_DATA	= $targetDir.DIRECTORY_SEPARATOR.'spider';
		if( is_dir( $DIR_PATH_SPIDER_DATA ) ) {
			break;
		} else {
			$DIR_PATH_SPIDER_DATA	= null;
		}
		$targetDir	= dirname($targetDir);
	}
	if( is_null($DIR_PATH_SPIDER_DATA) ) {
		$targetDir				= dirname(__FILE__);
		while( strlen($targetDir) > $rootPathLength ) {
			$DIR_PATH_SPIDER_DATA	= $targetDir.DIRECTORY_SEPARATOR.'DATA';
			if( is_dir( $DIR_PATH_SPIDER_DATA ) ) {
				break;
			} else {
				$DIR_PATH_SPIDER_DATA	= null;
			}
			$targetDir	= dirname($targetDir);
		}
	}
	unset($targetDir);
	unset($rootPathLength);
	if( is_null( $DIR_PATH_SPIDER_DATA ) ) {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( 'Spider DATA Folder is not found!' );
	} else {
		define ( 'DIR_PATH_SPIDER_DATA',	$DIR_PATH_SPIDER_DATA );
	}
} else {
	define ( 'DIR_PATH_SPIDER_DATA',	$DIR_PATH_SPIDER_DATA );
}
/*
 * If spider folder is found, require define.inc.php
 */
$spiderDefinePath	= DIR_PATH_SPIDER_DATA.DIRECTORY_SEPARATOR.'define.inc.php';
if( defined('DIR_PATH_SPIDER_DATA') && is_dir(DIR_PATH_SPIDER_DATA) && file_exists($spiderDefinePath) ) { 
	require_once( $spiderDefinePath );
} else {
		header( 'Content-type: text/plain;charset=UTF-8' );
		die( 'Spider DATA Folder is invalid!' );
}
/*
 * folder & uri
 */
$request_uri			= $_SERVER['REQUEST_URI'];
$document_root			= $_SERVER['DOCUMENT_ROOT'];

/* formart user document root */
if( preg_match('/^\\/\\~[0-9a-zA-Z\\_]+\\//',$request_uri) > 0 ) {
	$user_request_uri	= preg_replace('/^\\/\\~[^\\/]+\\//','/',$_SERVER['PHP_SELF'] );
	$document_root		= str_replace( '/',DIRECTORY_SEPARATOR, dirname($script_filename) );
	$document_root		= str_replace( str_replace( '/',DIRECTORY_SEPARATOR, dirname($user_request_uri) ), '', $document_root );
}
/*
 * if not defined, create application base uri.
 */
if( defined('APPLICATION_PROXY_REV_HOST') && strlen(APPLICATION_PROXY_REV_HOST) > 0
	&& ( APPLICATION_PROXY_REV_HOST == $_SERVER['HTTP_X_FORWARDED_HOST']
		|| APPLICATION_PROXY_REV_HOST == $_SERVER['HTTP_X_FORWARDED_SERVER'] ) ) {
	// リバースプロキシホスト名が設置されていてそこからのアクセスの場合
	define( 'APPLICATION_BASE_URL', APPLICATION_PROXY_REV_BASE_URL );
	define( 'APPLICATION_NML_URL', APPLICATION_PROXY_REV_NML_URL );
	define( 'APPLICATION_SSL_URL', APPLICATION_PROXY_REV_SSL_URL );
	define( 'APPLICATION_BASE_URI', APPLICATION_PROXY_REV_BASE_URI );
} else if( !defined('APPLICATION_BASE_URI') ) {
	$app_base_uri	= null;
	if( isset($SPIDER_DEFINE_BASE_URI) && strlen($SPIDER_DEFINE_BASE_URI) > 0 ) {
		$app_base_uri		= $SPIDER_DEFINE_BASE_URI;
	} else {
		$spider_inc_path		= str_replace( DIRECTORY_SEPARATOR, '/', __FILE__ );
		$app_base_uri		= dirname(str_replace( $document_root, '', $spider_inc_path ));
		if( preg_match('/^\\/\\~[0-9a-zA-Z\\_]+\\//',$request_uri) > 0 ) {
			// if user dir, unshift first folder
			$dirname_array		= explode('/',$request_uri);
			$app_base_uri	= '/'.$dirname_array[1].$app_base_uri;
		}
		if( preg_match('/^\\./',$app_base_uri) > 0 ) {
			// if first char is '.', remove.
			$app_base_uri	= preg_replace('/^\\./','',$app_base_uri);
		}
	}
	if( preg_match('/\\/$/', $app_base_uri ) == 0 ) {
		$app_base_uri	.= '/';
	}
	if ( preg_match( '/^\\//', $app_base_uri ) == 0 ) {
		$app_base_uri 	= '/'.$app_base_uri;
	}
	define( 'APPLICATION_BASE_URI',  $app_base_uri );
	unset($app_base_uri);
}

$request_protocol		= $_SERVER['SERVER_PROTOCOL'];
$request_port			= $_SERVER['SERVER_PORT'];
$request_server_name	= $_SERVER['SERVER_NAME'];
$is_ssl					= false;
if( isset($_SERVER['HTTPS']) && preg_match('/[oO][fF][fF]/', $_SERVER['HTTPS'] ) == 0 ) {
	$is_ssl				= true;
}
$prtcl = 'http://';
if( $is_ssl ) {
	$prtcl = 'https://';
}
$target_port = '';
if ( $request_port != 80 && $request_port != 443 ) {
	$target_port	= ':' . $request_port;
}
if( !defined('APPLICATION_BASE_URL') ) {
	$app_base_url	= $prtcl . $request_server_name . $target_port . APPLICATION_BASE_URI;
	define( 'APPLICATION_BASE_URL', $app_base_url );
}
if( !defined('APPLICATION_NML_URL') ) {
	$app_nomal_url	= 'http://' . $request_server_name . $target_port . APPLICATION_BASE_URI;
	define( 'APPLICATION_NML_URL', $app_nomal_url );
}
if( !defined('APPLICATION_SSL_URL') ) {
	$app_ssl_url	= 'https://' . $request_server_name . $target_port . APPLICATION_BASE_URI;
	define( 'APPLICATION_SSL_URL', $app_ssl_url );
}

unset($app_base_url);
unset($app_nomal_url);
unset($app_ssl_url);
require_once( DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . 'spider_main.inc.php' );

?>