<?php
/**
 * HTML用変換タグ:ページタイトルタグ
 * 
 * {page-title:[ページタイトル文言]}で、モジュール実行に優先して
 * ページタイトルをpage_titleという属性名でrequestに登録します。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_PageTitle extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_PageTitle() {
		$this->priority	= 60;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		$page_title	= '';
		// ページ名指定行を取得
		if( preg_match_all( '/\\{page\\-title\\:[^\\}]*?\\}/'
			, $result_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$page_title	= preg_replace( '/\\{page\\-title\\:/','', $target );
					$page_title	= preg_replace( '/\\}/','', $page_title );
					$result_strings = str_replace( "\n".$target."\n", "", $result_strings );
					$result_strings = str_replace( $target, "", $result_strings );
					$page_title	= trim($page_title);
				}
			}
		}
		// 前処理追加:ページタイトルを属性にセット
		$process_code	= '$page_title="'.str_replace("'","\\'",$page_title).'";'."\n";
		$process_code	.= '$request_object->setAttribute("page_title",$page_title );'."\n";
		if( !isset($build_information->preview_process_hash)
			|| !is_array($build_information->preview_process_hash) ){
			$build_information->preview_process_hash	= array();
		}
		if( !isset($build_information->preview_process_hash[$this->priority])
			|| !is_array($build_information->preview_process_hash[$this->priority]) ){
			$build_information->preview_process_hash[$this->priority]	= array();
		}
		array_push( $build_information->preview_process_hash[$this->priority], $process_code );
	}
}
?>