<?php
/**
 * ユーティリティ：ユーザーエージェントから携帯端末種別を解析・保持するユーティリティオブジェクト
 * 
 * @package util ユーティリティパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class MobileTerminal {
	var $agent;
	var $terminal_name;
	var $terminal_id;
	var $carrier;
	var $html_flag;
	var $sim_id;
	
	function MobileTerminal($agent) {
		$this->agent = $agent;
		$this->html_flag = "h";
		if ( ereg( "^DoCoMo", $agent ) ) {
			$this->carrier = "d";
			$this->perseSubscririberIdFromDoCoMo();
		} else if ( ereg( "^J\\-PHONE", $agent ) ) {
			$this->carrier = "v";
			$this->perseSubscririberIdFromVodafone();
		} else if ( ereg( "^Vodafone", $agent ) ) {
			$this->carrier = "v";
			$this->perseSubscririberIdFromVodafone();
		} else if ( ereg( "^SoftBank", $agent ) ) {
			$this->carrier = "s";
			$this->perseSubscririberIdFromVodafone();
		} else if ( ereg( "^KDDI\\-", $agent ) ) {
			$this->carrier = "a";
			$this->terminal_id = $_SERVER['HTTP_X_UP_SUBNO'];
			$this->html_flag = "x";
			list( $this->terminal_name, $etc )	= explode( ' ', $agent );
		} else if ( ereg( "^^UP\\.Browser\\/[0-9\\.]+\\-", $agent ) ) {
			$this->carrier = "a";
			$this->terminal_id = $_SERVER['HTTP_X_UP_SUBNO'];
			$this->html_flag = "d";
			list( $this->terminal_name, $etc )	= explode( ' ', $agent );
			list( $pre, $this->terminal_name )	= explode( '-', $this->terminal_name );
		} else {
			return false;
		}
	}

	function perseSubscririberIdFromDoCoMo() {
		if ( ereg( "DoCoMo\\/1.0", $this->agent ) ) {
			$this->terminal_name	= $this->agent;
			$str = substr( $this->agent, strpos( $this->agent, "/ser" ) );
			$this->terminal_id = str_replace( "/ser", "", $str );
		} else {
			$this->terminal_name	= substr( $this->agent, 0, strpos( $this->agent, "(" ) );
			$str = substr( $this->agent, strpos( $this->agent, "(" ) );
			$str = substr( $this->agent, 0, strpos( $this->agent, ")" ) );
			$val_array = explode( ";", $str );
			foreach ( $val_array as $val ) {
				if ( ereg( "ser", $val ) ) {
					// ser
					$this->terminal_id = str_replace( "ser", "", $val );
				} else if ( ereg( "icc", $val ) ) {
					// icc
					$this->sim_id = str_replace( "icc", "", $val );
				}
			}
		}
	}
	function perseSubscririberIdFromVodafone() {
		$val_array	= explode( "/", $this->agent );
		$tid_str	= "";
		foreach ( $val_array as $val ) {
			if ( ereg( "^SN", $val ) ) {
				$tid_str = $val;
				list( $sn, $browser ) = explode( " ", $tid_str );
				$this->terminal_id = str_replace( "SN", "", $sn );
				break;
			}
			if(strlen($this->terminal_name)>0){
				$this->terminal_name	.= "/";
			}
			$this->terminal_name	.= $val;
		}
	}
	function getMessage() {
		return $this->message;
	}
}
?>