<?php
/*
 * framework-spider: コマンドプログラム用共通読み込みファイル
 */
// Framework Version
define( 'SPIDER_VERSION', '1.0.01' );
define ( 'DIR_PATH_SPIDER_DATA',	dirname(__FILE__) );

/* 設定ファイルの読み込み	*/
require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.inc.php' );
require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'messages.inc.php' );
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
// システムメール定義ファイルの読み込み
if( defined('FILE_PATH_SYSTEM_DEFINITION') && file_exists( FILE_PATH_SYSTEM_DEFINITION ) ){
	require_once( FILE_PATH_SYSTEM_DEFINITION );
}

/* グローバル関数ファイル	*/
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider' 
	.DIRECTORY_SEPARATOR.'functions.inc.php' );

/* パーミッションの確認	*/
$errors	= spider_is_avairable_permittion();
if( count( $errors ) > 0 ) {
	header( 'Content-Type: text/plain;charset=UTF-8');
	echo "Core Error!!\n";
	foreach( $errors as $error ) {
		echo $error."\n";
	}
	die;
}

// 出力クラス
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider' 
	.DIRECTORY_SEPARATOR.'HttpOutput.class.php' );
$GLOBALS['output']		= new spider_HttpOutput();
// リクエストクラス
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider'
	.DIRECTORY_SEPARATOR.'HttpRequest.class.php' );
$GLOBALS['request']	= new spider_HttpRequest();
/* コントローラークラス	*/
require_once( DIR_PATH_LIB
	.DIRECTORY_SEPARATOR.'spider' 
	.DIRECTORY_SEPARATOR.'Controller.class.php' );
$GLOBALS['controller']	= new spider_Controller( $GLOBALS['request'], $GLOBALS['output'] );


// 出力文字コードの確認
mb_language('japanese');
mb_internal_encoding('UTF-8');
ob_start('mb_output_handler');
if( preg_match('/[wW][iI][nN]/',$_ENV['OS'] ) > 0 ) {
	mb_http_output('SJIS-win');
} else if( preg_match('/[eE][uU][cC][jJ][pP]/', $_ENV['LANG'] ) > 0 ) {
	mb_http_output('EUC_JP');
} else if( preg_match('/[uU][tT][fF]\\-8/', $_ENV['LANG'] ) > 0 ) {
	mb_http_output('UTF-8');
}
// phpのインストール種別を確認
$is_cli		= false;
if( preg_match('/[cC][lL][iI]/',php_sapi_name()) > 0 ) {
	$is_cli	= true;
} else if( preg_match('/[hH][aA][nN][dD][lL][eE][rR]/',php_sapi_name()) > 0 ) {
	header('Content-Type: text/plain; charset=UTF-8;');
	echo "Core Error!!\n";
	echo "this process called by php spi version.\n";
	echo "please call on commandline.\n";
	exit(0);
} else {
	echo "Core Error!!\n";
	echo "this process called by php unknown version.\n";
	echo "please call on commandline.\n";
	exit(0);
}

ob_implicit_flush( true );
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
?>