<?php
	include('./conf/default.php');
	include('./conf/tracking.php');
	include('./lib/ezuser.php');
	include('./lib/modules.php');

	class module extends base_module
	{
		function action($gps)
		{
		}
		function gpsOn($gps)
		{
		}
		function gpsOff($gps)
		{
		}
	}

	global $HTTP_GET_VARS;

	$ezuser = new ezuser();

	header('Content-Type: text/x-hdml;charser=Shift_JIS');

	$gps = array(
		'unit' => $HTTP_GET_VARS['unit'],	// Wn
		'datum' => $HTTP_GET_VARS['datum'],	// nn
		'lat' => $HTTP_GET_VARS['lat'],		// ܓx
		'lon' => $HTTP_GET_VARS['lon'],		// ox
		'alt' => $HTTP_GET_VARS['alt'],		// x
		'time' => $HTTP_GET_VARS['time'],	// 
		'smaj' => $HTTP_GET_VARS['smaj'],	// a덷
		'smin' => $HTTP_GET_VARS['smin'],	// Za덷
		'vert' => $HTTP_GET_VARS['vert'],	// x̌덷
		'majja' => $HTTP_GET_VARS['majja'],	// px
		'fm' => $HTTP_GET_VARS['fm']		// ʕ@
	);

	$modules = new modules(MODULE_DIR);
	if( $modules->init() )
	{
		foreach($modules->module_instance_array as $mod)
		{
			$mod->action($gps);
		}
?>

<HDML version=3.1 ttl=0 markable=TRUE>

	<!-- GPS ON -->
	<DISPLAY timerdefault="<?php echo(TRACKING_INTERVAL); ?>" name="gpsOn">
		<ACTION type="ontimer" task="go" dest="device:gpsone?<?php echo( 'url='.INDEX_FILE.'&ver=1&datum='.DATUM.'&unit='.UNIT_MODE); ?>">
		<ACTION type=SOFT1 task=GOSUB label="OFF" dest="#gpsOff">
		<ACTION type=ACCEPT task=NOOP>
		<CENTER><IMG src="resource/gpson.png"><BR>
		<CENTER>GPS ON<BR>
<?php
		foreach($modules->module_instance_array as $mod)
		{
			$mod->gpsOn($gps);
		}
?>
	</DISPLAY>

	<!-- GPS OFF -->
	<DISPLAY name="gpsOff">
		<ACTION type=SOFT1 task=RETURN label="ON">
		<ACTION type=ACCEPT task=NOOP>
		<CENTER><IMG src="resource/gpsoff.png"><BR>
		<CENTER>GPS OFF<BR>
		<BR>
<?php
		foreach($modules->module_instance_array as $mod)
		{
			$mod->gpsOff($gps);
		}
	}
?>
	</DISPLAY>

</HDML>
