using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using freetrain.world;
using freetrain.world.accounting;

namespace freetrain.views.bank
{
	/// <summary>
	/// BankCounterForm ̊Tv̐łB
	/// </summary>
	public class BankbookWindow : Form
	{
		#region generated by form editor
		private System.Windows.Forms.CheckBox cb_status;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage pgLoan;
		private System.Windows.Forms.TabPage pgDeposit;
		private System.Windows.Forms.ListView list_loan;
		private System.Windows.Forms.ListView list_cancel;
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		#endregion
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Label tl_status;

		private AccountManager manager { get { return World.world.account; } }
		private Clock clock { get { return World.world.clock; } }
		static private BankModule bank { get { return BankModule.theInstance; } }
		private BankBusinessHourListener bankListener;

		public BankbookWindow()
		{
			InitializeComponent();

			if( BankConfig.canBorrow )
				BankbookListHelper.buildDebtList(list_loan);
			else
				tabControl1.Controls.Remove(pgLoan);
			
			if( BankConfig.canDeposit )
				BankbookListHelper.buildDepositList(list_cancel);
			else
				tabControl1.Controls.Remove(pgDeposit);
			
			onBankStatusChanged();
			
			bankListener =  new BankBusinessHourListener(onBankStatusChanged);
			bank.onBusinesStatusChanging += bankListener;
		}
		
		private void onBankStatusChanged()
		{
			switch( BankModule.theInstance.status ) 
			{
				case BankStatus.HOLIDAY:
					tl_status.Text = "x";
					break;
				case BankStatus.OPEN:
					tl_status.Text = "c";
					break;
				case BankStatus.CLOSE:
					tl_status.Text = "X";
					break;
			}
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			bank.onBusinesStatusChanging -= bankListener;
			
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			BankbookListHelper.RemoveList(list_cancel);
			BankbookListHelper.RemoveList(list_loan);
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			this.cb_status = new System.Windows.Forms.CheckBox();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.pgLoan = new System.Windows.Forms.TabPage();
			this.list_loan = new System.Windows.Forms.ListView();
			this.pgDeposit = new System.Windows.Forms.TabPage();
			this.list_cancel = new System.Windows.Forms.ListView();
			this.tl_status = new System.Windows.Forms.Label();
			this.tabControl1.SuspendLayout();
			this.pgLoan.SuspendLayout();
			this.pgDeposit.SuspendLayout();
			this.SuspendLayout();
			// 
			// cb_status
			// 
			this.cb_status.AccessibleDescription = "Ăяo";
			this.cb_status.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.cb_status.Appearance = System.Windows.Forms.Appearance.Button;
			this.cb_status.BackColor = System.Drawing.SystemColors.Control;
			this.cb_status.Location = new System.Drawing.Point(400, 1);
			this.cb_status.Name = "cb_status";
			this.cb_status.Size = new System.Drawing.Size(64, 21);
			this.cb_status.TabIndex = 2;
			this.cb_status.Text = "s";
			this.cb_status.TextAlign = System.Drawing.ContentAlignment.BottomCenter;
			this.cb_status.CheckedChanged += new System.EventHandler(this.cb_status_CheckedChanged);
			// 
			// tabControl1
			// 
			this.tabControl1.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.tabControl1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.pgLoan,
																					  this.pgDeposit});
			this.tabControl1.Location = new System.Drawing.Point(0, 6);
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(472, 120);
			this.tabControl1.TabIndex = 3;
			// 
			// pgLoan
			// 
			this.pgLoan.Controls.AddRange(new System.Windows.Forms.Control[] {
																				 this.list_loan});
			this.pgLoan.Location = new System.Drawing.Point(4, 21);
			this.pgLoan.Name = "pgLoan";
			this.pgLoan.Size = new System.Drawing.Size(464, 95);
			this.pgLoan.TabIndex = 0;
			this.pgLoan.Text = "ؓ";
			// 
			// list_loan
			// 
			this.list_loan.Dock = System.Windows.Forms.DockStyle.Fill;
			this.list_loan.FullRowSelect = true;
			this.list_loan.GridLines = true;
			this.list_loan.HideSelection = false;
			this.list_loan.Name = "list_loan";
			this.list_loan.Size = new System.Drawing.Size(464, 95);
			this.list_loan.TabIndex = 10;
			this.list_loan.View = System.Windows.Forms.View.Details;
			// 
			// pgDeposit
			// 
			this.pgDeposit.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.list_cancel});
			this.pgDeposit.Location = new System.Drawing.Point(4, 21);
			this.pgDeposit.Name = "pgDeposit";
			this.pgDeposit.Size = new System.Drawing.Size(464, 95);
			this.pgDeposit.TabIndex = 1;
			this.pgDeposit.Text = "a";
			// 
			// list_cancel
			// 
			this.list_cancel.Dock = System.Windows.Forms.DockStyle.Fill;
			this.list_cancel.FullRowSelect = true;
			this.list_cancel.GridLines = true;
			this.list_cancel.HideSelection = false;
			this.list_cancel.Name = "list_cancel";
			this.list_cancel.Size = new System.Drawing.Size(464, 95);
			this.list_cancel.TabIndex = 27;
			this.list_cancel.View = System.Windows.Forms.View.Details;
			// 
			// tl_status
			// 
			this.tl_status.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.tl_status.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.tl_status.Location = new System.Drawing.Point(352, 0);
			this.tl_status.Name = "tl_status";
			this.tl_status.Size = new System.Drawing.Size(40, 22);
			this.tl_status.TabIndex = 4;
			this.tl_status.Text = "c";
			this.tl_status.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// BankbookWindow
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(472, 125);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.tl_status,
																		  this.cb_status,
																		  this.tabControl1});
			this.MinimumSize = new System.Drawing.Size(248, 104);
			this.Name = "BankbookWindow";
			this.Text = "Ɨa";
			this.tabControl1.ResumeLayout(false);
			this.pgLoan.ResumeLayout(false);
			this.pgDeposit.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void cb_status_CheckedChanged(object sender, System.EventArgs e)
		{
			if( cb_status.Checked ) 
			{
				BankCounterForm.ShowBankCounter();
				cb_status.Checked = false;
			}
		}

	}
}
