.\"
.\" $Id: cvtxim.man,v 1.1.1.1 2000/01/16 05:07:58 ura Exp $
.\"

.\" FreeWnn is a network-extensible Kana-to-Kanji conversion system.
.\" This file is part of FreeWnn.
.\" 
.\" Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
.\" Copyright 1992 by Massachusetts Institute of Technology
.\"
.\" Author: OMRON SOFTWARE Co., Ltd. <freewnn@rd.kyoto.omronsoft.co.jp>
.\"
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2, or (at your option)
.\" any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with GNU Emacs; see the file COPYING.  If not, write to the
.\" Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" Commentary:
.\"
.\" Change log:
.\"
.\" Last modified date: 8,Feb.1999
.\"

.TH CVTXIM 4 "Release 5" "X Version 11"
.SH NAME
cvt_xim_tbl \- key conversion table of Input Manager of the X
Window System Version 11 (xwnmo(1X))
.SH SYNOPSIS
.B /usr/local/lib/wnn/cvt_xim_tbl
(Default)
.SH DESCRIPTION
Converts a key code(\fIKeySym\fP) generated by \fIXLookupString()\fP
to a one-byte character(\fIWnn code\fP) according to preset data.
.PP
.TP 8
.B Coding format:
[ \fIState-or-KeySym\fP <space_character> \fPWnn-code\fP ]
.br
\fIState-or-KeySym\fP = [\fIStates\fP]\fIKeySym-name\fP
.br
\fIStates\fP = \fIState-name\fP'\fI|\fP'[\fIStates\fP]
.PP
Lines that start with a semicolon (;) are comments.
.PP
KeySym-name is a string declared in keysymdef.h (except the prefix "XA_").
.TP 8
State-name is one between the following string.
"Shift"   ---> means ShiftMask
.br
"Ctrl"    ---> means ControlMask
.br
"Meta"    ---> means Mod1Mask
.br
"Meta1"   ---> means Mod1Mask (same as "Meta")
.br
"Meta2"   ---> means Mod2Mask
.br
"Meta3"   ---> means Mod3Mask
.br
"Meta4"   ---> means Mod4Mask
.br
"Meta5"   ---> means Mod5Mask
.br
.TP 8
.B Code notation:
0??             ---> Octal
.br
0x?? or 0X??    ---> Hexadecimal
.br
??              ---> Decimal
.SH EXAMPLE
Meta|Left            0x9A
.br
Meta|Up              0x99
.br
Meta|F11             0x95
.br
Meta|minus           0x81
.br
Meta|asciicircum     0x82
.br
Kanji                0x81
.br
F1                   0x91
.br
F2                   0x90
.br
Meta|Shift|F1        0x91
.SH NOTES
In case of old version \fIxwnmo\fP, key codes are converted with
\fIcvt_fun_tbl\fP and \fIcvt_meta_tbl\fP. For compatibility,
those files are available if those are specified by option or
resource. In this case, those two files are loaded before
the loading of \fIcvt_xim_tbl\fP. If duplicate definition is
occurred, a warning message will be printed and the definition
in those two files will be taken precedence.

Codes converted according to this table will be evaluated by \fI2A_CTRL\fP
(default), which is an alphanumeric-phonetic conversion automation table. 
After which, they are evaluated by \fIuumkey\fP.
.SH "SEE ALSO"
xwnmo(1X), 2A_CTRL(4_JT), uumkey(4_JT)
.SH COPYRIGHT
Copyright 1992 by OMRON Corporation
.br
Copyright 1992 by Massachusetts Institute of Technology
.SH AUTHOR
Seiji Kuwari (OMRON Corporation)
.SH EXAMPLE
