<?php
require_once 'MailDecoder.class.php';
require_once 'MailSender.class.php';
require_once 'MDB2.php';
include('config.php');

try {
    // 標準入力からメールデータを取得
    $raw_mail = stream_get_contents(STDIN);
    // MailDecoderクラスでメールデータを解析
    $decoder =& new MailDecoder($raw_mail);
    // メール件名を取得
    $subject = $decoder->getDecodedHeader('subject');
    // メール本文を取得
    $body = $decoder->getBodyText();
    // 送信元メールアドレスを取得
    $fromAddress = $decoder->getFromAddress();
    // 添付ファイルを取得
    $attachments = $decoder->getAttach();
    
    // 保存する画像名
    $image_name = "";
    // 一意な名前にするためのID
    $uniq = uniqid();
    
    // 添付ファイル情報を取得して拡張子を判別する
    $data = pathinfo($attachments[0]['name']);
    $ext = $data['extension'];
    // 保存する画像名
    $image_name = $uniq .'.'. $ext;
    // 保存する画像パス
    $image_path = $image_dir. $image_name;
    // 画像を保存
    if($fp=fopen($image_path, "wb")){
        fwrite($fp, $attachments[0]['binary']);
        fclose($fp);
        chmod($image_path, 0775);
    }
    
    // メール情報をDBに保存
    $pdo = new PDO("{$dbType}:host={$MYSQL_HOST}; dbname={$MYSQL_DATABASE}","{$MYSQL_USER}", "{$MYSQL_PASSWORD}");
    $stmt = $pdo->prepare("INSERT INTO mail (hash,subject,body,image_name,created_date) VALUES(:HASH, :SUBJECT, :BODY, :IMAGE_NAME, :DATE)");
    $stmt->bindValue(':HASH', $uniq);
    $stmt->bindValue(':SUBJECT', $subject);
    $stmt->bindValue(':BODY', $body);
    $stmt->bindValue(':IMAGE_NAME', $image_name);
    $stmt->bindValue(':DATE', date('Y-m-d H:i:s'));
    $stmt->execute();
    
    // メール送信
    $subject = "投稿を完了してください";
    $body = "以下のURLより投稿を完了してください。\nhttp://[ドメイン]/gps.php?hash={$uniq}&guid=ON";
    $m = new MailSender();
    $m->send('送信者名','送信元アドレス', $subject, $body, $fromAddress); 

} catch (Exception $e) {
        $error_log = "[" . date("Y/m/d H:i:s") . "] \n";
        $error_log .= "【ErrorInfo】\n";
        $error_log .= "Code    : " . $e->getCode() . "\n";
        $error_log .= "Message : " . $e->getMessage() . "\n";
        
        $m = new MailSender();
        $m->send('送信者名','送信元アドレス', 'Error',$error_log,$fromAddress); 
}
?>
