<?php
///////////////////////////////////////////////////////////////////////////
// (Shirai157): ”このコンテンツを電子メール送信するボタン”機能の追加 (2009/07/04)
///////////////////////////////////////////////////////////////////////////

    require_once('../../config.php');
    require_once($CFG->dirroot.'/mod/forum/lib.php');

    require_login();
    if (isguest()) {
        error('Guest user is not allowed to execute this operation...');
    }
    $type  = optional_param('type', '', PARAM_ALPHA); // forum, wiki, blog...

// フォーラム投稿をメールで自分自身に送信する
function send_this_post_to_me($course, $forum, $discussion, $post, $userfrom, $userto)
{
    global $CFG;

    $urlinfo = parse_url(public_wwwroot());
    $hostname = $urlinfo['host'];

    $cleanforumname = str_replace('"', "'", strip_tags(format_string($forum->name)));

    $userfrom->customheaders = array (  // Headers to make emails easier to track
               'Precedence: Bulk',
               'List-Id: "'.$cleanforumname.'" <moodleforum'.$forum->id.'@'.$hostname.'>',
               'List-Help: '.public_wwwroot().'/mod/forum/view.php?f='.$forum->id,
               'Message-ID: <moodlepost'.$post->id.'@'.$hostname.'>',
               'In-Reply-To: <moodlepost'.$post->parent.'@'.$hostname.'>',
               'References: <moodlepost'.$post->parent.'@'.$hostname.'>',
               'X-Course-Id: '.$course->id,
               'X-Course-Name: '.format_string($course->fullname, true)
    );

    $postsubject = "$course->shortname: ".format_string($post->subject,true);
    $posthtml = forum_make_mail_html($course, $forum, $discussion, $post, $userfrom, $userto);
    $posttext = forum_make_mail_text($course, $forum, $discussion, $post, $userfrom, $userto);

    // Send the post now!

    $mailresult = email_to_user($userto, $userfrom, $postsubject, $posttext,
                                $posthtml, '', '', $CFG->forum_replytouser);
    return $mailresult;
}

// ブログURLをメールで自分自身に送信する
function send_this_blog_to_me($blogdata, $userfrom, $userto)
{
    global $CFG;

    $posttext  = $blogdata->subject.': '. $blogdata->url."\n";
    $posthtml  = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">';
    $posthtml .= '<html><head><meta http-equiv="Content-Type" content="text/html" />';
    $posthtml .= '<title>Blog: '.$blogdata->subject.'</title></head><body>';
    $posthtml .= '<a href="'.$blogdata->url.'">'.$blogdata->subject.'</a>&nbsp;('.$blogdata->url.')';
    $posthtml .= '</body></html>';

    $mailresult = email_to_user($userto, $userfrom, 'Blog:'.$blogdata->subject, $posttext, $posthtml);
    return $mailresult;
}

// Wikiや用語集のURLをメールで自分自身に送信する
function send_this_url_to_me($type, $data, $userfrom, $userto)
{
    global $CFG;

    $type = ucfirst($type);
    $posttext  = $data->subject.': '. $data->url."\n";
    $posthtml  = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">';
    $posthtml .= '<html><head><meta http-equiv="Content-Type" content="text/html" />';
    $posthtml .= '<title>'.$type.': '.$data->subject.'</title></head><body>';
    $posthtml .= '<a href="'.$data->url.'">'.$data->subject.'</a>&nbsp;('.$data->url.')';
    $posthtml .= '</body></html>';

    $mailresult = email_to_user($userto, $userfrom, $type.':'.$data->subject, $posttext, $posthtml);
    return $mailresult;
}

    global $USER;
    $mailresult = false;
    $subject = '';
    $userto   = $USER;
    if ($type == 'forum') {
        $d      = required_param('d', PARAM_INT);                // Discussion ID
        $postid = optional_param('postid', 0, PARAM_INT);        // Used for tracking read posts if user initiated.
        if (($post = fs_get_record('forum_posts', 'id', $postid)) && 
            ($discussion = fs_get_record('forum_discussions', 'id', $d)) &&
            ($forum = fs_get_record('forum', 'id', $discussion->forum)) &&
            ($course = fs_get_record('course', 'id', $forum->course))) {
//          if ($userfrom = get_record('user', 'id', $post->userid)) {
//              $mailresult = send_this_post_to_me($course, $forum, $discussion, $post, $userfrom, $userto);
                $mailresult = send_this_post_to_me($course, $forum, $discussion, $post, $userto, $userto);
//          }
            $subject = $post->subject;
        }
    } else if ($type == 'blog') {
        $postid = optional_param('postid', 0, PARAM_INT);        // Used for tracking read posts if user initiated.
        if ($post = fs_get_record('post', 'id', $postid)) {
            $blogdata->subject = format_string($post->subject);
            $blogdata->url     = public_wwwroot().'/blog/index.php?postid='.$postid;
            $mailresult = send_this_blog_to_me($blogdata, $userto, $userto);
            $subject = $blogdata->subject;
        }
    } else if ($type == 'wiki') {
        $id = optional_param('id', 0, PARAM_INT);
        $page = optional_param('page', null, PARAM_RAW);
        $wikidata->subject = format_string($page);
        $wikidata->url     = public_wwwroot().'/mod/wiki/view.php?id='.$id.'&page='.rawurlencode($page);
        $mailresult = send_this_url_to_me($type, $wikidata, $userto, $userto);
        $subject = $wikidata->subject;
    } else if ($type == 'glossary') {
        $id      = optional_param('id', 0, PARAM_INT);
        $concept = optional_param('concept', null, PARAM_RAW);
        $concept = rawurldecode($concept);
        $glossarydata->subject = $concept;
        $glossarydata->url     = public_wwwroot().'/mod/glossary/view.php?id='.$id.'&show='.rawurlencode($concept);
        $mailresult = send_this_url_to_me($type, $glossarydata, $userto, $userto);
        $subject = $glossarydata->subject;
    } else {
        error('Type : '.$type.'is unknown...');
    }
    if (!$mailresult) {
        echo '<b> "'.$subject.'":</b>&nbsp;'.get_string('cannotsentemail2you', 'fs_moodle', fullname($userto));
    } else if ($mailresult === 'emailstop') {
        echo '<b> "'.$subject.'":</b>&nbsp;'.get_string('sentemail2emailstop', 'fs_moodle', fullname($userto));
    } else {
        echo '<b> "'.$subject.'":</b>&nbsp;'.get_string('sentemail2you', 'fs_moodle', fullname($userto));
    }

    output_CloseWindowButton(true, false);

?>
