<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_fsCharset()
{
    global $fsCFG, $CFG;
    global $fs_CFG_strings;

    print_section_header('ファイルシステムの文字コードに関する設定');

    // 【現在のファイルシステムの文字コード($fsCFG->fsCharset)】 (fsCharset)
    print_subsection_header_fs_cfg('fsCharset');
    if (!isset($fsCFG->fsCharset)) {
        echo color_red('大変です！ $fsCFG->fsCharsetが設定されていません．');
        newline();
        print_subsection_footer();
        print_section_footer();
        return;
    }
    echo '<ul>';
    echo '<li>Moodle1.8以降，サーバのカレント文字コードは'.color_blue('UTF-8').'で固定です．</li>';
    echo '<li>あなたの選択したファイルシステム文字コードは';
    echo color_blue(!empty($fsCFG->fsCharset) ? $fsCFG->fsCharset : 'false').'です．</li>';
    echo '</ul>';
    echo '　Moodleは上記のカレント文字コードを用いて，これから操作したいファイルやフォルダの名前をPHPに与えます．';
    echo 'もしご利用のサーバOSがカレント文字コードを用いてファイルやフォルダの作成が可能であるならば問題はありませんが，';
    echo 'サーバOSが日本語Windows（Server含む）の場合は大問題が発生します．';
    echo '日本語Windowsのファイルシステムをアクセスする標準のAPIはマルチバイト文字の文字コードとしてシフトJISしか受け付けません．';
    echo 'このようにサーバOSのファイルシステムに制限がある場合，MoodleからPHPに渡されるファイル名／フォルダ名の文字コードを';
    echo 'サーバOSが受け付けられる文字コードに変換する必要があります．';
    newline();
    echo '　もし，日本語版Windows（Server含む）をサーバOSとして用いているならば';
    echo color_blue('SJIS-WIN').'を，それ以外のOSの場合は'.color_blue('false').'を選ぶことを薦めます．';
    newline();
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('fsCharset');
    echo '　現在の設定値は'.color_blue(bool2string($fsCFG->fsCharset)).'です．';
    if ($fsCFG->fsCharset === false) {
        echo 'したがって，ファイル名／フォルダ名の文字コード変換を行いません．';
        newline();
        echo '　ファイルシステム関数をオーバーライドする際のオーバーヘッドが最小になるように，';
        echo 'fs_override.phpではなく，fs_no_override.phpをインクルードします．';
        echo 'UTF-8化されたMoodle(Moodle1.6以降)においてはUTF-8の設定と実質的に等価です．';
        newline();
        if ($CFG->ostype === 'WINDOWS') {
            echo '　もしサーバOSに日本語Windowsを使用している場合はファイル名／フォルダ名が化けてしまい，';
            echo '正しく作成できない恐れがあります．';
            echo 'どうやらサーバOSは'.color_blue('Windows系').'のOSのようです．';
            echo color_red('SJIS-WINの設定を薦めます').'．';
            newline();
        } else {
            echo '　サーバOSはどうやら'.color_blue('非Windows系').'のようですね．';
            echo 'もしLinux, Mac OSなどの';
            echo color_blue('ファイルシステムとしてUTF-8文字コードを使用可能なOSの場合は最適な設定').'です．';
            echo '（でも，falseは...と心配な方にはUTF-8の設定をお勧めします．）';
            newline();
        }
    } else {
        switch ($fsCFG->fsCharset) {
            case 'SJIS-WIN':
                echo 'したがって，ファイル名／フォルダ名を'.color_blue('UTF-8').'から'.color_blue('シフトJISコード').'に変換します．';
                if ($CFG->ostype !== 'WINDOWS') {
                    echo '　もしOSが日本語Windowsではなく，ファイルシステムでUTF-8を使用可能なOSを';
                    echo 'サーバOSとして使用しているのであれば，';
                    echo color_red('UTF-8の設定を強く薦めます').'．';
                } else {
                    echo '　もしサーバとして使用しているOSが';
                    echo color_blue('日本語Windows(Server含む)であるならば最適な設定').'です';
                    echo '（ただし仕様上，シフトJISコードに含まれない文字をファイル名／フォルダ名に使うことはできません)．';
                }
                break;
            case 'WINDOWS':
                echo 'したがって，ファイル名／フォルダ名を'.color_blue('UTF-8').'から$fsCFG->fswincharsetで設定した文字コード';
                echo '（'.color_blue($fsCFG->fswincharset).'）に変換します．';
                newline();
                echo '　日本語Windows以外のWindowsをサーバOSとして用いる場合を想定した設定です．';
                if ($CFG->ostype !== 'WINDOWS') {
                    newline();
                    echo '　もしサーバOSがWindowsではないならばあまり意味の無い設定です．';
                    echo 'ただし，$fsCFG->fswincharsetに設定した（mb_convert_encoding()で利用可能な）文字コードに';
                    echo 'ファイル名／フォルダ名を変換する仕組みですので，特殊なシステム向けに敢えてチャレンジするには';
                    echo '良い方法（最終手段）かも知れませんね．';
                }
                break;
            case 'UTF-8':
                echo 'したがって，ファイル名／フォルダ名を'.color_blue('UTF-8').'からUTF-8に変換します．';
                newline();
                echo '　一見，無駄な設定に見えるかも知れませんが，';
                echo 'UTF-8からUTF-8への変換を内部では実際には行いませんので大丈夫です．';
                echo 'ファイルシステム関数をオーバーライドする際のオーバーヘッドが最小になるように，';
                echo 'fs_override.phpではなく，fs_no_override.phpをインクルードします．';
                echo 'UTF-8化されたMoodle(Moodle1.6以降)においてはfalseの設定と実質的に等価です．';
                newline();
                if ($CFG->ostype === 'WINDOWS') {
                    echo '　もしサーバOSに日本語Windowsを使用している場合はファイル名／フォルダ名が化けてしまい，';
                    echo '正しく作成できない恐れがあります．';
                    echo color_red('SJIS-WINの設定を強く薦めます').'．';
                } else {
                    echo '　もしLinux, Mac OSなどの';
                    echo color_blue('ファイルシステムとしてUTF-8文字コードを使用可能なOSの場合は最適な設定').'です．';
                }
                break;
            case 'RAWURL':
            case 'UTF-16':
            case 'EUC-JP':
                echo 'したがって，ファイル名／フォルダ名を'.color_blue('UTF-8').'から指定された文字コードに変換します．';
                echo 'ただし，この設定は試験的に設けたものであり，十分な検証を行っていません．';
                break;
            default:
                echo '<B>設定が正しくありません？？？　通常このような設定はあり得ません．</B>';
                echo color_red('何らかの異常事態が生じています').'．';
            break;
        }
    }
    print_fs_cfg_condition('fsCharset');
    print_subsection_footer();

    // 【以前のファイルシステムの文字コード（環境移行用）($fsCFG->oldfsCharset)】 (oldfsCharset)
    print_subsection_header_fs_cfg('oldfsCharset');
    echo '　この設定は環境移行用のための設定です．';
    echo '$fsCFG->fsCharsetで設定した文字コードとは異なる文字コードで作成してしまったフォルダ／ファイルを';
    echo '新しく設定した文字コードの名前に変更する機能のためだけに存在する設定です．';
    echo '新しくfs_moodleをインストールした場合はほとんど意味がありませんが，UTF-8の設定を薦めます．';
    echo 'UTF-8を設定しておけば，fs_moodleでfs化し忘れたファイルシステム関数で作成されてしまったフォルダ／ファイル名';
    echo '（UTF-8で作成される）を復旧できる可能性があるためです．';
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('oldfsCharset');
    echo '　現在は，';
    if ($fsCFG->oldfsCharset === false) {
        echo color_blue('false').'が指定されています．UTF-8の設定を勧めます．';
    } else {
        switch ($fsCFG->oldfsCharset) {
            case 'SJIS-WIN':
            case 'WINDOWS':
                echo color_blue($fsCFG->oldfsCharset).'が設定されています．';
                echo '特別な事情が無い限りは，UTF-8の設定を勧めます．';
                break;
            case 'UTF-8':
                echo color_blue('UTF-8').'が設定されています．';
                echo '特別な事情が無い限りはこのままのご利用を勧めます．';
                break;
            case 'RAWURL':
            case 'UTF-16':
            case 'EUC-JP':
                echo color_blue($fsCFG->oldfsCharset).'が設定されています．';
                echo 'この設定は試験的に設けたものであり，十分な検証を行っていません．';
                echo '特別な事情が無い限りは，UTF-8の設定をお勧めします．';
                break;
            default:
                echo color_blue($fsCFG->oldfsCharset).'が設定されています．';
                echo '設定が正しくありません？？？　通常このような設定はあり得ません．';
                echo color_red('何らかの異常事態が生じています').'．';
            break;
        }
    }
    print_fs_cfg_condition('oldfsCharset');
    print_subsection_footer();

    // 【Windowsのファイルシステム文字コードの設定($fsCFG->fswincharset)】 (fswincharset)
    print_subsection_header_fs_cfg('fswincharset');
    echo '　あなたの設定したWindowsのファイルシステム文字コードは';
    echo color_blue(!empty($fsCFG->fswincharset) ? $fsCFG->fswincharset : 'false').'です．';
    newline();
    echo '　この設定は現状ではほとんど使われることはありません．';
    echo color_blue('$fsCFG->fsCharset').'で'.color_blue('WINDOWS').'を選択した時にのみ意味を持ちます．';
    echo '日本語Windowsのファイルシステムは文字コードとしてシフトJIS（SJIS-WIN）を用いています．';
    echo 'もしfs_moodleの仕組みが他のマルチバイト文字圏のWindowsでも役に立つ場合，ここで指定した文字コードに変換します．';
    echo 'その場合は各言語のLanguage Packageを参考にして変更して下さい．';
    print_notice_message('コメント', 'この設定は文字列を入力します．プルダウンメニューではありません．');
    newline();
    echo '　とりあえずはOSの種類に関わらず，'.color_blue('SJIS-WIN').'を指定しておいて下さい．';
    print_fs_cfg_condition('fswincharset');
    print_subsection_footer();

    print_section_footer();
}

function fsconfig_other_filesystemproblem()
{
    global $fsCFG;

    print_section_header('ファイルシステムの制約に関わる別の設定');

    print_subsection_header('PHPの2GBの壁に関する設定', link2shirai(202));
    // (Shirai202): PHPでは取り扱えない2GBを越えるファイルを取り扱えるようにする改良 (2010/12/02) 
    print_subsubsection_header_fs_switch('FS_ENABLE_MANIPULATEOVER2GBFILE');
    echo '　標準のPHPは内部処理に整数値（32bit）を用いている制約により2GBを超えるファイルを正常に取り扱うことができません．';
    echo color_blue('filesize関数').'は戻り値が符号付整数値ですので2GBを超えると正しくない値（時によっては負の値）を返します．';
    echo color_blue('copy関数').'はファイルポインターを符号付整数値で管理しているため，ファイルのコピーに失敗します（関数自体は正常に終了するが，ファイルは破損している）．';
    newline();
    echo '　通常の使用においてPHPのサイト上で2GBを超えるファイルを扱うことは無い，という幸運なサイトであればこの問題は考慮しないで良いでしょう．';
    echo 'でも，たとえばDVDのISOイメージをコースファイルに置きたいと希望する先生や，コース上に膨大な数のmp3ファイルをアップロードする先生は居ないでしょうか．';
    echo 'そのコースのバックアップファイルは本当に2GBを超えていないですか？';
    echo 'Moodleのインタフェース上ではファイルのコピーという操作はありませんが，内部処理ではテンポラリー領域に作成したzipファイルをコースに書き戻すなど，ファイルの複写を行う処理は行われています．';
    newline();
    echo '　fs_moodleではこの問題に可能な限り対処します．';
    echo '具体的にはファイルサイズの取得に外部コマンド'.color_blue('stat(stat.exe)').'を用います．';
    echo 'これでファイルのサイズが負の値で表示されることはありません．';
    echo 'もしコピーしようとしているファイルのサイズが2GBを超えるようであれば，PHPのcopy()関数の代わりにシステムの標準コマンド'.color_blue('cp(copy.exe)').'を用います．';
    echo 'ファイルサイズが2GBを超える場合，PHPのfilesize関数は全く信用できない値を返しますので，そのファイルが2GBを超えているかどうか判別ができません（常に負の値を返すという保証は無い）．';
    echo 'このスイッチを有効にした場合，ファイルサイズを調べるときに必ず'.color_blue('stat(stat.exe)').'を呼び出します．';
    echo 'また，2GBを超えるファイルをコピーする場合はコピー前だけではなくコピー後にもファイルサイズを'.color_blue('stat(stat.exe)').'で調べて正常にコピーできたかどうか確認します．';
    echo 'つまりサイト全体のパフォーマンスが多少，低下します．';
    echo 'なお，現状では2GBを超えるファイルをWebブラウザ経由でアップロードすることはない，という前提でサーバ内部でのファイル処理のみに限定して対策を行っていますが，技術の進歩により必要性が生じた場合は対処します．';
    newline();
    echo '　本機能を有効にするには，あなたが管理しているサーバに'.color_blue('stat(stat.exe)').'が必要です．';
    echo color_blue('stat(stat.exe)').'は'.color_blue('-c').'オプションに対応している必要もあります．';
    echo 'OSがLinuxの場合は標準でインストールされていますが，Windows(Server含む)の場合は別途，'.color_blue('GnuWin32').'をインストールする必要があります．';
    newline(); newline();
    echo '　あなたのシステムに'.color_blue('stat').'コマンドがあるかどうか調べます．';
    echo '以下に，'.color_blue('stat').'コマンドの実行結果（'.color_blue('fsc_basicconfig.phpファイルのサイズ：'.filesize('fsc_basicconfig.php')).'）を示します．';
    echo '何も表示されない，あるいはエラーメッセージが表示される場合は'.color_blue('stat').'コマンドが使えない状態にあります．';
    $results = array();
    $size = exec('stat -c %s fsc_basicconfig.php', $results, $ret);
    newline(); newline();
    echo '------<ここから>------';
    foreach ($results as $result) {
        newline();
        echo $result;
    }
    newline();
    echo '------<ここまで>------';
    newline();
    if (!empty($size) and ($size == filesize('fsc_basicconfig.php'))) {
        echo color_blue('ファイルサイズの値が一致したので，多分，正常に動作しているでしょう．');
    } else {
        print_notice_message('警告', 'ファイルサイズの値が一致しません．この機能を有効にしてはいけません！');
    }
    print_fs_switch_condition('FS_ENABLE_MANIPULATEOVER2GBFILE');
    print_notice_message('補足', 'この改良はfs_moodleが独自で用意しているオーバーライド関数fs_filesize()とfs_copy()に対してのみ有効です．いわゆる”fs化”の行われていないファイル処理については未対応です．もし不具合を発見した場合はご連絡下さい．対処します．');
    print_subsubsection_footer();
    print_subsection_footer();

    // 【fs_moodle独自のpathinfo(), basename(), dirname()を使用するか？($fsCFG->USEfsPathinfo)】 (USEfsPathinfo)
    print_subsection_header_fs_cfg('USEfsPathinfo');
    echo '　PHPのpathinfo(), dirname(), basename()の挙動に不安があります．日本語文字の処理だけではなく，';
    echo '拡張子を含まないパスを分解した時の挙動がおかしい気がします．';
    echo 'Windows環境下ではドライブレターの処理にも不安があります．';
    echo '日本語Windows版以外のLinux版のPHPでもマルチバイトの処理に問題があるという報告もあります．';
    echo '特に問題がない限りはfs_moodleオリジナルのpathinfo系関数の使用を薦めます．';
    echo '詳しくは<a href = "http://moodle.org/mod/forum/discuss.php?d=73428">こちら</a>を参照して下さい．';
    newline();
    echo '　もし，以下の（pathinfo()の実行結果）で，';
    newline();
    $fullpath = 'C:/xampplite/moodledata/30/ＴＥＳＴ/１';
    echo '　　'.color_blue('"'.$fullpath).'"が正しく，';                newline();
    echo '　　　　dirname   = "C:/xampplite/moodledata/30/ＴＥＳＴ"';   newline();
    echo '　　　　basename  = "１"';                                    newline();
    echo '　　　　extension = ""';                                      newline();
    echo 'に分解できないならば'.color_blue('true').'に設定して下さい．';
    fs_box_start();
    echo '（pathinfo()の実行結果）';
    newline();
    $paths = pathinfo($fullpath);
    echo '　　　　dirname   = "'.$paths['dirname'].'"';     newline();
    echo '　　　　basename  = "'.$paths['basename'].'"';    newline();
    echo '　　　　extension = "'.(isset($paths['extension'])===true ? $paths['extension'] : 'Undefined index!').'"';
    fs_box_end();
    newline();
    echo '　現在，$fsCFG->USEfsPathinfo = ';
    echo color_blue(($fsCFG->USEfsPathinfo == true ? 'true' : 'false')).'が設定されています．';
    newline();
    if ($fsCFG->USEfsPathinfo) {
        fs_box_start();
        echo '（fs_pathinfo()の実行結果）';
        newline();
        $paths = fs_pathinfo($fullpath);
        echo '　　　　dirname   = "'.$paths['dirname'].'"';         newline();
        echo '　　　　basename  = "'.$paths['basename'].'"';        newline();
        echo '　　　　extension = "'.(isset($paths['extension'])===true ? $paths['extension'] : 'Undefined index!').'"';
        fs_box_end();
        echo '　正しく分解できているならばＯＫ．ダメならば御連絡下さい．';
        newline();
    } else {
        echo '　もし正しく分解できていなかったならば'.color_red('trueに設定することを勧めます').'．';
        newline();
        echo '　なお，もし正しく分解できていたとしてもtrueに設定することを勧めます．';
        echo 'Linux(CentOS5)環境下において，zip書庫作成時にzip書庫のファイル名に日本語文字を含むと';
        echo '指定したzip書庫名でzipファイルが作成できない現象が確認されているためです．';
    }
    print_fs_cfg_condition('USEfsPathinfo');
    print_subsection_footer();
    print_section_footer();
}

function fsconfig_check_ExtendChars()
{
    global $fsCFG;

    print_section_header('Moodleで使用を認めていない文字の使用に関する設定');

    // 【moodleで使用を認めていない記号もファイル名として使用可能とするか？ ($fsCFG->USEextChars)】 (USEextChars)
    print_subsection_header_fs_cfg('USEextChars');
    echo '　半角カッコなど，Moodleで使用を認めていない半角記号（a-zA-Z0-9,-,_以外の文字）も';
    echo 'ファイル名として使用可能とするかどうかを設定します．';
    newline();
    echo '　現在，'.color_blue(($fsCFG->USEextChars == true ? 'true' : 'false')).'が設定されています．';
    echo 'trueにすると便利になりますが安全である保障はありませんので，不安な方はfalseに設定して下さい';
    echo '（いままでのところ，特に問題は発生していません）．';
    print_fs_cfg_condition('USEextChars');
    print_subsection_footer();

    // 【全角空白文字をHTMLエディタ内で有効とするか(URL含む)($fsCFG->AllowZenkakuSPC)】 (AllowZenkakuSPC)
    print_subsection_header_fs_cfg('AllowZenkakuSPC');
    echo '　フォーラムやWikiなどだけではなく，URLのリンクアドレスに全角空白文字の使用を認めるかを設定します．';
    newline();
    echo '　現在，'.color_blue(($fsCFG->AllowZenkakuSPC == true ? 'true' : 'false')).'が設定されています．';
    print_fs_cfg_condition('AllowZenkakuSPC');
    newline();
    echo '　もし，falseを設定している時はオリジナルのMoodleと同じように，';
    echo '複数個の空白文字（半角だけでなく，全角も）は一つの半角空白文字に置換されます．';
    echo 'ここで言う空白文字はPHPに実装されている正規表現で空白文字(W)と認識される文字のことです．';
    echo 'いままでのところこの設定をtrueに変更しても大きな問題は発生していません．';
    echo 'ただし，'.color_red('一旦，有効にした後に無効に戻すのは止めた方が良いでしょう').'．';
    echo 'いままでに作成した複数の空白を含む文書';
    echo '（たとえばプログラムソースリストなど）を編集した際に体裁が一気に壊れてしまうためです．';
    print_subsection_footer();

    print_section_footer();
}

function fsconfig_check_others()
{
    global $fsCFG, $CFG;

    print_section_header('その他の設定');

    // 【URIにフォルダを指定されたときに呼び出すデフォルトファイル($fsCFG->defaultindex)】 (defaultindex)
    print_subsection_header_fs_cfg('defaultindex');
    echo '　多くのサイトにとって重要な機能ではありません．';
    newline();
    echo '　Moodleのコードの中にはトップページにジャンプする際に，index.phpを指定していない箇所が何箇所かあります．';
    echo 'Webサーバの設定で，HTMLファイル名が省略された時には自動的にindex.phpを呼び出すようにしてある場合はブランクで構いません．';
    newline();
    echo '　http://www.yourmoodle.com/moodleのようにインデックスページのアドレス抜きでダイレクトにURL指定された時に，';
    echo 'www.yourmoodle.com/moodle/index.htmlを呼び出すように意図的に設定したい場合もあります．';
    echo '例えば学内からのアクセスと学外からのアクセスとで呼び出すMoodleのインスタンスを使い分けたいとか，';
    echo '特別なページを介してからMoodleのトップページへジャンプするような設定を行いたい場合です．';
    echo '　fs_moodleでは，index.phpの指定なしでトップページへアクセスする箇所に修正を加え，';
    echo '$fsCFG->defaultindexに設定したファイルをアクセスするように設定できます．';
    newline();
    echo '　現在は，"';
    if (!empty($fsCFG->defaultindex)) echo color_blue($fsCFG->defaultindex);
      else                            echo color_blue('ブランク');
    echo '"が設定されています．';
    print_fs_cfg_condition('defaultindex');
    print_subsection_footer();

    // 【独自に追加したmimetypeに関する設定】 (Shirai068)
    print_subsection_header(str_readyMoodle2().':'.'独自に追加したmimetypeに関する設定', link2shirai(68));
    echo '　fs_moodleではMoodleで用意していないmimetypeを独自に追加あるいは上書き可能です．';
    newline(); newline();
    echo "　　例）fs_add_mimetype('bas', 'text/plain', 'text.gif');";
    newline(); newline();
    echo '　複数の設定を追加する場合は上記例のような設定を追加して下さい．';
    echo 'fs_add_mimetype()の引数は順番に，拡張子，mimetype，アイコンファイル名(moodle/pix/fフォルダ内）です．';
    echo '追加した拡張子と同じ拡張子のmimetype/iconの情報がMoodle標準の設定にも存在する場合，';
    echo '指定した値で上書きされます（できます）．';
    echo 'Moodle標準のmimetypeの情報はlib/filelib.phpのfunction get_mimetypes_array()をご覧下さい．';
    echo '現在設定されているmimetypeは'.fs_linktext('mimecheck.php', true, 'こちらのページ（ポップアップ）を参照').'して下さい．';
    newline();
    echo '　fs_moodleでは'.color_blue('一太郎').'に標準で対応するために拡張子'.color_blue('jtd').'を'.color_blue('application/x-js-taro').'に関連付けるための以下の設定を'.color_blue('lib/fs_moodle/index_later.php').'中で設定しています．他にも標準で対応して欲しいmime設定がある場合はご連絡下さい．';
    newline();
    fs_box_start();
    echo "fs_add_mimetype('jtd', 'application/x-js-taro', 'text');";
    fs_box_end();

    notice_fsconfig2fsconfig_option();
    print_notice_message('補足', 'Moodle2以降はアイコンファイル名（第３引数）に拡張子を付けない仕様に変わりました．16×16のGIF形式（例:avi.gif）に加えて32×32のPNGあるいはGIF（例：avi-32.png）が利用されます．fs_moodleでは設定ファイル（'.color_blue('fs_config_option.php').'）の共通化に対応しています．もしMoodle1系統ならば拡張子が無い場合は.gifを追加し，Moodle2系統ならば拡張子がある場合は取り除きます．今後の混乱を避けるために，拡張子を付けない形式を推奨します．拡張子を自由に指定可能と勘違いされるのを防ぐためです．');
    echo '　ファイル種別を表すアイコンファイルは'.color_blue($CFG->dirroot.'/pix/f').'フォルダにあります．もし指定されたアイコンファイルが存在しない場合は'.color_blue('unknown.gif').'が使用されます．なお，fs_moodleとしては相対パス指定に対応していますが，オリジナルのMoodleが対応し続ける保障はありません．';
    newline();
    fs_box_start();
    echo '　現在，';
    if (!isset($fsCFG->add_mimetypes)) {
        echo color_blue('追加のmimetypeは設定されていません．');
    } else {
        echo '以下のmimetypeが設定されています．';
        newline();
        $no = 1;
        foreach ($fsCFG->add_mimetypes as $key => $mime) {
            echo '　'.$no++.'．';
            echo color_blue('拡張子（'.$key.'）："'.$mime['type'].'"，アイコンファイル：'.$mime['icon']);
            newline();
        }
    }
    fs_box_end();
    print_subsection_footer();

    // (Shirai182): 二つのURLから一つのMoodleにアクセスしているシステムにおいて外部に供給するURLのベースアドレス（通常は$CFG->wwwroot）を統一できる改良 (2010/03/21)
    print_subsection_header('複数のURLから一つのMoodleにアクセスできるシステムで外部に供給するURLのベースアドレスを統一するための設定', link2shirai(182));
    echo '　ほとんどのサイトでは設定する必要の無い項目です．'.color_blue("define('FS_ENABLE_USEPUBLICWWWROOT', true);").'が有効な場合のみ意味を持ちます．';
    newline();
    echo '　一つのMoodleサイトに対して複数のURLを提供している場合を考えます．';
    echo 'たとえば学外専用のURLと学内専用のURL．学内からは学外専用URLでもアクセスできるが，学外からは学内専用URLではアクセスできない．';
    echo 'この場合に以下の機能において問題が生じます．以下の機能は$CFG->wwwrootのベースアドレスに基づいてユーザにURLを供給します．';
    echo '<ul>';
    echo '<li>'.link2shirai(157).': ”このコンテンツを電子メール送信するボタン”機能の追加 (2009/07/04)</li>';
    echo '<li>'.link2shirai(002).': フォーラムへの書き込みに一つずつ固有のナンバを表示する（吉田さん）</li>';
    echo '<li>'.link2shirai(160).': ブログにも投稿ごとに固有のIDを追加する改良 (2009/07/20)</li>';
    echo '<li>'.link2shirai(163).': ブログに返信機能を追加 (2009/08/26)</li>';
    echo '</ul>';

    print_subsubsection_header_fs_switch('FS_ENABLE_USEPUBLICWWWROOT');
    print_fs_switch_condition('FS_ENABLE_USEPUBLICWWWROOT');
    print_subsubsection_footer();
    print_subsubsection_header_fs_cfg('publicwwwroot');
    echo '　現在，'.color_blue('FS_ENABLE_USEPUBLICWWWROOT').'が';
    echo fs_function_enable('FS_ENABLE_USERPUBLICWWWROOT') ? color_blue('有効').'なので'.color_blue('$fsCFG->publicwwwroot').'の設定値が' : color_blue('無効').'なので'.color_blue('$CFG->wwwroot').'の設定値が';
    echo '外部へ供給されるURLのベースアドレスとして使用されます．';
    newline();
    echo '　現在は，$fsCFG->publiecwwwrootに"';
    if (!empty($fsCFG->publicwwwroot)) echo color_blue($fsCFG->publicwwwroot);
      else                             echo color_blue('ブランク');
    echo '"が設定されています．';
    print_fs_cfg_condition('publicwwwroot');
    print_subsubsection_footer();
    print_subsection_footer();

    print_section_footer();
}

// fsCFG変数のチェック
fsconfig_check_fsCharset();
fsconfig_other_filesystemproblem();
fsconfig_check_ExtendChars();
fsconfig_check_others();

?>