<?php

// Moodle2.0から変更になったデータベースへのアクセスに用いる関数
// lib/dmllib.php
// lib/dml/moodle_database.p

// function get_record($table, $field1, $value1, $field2='', $value2='', $field3='', $value3='', $fields='*')
// function get_record($table, array $conditions, $fields='*', $strictness=IGNORE_MISSING)
function fs_get_record($table, $field1, $value1, $field2='', $value2='', $field3='', $value3='', $fields='*')
{
    if (over_moodle20()) {
        global $DB;
        $conditions = array();

        $conditions[$field1] = $value1;
        if (!empty($field2)) $conditions[$field2] = $value2;
        if (!empty($field3)) $conditions[$filed3] = $value3;
        return $DB->get_record($table, $conditions, $fields);
    }
    return get_record($table, $field1, $value1, $field2, $value2, $field3, $value3, $fields);
}

// function get_records($table, $field='', $value='', $sort='', $fields='*', $limitfrom='', $limitnum='')
// function get_records($table, array $conditions=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0)
function fs_get_records($table, $field='', $value='', $sort='', $fields='*', $limitfrom='', $limitnum='')
{
    if (over_moodle20()) {
        global $DB;
        $conditions = null;

        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        if (!empty($field)) $conditions[$field] = $value;
        return $DB->get_records($table, $conditions, $sort, $fields, $limitfrom, $limitnum);
    }
    return get_records($table, $field, $value, $sort, $fields, $limitfrom, $limitnum);
}

// function get_records_select($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
// function get_records_select($table, $select, array $params=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0)
function fs_get_records_select($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
{
    if (over_moodle20()) {
        global $DB;
        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        return $DB->get_records_select($table, $select, null, $sort, $fields, $limitfrom, $limitnum);
    }
    return get_records_select($table, $select, $sort, $fields, $limitfrom, $limitnum);
}

// function get_records_select_menu($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
// function get_records_select_menu($table, $select, array $params=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0)
function fs_get_records_select_menu($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
{
    if (over_moodle20()) {
        global $DB;
        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        return $DB->get_records_select_menu($table, $select, null, $sort, $fields, $limitfrom, $limitnum);
    }
    return get_records_select_menu($table, $select, $sort, $fields, $limitfrom, $limitnum);
}

// function get_record_sql($sql, $expectmultiple=false, $nolimit=false)
// function get_record_sql($sql, array $params=null, $strictness=IGNORE_MISSING)
function fs_get_record_sql($sql, $expectmultiple=false, $nolimit=false)
{
    if (over_moodle20()) {
        global $DB;
        $strictness = IGNORE_MISSING;
        if ($exceptmultiple) $strictness = IGNORE_MULTIPLE;
        if ($nolimit)        $strictness = MUST_EXIST;

        return $DB->get_record_sql($sql, null, $strictness);
    }
    return get_record_sql($sql, $expectmultiple, $nolimit);
}

// function get_records_sql($sql, $limitfrom='', $limitnum='')
// function get_records_sql($sql, array $params=null, $limitfrom=0, $limitnum=0)
function fs_get_records_sql($sql, $limitfrom='', $limitnum='')
{
    if (over_moodle20()) {
        global $DB;
        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        return $DB->get_records_sql($sql, null, $limitfrom, $limitnum);
    }
    return get_records_sql($sql, $limitfrom, $limitnum);
}

// Moodle2からは無くなった
function fs_isadmin()
{
    global $USER, $CFG;
    if (function_exists('isadmin')) {
        return isadmin();
    }
    $admin = get_admin();
    return ($USER->id == $admin->id);
}

// (Shirai086): 言語パックのアップデート時にlocalフォルダ内のdefault.ttfをfontsフォルダにコピーする機能の追加 (2008/08/27)
// 言語パック：　default.ttfファイルをlocalからコピー
// この機能は理解不足で実装してしまったもの．実際には，
// (Moodle2.0以前): moodledata/lang/ja_utf8_local/fonts
// (Moodle2.0以降): moodledata/lang/ja_local/fonts
// に各言語用のdefault.ttfを置いておけば問題なし．
function restore_fontfile($pack)
{
    global $CFG;
    $fontfile = 'default.ttf';

    $src  = $CFG->dataroot.'/lang/'.$pack.'_local';
    $dest = $CFG->dataroot.'/lang/'.$pack.'/fonts';

    if (file_exists($src."/$fontfile") && file_exists($dest)) {
        if (!file_exists($dest."/$fontfile")) @copy($src."/$fontfile", $dest."/$fontfile");
    }
}

?>
