<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_community', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   block_community
 * @author     Jerome Mouneyrac <jerome@mouneyrac.com>
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['activities'] = 'Activities';
$string['add'] = 'Add';
$string['addedtoblock'] = 'A link to this course has been added in your community finder block';
$string['addtocommunityblock'] = 'Save a link to this course';
$string['addcommunitycourse'] = 'Add community course';
$string['additionalcoursedesc'] = '{$a->lang} Creator: {$a->creatorname} - Publisher: {$a->publishername} - Subject: {$a->subject}
    - Audience: {$a->audience} - Educational level: {$a->educationallevel} - License: {$a->license}';
$string['addcourse'] = 'Search';
$string['audience'] = 'Designed for';
$string['audience_help'] = 'What kind of course are you looking for?  As well as traditional courses intended for students, you might search for communities of Educators or Moodle Administrators';
$string['blocks'] = 'Blocks';
$string['cannotselecttopsubject'] = 'Cannot select a top subject level';
$string['comments'] = 'Comments ({$a})';
$string['contentinfo'] = 'Subject: {$a->subject} - Audience: {$a->audience} - Educational level: {$a->educationallevel}';
$string['continue'] = 'Continue';
$string['contributors'] = ' - Contributors: {$a}';
$string['coursedesc'] = 'Description';
$string['courselang'] = 'Language';
$string['coursename'] = 'Name';
$string['courses'] = 'Courses';
$string['coverage'] = 'Tags: {$a}';
$string['donotrestore'] = 'No';
$string['dorestore'] = 'Yes';
$string['download'] = 'Download';
$string['downloadable'] = 'courses I can download';
$string['downloadablecourses'] = 'Downloadable courses';
$string['downloadconfirmed'] = 'The backup has been saved in your private files {$a}';
$string['downloaded'] = '...finished.';
$string['downloadingcourse'] = 'Downloading course';
$string['downloadingsize'] = 'Please wait the course file is downloading ({$a->total}Mb)...';
$string['downloadtemplate'] = 'Create course from template';
$string['educationallevel'] = 'Educational level';
$string['educationallevel_help'] = 'What educational level are you searching for?  In the case of communities of educators, this level describes the level they are teaching.';
$string['enroldownload'] = 'Find';
$string['enroldownload_help'] = 'Some courses listed in the selected hub are being advertised so that people can come and participate in them on the original site.

Others are course templates provided for you to download and use on your own Moodle site.';
$string['enrollable'] = 'courses I can enrol in';
$string['enrollablecourses'] = 'Enrollable courses';
$string['errorcourselisting'] = 'An error occurred when retrieving the course listing from the selected hub, please try again later. ({$a})';
$string['errorhublisting'] = 'An error occurred when retrieving the hub listing from Moodle.org, please try again later. ({$a})';
$string['fileinfo'] = 'Language: {$a->lang} - License: {$a->license} -  Time updated: {$a->timeupdated}';
$string['hub'] = 'hub';
$string['hubnottrusted'] = 'Not trusted';
$string['hubtrusted'] = 'This hub is trusted by Moodle.org';
$string['keywords'] = 'Keywords';
$string['keywords_help'] = 'You can search for courses containing specific text in the name, description and other fields of the database.';
$string['langdesc'] = 'Language: {$a} - ';
$string['language'] = 'Language';
$string['language_help'] = 'You can search for courses written in a specific language.';
$string['licence'] = 'License';
$string['licence_help'] = 'You can search for courses that are licensed in a particular way.';
$string['moredetails'] = 'More details';
$string['mycommunities'] = 'My communities:';
$string['next'] = 'Next >>>';
$string['nocomments'] = 'No comments';
$string['nocourse'] = 'No courses found';
$string['noratings'] = 'No ratings';
$string['operation'] = 'Operation';
$string['orderby'] = 'Sort by';
$string['orderby_help'] = 'The order the search results are displayed.';
$string['orderbynewest'] = 'Newest';
$string['orderbyeldest'] = 'Oldest';
$string['orderbyname'] = 'Name';
$string['orderbypublisher'] = 'Publisher';
$string['orderbyratingaverage'] = 'Rating';
$string['outcomes'] = 'Outcomes: {$a}';
$string['pluginname'] = 'Community finder';
$string['rateandcomment'] = 'Rate and comment';
$string['rating'] = 'Rating';
$string['removecommunitycourse'] = 'Remove community course';
$string['restorecourse'] = 'Restore course';
$string['restorecourseinfo'] = 'Restore the course?';
$string['screenshots'] = 'Screenshots';
$string['search'] = 'Search';
$string['searchcommunitycourse'] = 'Search for community course';
$string['searchcourse'] = 'Search for community course';
$string['selecthub'] = 'Select hub';
$string['selecthub_help'] = 'Select hub where to search the courses.';
$string['sites'] = 'Sites';
$string['subject'] = 'Subject';
$string['subject_help'] = 'To narrow your search to courses about a particular subject, choose one from this list.';
$string['userinfo'] = 'Creator: {$a->creatorname} - Publisher: {$a->publishername}';
$string['visitdemo'] = 'Visit demo';
$string['visitsite'] = 'Visit site';
