<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains functions used by the admin pages
 *
 * @since 2.1
 * @package admin
 * @copyright 2011 Andrew Davis
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Return a list of page types
 * @param string $pagetype current page type
 * @param stdClass $parentcontext Block's parent context
 * @param stdClass $currentcontext Current context of block
 */
function admin_page_type_list($pagetype, $parentcontext, $currentcontext) {
    $array = array(
        'admin-*' => get_string('page-admin-x', 'pagetype'),
        $pagetype => get_string('page-admin-current', 'pagetype')
    );
    // Add the missing * (any page) option for them. MDL-30340
    // TODO: These pages are really 'pagetype-varying' - MDL-30564 -
    // and some day we should stop behaving that way, so proper pagetypes
    // can be specified for it (like course-category-* or so).
    // Luckly... the option we are introducing '*' is independent
    // of that varying behavior, so will work.
    if ($pagetype == 'admin-course-category') {
        $array += array(
            '*' => get_string('page-x', 'pagetype')
        );
    }
    return $array;
}
