<?php

// チャットの名前文字列を取得（設定に従って）
// (11) チャットでfirstnameの代わりに表示するのは？
//  $fsCFG->chatName = 1;       // firstname (名）
//  $fsCFG->chatName = 2;       // lastname （姓）
//  $fsCFG->chatName = 3;       // fullname （姓名）
//  $fsCFG->chatName = 4;       // ハンドルネームかfirstname
//  $fsCFG->chatName = 5;       // ハンドルネームかlastname
//  $fsCFG->chatName = 6;       // ハンドルネームかfullname
function get_chatNameString($sender)
{
    static  $users;
    global  $fsCFG;

    switch ($fsCFG->chatName) {
      case 2:   // lastname （姓）
        $nameString = $sender->lastname;
        break;
      case 3:   // fullname （姓名）
        $nameString = fullname($sender);
        break;
      case 4:   // ハンドルネームかfirstname
        if (empty($sender->handlename)) $nameString = $sender->firstname;
            else                        $nameString = '<a title="'.fullname($sender).'">'.$sender->handlename.'</a>';
        break;
      case 5:   // ハンドルネームかlastname
        if (empty($sender->handlename)) $nameString = $sender->lastname;
            else                        $nameString = '<a title="'.fullname($sender).'">'.$sender->handlename.'</a>';
        break;
      case 6:   // ハンドルネームかfullname
        if (empty($sender->handlename)) $nameString = fullname($sender);
            else                        $nameString = '<a title="'.fullname($sender).'">'.$sender->handlename.'</a>';
        break;
      case 1:   // firstname (名）
      default:
        $nameString = $sender->firstname;
        break;
    }
    return $nameString;
}

?>
