<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_calendarSettings()
{
    global $CFG, $fsCFG;

    print_section_header('カレンダーの日付に色を付ける機能', link2shirai(183));
    echo '　少なくともMoodle2.0よりも前のMoodleではカレンダーの日付に色を付ける機能はありません．';
    echo 'この機能は二種類の機能に分かれます．一つは土日の日付にそれぞれ青と赤の色を付ける機能，';
    echo 'もう一つは祝日やテスト週間などの特別なイベントに指定した色を付ける機能です．';
    echo 'どちらの機能もデフォルトで有効ですので，無効にするにはfsconfig.phpでスイッチを宣言する必要があります．';
    newline();
    print_subsection_header_fs_switch('FS_DISABLE_CALENDARCOLOREDWEEKEND');
    echo '　この機能を有効にするとカレンダーの土日の日付がそれぞれ青と赤に変わります．';
    newline();
    print_fs_switch_condition('FS_DISABLE_CALENDARCOLOREDWEEKEND');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_DISABLE_CALENDARCOLOREDSPECIAL');
    echo '　土日と異なり，祝日は年によって日付が異なります．';
    echo 'したがって一つ一つのイベントを手作業，あるいは一括でインポートするブロックなどを活用することになります．';
    echo 'でも，できれば祝日も日曜日のように赤い色で日付を表示したい，という要望に本機能は基づいて開発されました．';
    echo '単に休日にのみ対応するのではなく，他のイベントの日付にも色を付けたい．できれば望みの色を指定したい．';
    echo '標準のMoodleに極力，改良を加えずに実現するために，fs_moodleではイベントの名称に識別子を記入して貰うという手段を選択しました．';
    newline();
    echo '　まず本機能が有効な状態では，イベント名の頭に'.color_blue("'H:'").'（大文字/小文字を区別します）が付いているイベントの日付は赤色で表示するように設定されています．';
    echo 'たとえば，１月１日に'.color_blue("'H:元旦'").'というイベントを登録した場合，１月１日の日付が赤文字で表示されます．';
    echo '注意して頂きたいのは，'.color_blue('H:').'に祝日という意味がある訳ではない点です．';
    echo '単に赤い色で日付を表示するという以上の意味はありません．';
    newline();
    echo '　初期設定で用意した'.color_blue("'H:'").'以外の識別子を追加するには，';
    echo color_blue('fsconfig_option.php').'に関数'.color_blue('fs_add_eventcolor($prefix, [$color, [$description, [$weekend]]])').'を用いて宣言を追加します．';
    echo color_blue('$prefix').'は識別子である接頭辞です．正規表現に対応しませんし，'.color_blue('コロン（:）').'を最後に付けなくてはいけないというルールもありません．';
    echo color_blue('$color').'は日付の色を指定するカラーコードで，頭に'.color_blue('#').'を付けた３桁の１６進数です．';
    echo 'たとえば赤色ならば'.color_blue('#FF0000').'です．';
    echo color_blue('$description').'はその設定についての説明です．';
    echo '省略することも可能ですが，イベントを入力する際に混乱しないように表形式で全設定を表示しますので指定することを薦めます．';
    echo color_blue('$weekend').'はそのイベントが土日などの週末に設定された場合に，土日を表す青と赤を優先するかどうかを指定する真偽値のパラメータです．';
    echo color_blue('true（あるいは1）').'か'.color_blue('false（あるいは0）').'を指定して下さい．';
    echo color_blue('$weekend').'を'.color_blue('false').'とした場合は土日の色指定よりも識別子で判定したイベント色を優先します．';
    echo color_blue('fs_add_eventcolor()').'は先に宣言されたものも方が優先順位は上です．';
    echo '同一日に複数のイベントが設定された場合，日付の色は優先順位の高いもので着色されます．';
    echo 'もっとも優先順位が高いのは初期設定されている'.color_blue("'H:'").'です．';
    newline();
    echo '　'.color_blue('$color').'と'.color_blue('$weekend').'は省略可能です．';
    echo color_blue('$weekend').'が省略された場合は'.color_blue('$weekend == true').'と判断され，土日の青赤が優先されます．';
    echo 'これはたとえば週末を跨るようなイベントが指定された場合であっても土日は休みの学校／職場が多いという判断に基づいてます．';
    echo 'たとえばテスト期間といったイベントを想定しています．';
    newline();
    echo '　'.color_blue('$color').'が省略された場合は'.color_blue('$prefix').'で指定されたイベント色の設定を削除します．';
    echo '実用的には一つの意味しか無いでしょう．';
    echo '初期設定の'.color_blue("'H:'").'を削除するのに用います．';
    print_fs_switch_condition('FS_DISABLE_CALENDARCOLOREDSPECIAL');
    newline();
    echo '　いま現在，イベントの日付の色指定は';
    if (empty($fsCFG->eventcolor)) {
        echo color_red('一つも指定されていません（初期設定も含め）．');
    } else {
        echo '以下，'.color_blue(count($fsCFG->eventcolor)).'個の指定が有効です．';
    }
    newline();
    fs_display_declared_eventcolor(true);
    print_subsection_footer();

    print_section_footer();

    print_section_header_fs_switch('FS_DISABLE_CALENDARENDTIME2355');
    echo '　カレンダーのイベントを入力する際の終了日の日時は開始日の日時（時刻は００時００分）と同一である．';
    echo '１日限りのイベントであれば<b>期間</b>の設定は<b>期限なし</b>（=duration = 0, durationtime = 0）のままで良い．';
    echo 'それに対して，たとえば2010年4月7日から2010年4月8日の二日間に亘るイベントの場合，';
    echo '<b>期間</b>の<b>終了日</b>にチェックを付けて日付を2010年4月8日に設定しただけでは駄目である．';
    echo 'ならならば<b>開始日時</b>'.color_blue('2010年4月7日00:00').'から<b>終了日時</b>'.color_blue('2010年4月8日00:00').'のイベントは<b>2010年4月7日</b>の一日限りのイベントと認識されてしまうためである．';
    newline();
    echo '　この現象を回避するには<b>終了日</b>の時刻を'.color_blue('00:00').'以外に設定する必要がある．';
    echo 'この機能を有効にすると，新規にイベントを追加するとき，および入力済みのイベントの修正時かつ<b>期間</b>が<b>期間なし</b>の場合に限り，';
    echo '終了時刻の初期値を'.color_blue('23:55').'に変更してくれる．';
    echo '複数日に亘るイベントを入力する際に，日付だけでなく日時まで選択する手間を省くことが可能になる．';
    newline();
    print_fs_switch_condition('FS_DISABLE_CALENDARENDTIME2355');
    print_section_footer();

// (Shirai186): iCalendar出力を終日イベントに対応させる改良 (2010/04/09)
    print_section_header_fs_switch('FS_DISABLE_EXTENDEDICALEXPORT');
    echo '　標準のMoodleはカレンダーのイベント情報をiCalendar形式で出力する機能を持ちます．';
    echo 'ただ，この機能には不十分な点があります．';
    echo '”終日”のイベントが取り扱えない問題です．';
    newline();
    echo '　たとえば単一日の終日イベントがあったとします．';
    echo 'その場合，開始日の時刻を00:00，そして期間を”なし”に設定するでしょう．';
    echo 'これを例えばGoogleカレンダーにインポートした場合，このイベントは00:00から01:00の１時間のイベントと認識されてしまいます．';
    echo 'これは複数日に亘るイベントでも同様です．';
    newline();
    echo '　本機能を有効にした場合，単一日のイベントは開始日の時刻を00:00，期間を”なし”に設定します．';
    echo '複数日のイベントの場合は開始日の時刻を00:00，期間の終了日の時刻を23:55に設定して下さい．';
    newline();
    print_fs_switch_condition('FS_DISABLE_EXTENDEDICALEXPORT');
    print_section_footer();
}

fsconfig_check_calendarSettings();

?>