<?php // (Shirai017): コースバックアップファイルをダウンロードではなくmoodledata/temp/backupへ直接コピーする機能 (2013/10/15)

    require('../../../config.php');

    $userid     = required_param('userid', PARAM_INT);
    $courseid   = optional_param('courseid', 0, PARAM_INT); // needed for user tabs and c

    if (!fs_function_enable('FS_ENABLE_BLOGEXPORT')) {
        error('Blog Export function is not enabled!');
    }

    require_login();
    // 権限のチェック
    if (!can_export_blog($userid)) {
        print_error('youcannotexporttheseblogs', 'fs_moodle');
    }

    if (empty($courseid)) {
        $courseid = SITEID;
    }
    if (!$course = fs_get_record('course', 'id', $courseid)) {
        error('The course number was incorrect ('. $courseid .')');
    }
// $sitecontext = get_context_instance(CONTEXT_SYSTEM);
    $coursecontext   = get_context_instance(CONTEXT_COURSE, $course->id);

    course_setup($courseid);

    if (!$user = fs_get_record('user', 'id', $userid)) {
       error('Wrong user id');
    }
    $navlinks = array();
    $strblogexport = get_string('blogexport', 'fs_moodle');
    $strparticipants   = get_string("participants");

    if ($course->id != SITEID && has_capability('moodle/course:viewparticipants', $coursecontext)) {
        $navlinks[] = array('name' => $strparticipants, 'link' => "{$CFG->wwwroot}/user/index.php?id=$course->id", 'type' => 'misc');
    }

    $navlinks[] = array('name' => fullname($user), 'link' => "{$CFG->wwwroot}/user/view.php?id=$user->id&amp;course=$course->id", 'type' => 'misc');
    $navlinks[] = array('name' => $strblogexport, 'link' => null, 'type' => 'misc');
//  $navlinks[] = array('name' => $strmode, 'link' => null, 'type' => 'misc');
    $navigation = build_navigation($navlinks);

    print_header("$course->shortname: $strblogexport", $course->fullname, $navigation);

    require_capability('moodle/course:managefiles', get_context_instance(CONTEXT_COURSE, $course->id));

<?php

    output_CloseWindowButton();

    print_footer($course);

?>
