/*
YUI 3.7.3 (build 5687)
Copyright 2012 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/
if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/event-touch/event-touch.js']) {
   __coverage__['build/event-touch/event-touch.js'] = {"path":"build/event-touch/event-touch.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0,"35":0,"36":0,"37":0,"38":0,"39":0,"40":0,"41":0,"42":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0,0],"14":[0,0],"15":[0,0],"16":[0,0]},"f":{"1":0,"2":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":23},"end":{"line":1,"column":42}}},"2":{"name":"(anonymous_2)","line":32,"loc":{"start":{"line":32,"column":36},"end":{"line":32,"column":72}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":168,"column":41}},"2":{"start":{"line":16,"column":0},"end":{"line":20,"column":21}},"3":{"start":{"line":32,"column":0},"end":{"line":115,"column":2}},"4":{"start":{"line":34,"column":4},"end":{"line":34,"column":37}},"5":{"start":{"line":37,"column":4},"end":{"line":53,"column":5}},"6":{"start":{"line":46,"column":8},"end":{"line":46,"column":26}},"7":{"start":{"line":47,"column":8},"end":{"line":47,"column":24}},"8":{"start":{"line":49,"column":8},"end":{"line":52,"column":9}},"9":{"start":{"line":50,"column":12},"end":{"line":50,"column":30}},"10":{"start":{"line":51,"column":12},"end":{"line":51,"column":105}},"11":{"start":{"line":55,"column":4},"end":{"line":74,"column":5}},"12":{"start":{"line":65,"column":8},"end":{"line":65,"column":32}},"13":{"start":{"line":67,"column":8},"end":{"line":73,"column":9}},"14":{"start":{"line":68,"column":12},"end":{"line":68,"column":36}},"15":{"start":{"line":69,"column":12},"end":{"line":69,"column":67}},"16":{"start":{"line":71,"column":12},"end":{"line":71,"column":97}},"17":{"start":{"line":76,"column":4},"end":{"line":102,"column":5}},"18":{"start":{"line":93,"column":8},"end":{"line":93,"column":33}},"19":{"start":{"line":95,"column":8},"end":{"line":101,"column":9}},"20":{"start":{"line":96,"column":12},"end":{"line":96,"column":37}},"21":{"start":{"line":97,"column":12},"end":{"line":97,"column":67}},"22":{"start":{"line":99,"column":12},"end":{"line":99,"column":98}},"23":{"start":{"line":104,"column":4},"end":{"line":106,"column":5}},"24":{"start":{"line":105,"column":8},"end":{"line":105,"column":31}},"25":{"start":{"line":108,"column":4},"end":{"line":110,"column":5}},"26":{"start":{"line":109,"column":8},"end":{"line":109,"column":37}},"27":{"start":{"line":112,"column":4},"end":{"line":114,"column":5}},"28":{"start":{"line":113,"column":8},"end":{"line":113,"column":41}},"29":{"start":{"line":119,"column":0},"end":{"line":132,"column":1}},"30":{"start":{"line":120,"column":4},"end":{"line":131,"column":7}},"31":{"start":{"line":135,"column":0},"end":{"line":153,"column":1}},"32":{"start":{"line":136,"column":4},"end":{"line":136,"column":52}},"33":{"start":{"line":137,"column":4},"end":{"line":137,"column":46}},"34":{"start":{"line":138,"column":4},"end":{"line":138,"column":50}},"35":{"start":{"line":143,"column":5},"end":{"line":153,"column":1}},"36":{"start":{"line":144,"column":4},"end":{"line":144,"column":40}},"37":{"start":{"line":145,"column":4},"end":{"line":145,"column":36}},"38":{"start":{"line":146,"column":4},"end":{"line":146,"column":39}},"39":{"start":{"line":150,"column":4},"end":{"line":150,"column":36}},"40":{"start":{"line":151,"column":4},"end":{"line":151,"column":32}},"41":{"start":{"line":152,"column":4},"end":{"line":152,"column":35}},"42":{"start":{"line":165,"column":0},"end":{"line":165,"column":35}}},"branchMap":{"1":{"line":37,"type":"if","locations":[{"start":{"line":37,"column":4},"end":{"line":37,"column":4}},{"start":{"line":37,"column":4},"end":{"line":37,"column":4}}]},"2":{"line":55,"type":"if","locations":[{"start":{"line":55,"column":4},"end":{"line":55,"column":4}},{"start":{"line":55,"column":4},"end":{"line":55,"column":4}}]},"3":{"line":69,"type":"binary-expr","locations":[{"start":{"line":69,"column":23},"end":{"line":69,"column":33}},{"start":{"line":69,"column":37},"end":{"line":69,"column":66}}]},"4":{"line":71,"type":"binary-expr","locations":[{"start":{"line":71,"column":36},"end":{"line":71,"column":44}},{"start":{"line":71,"column":48},"end":{"line":71,"column":96}}]},"5":{"line":76,"type":"if","locations":[{"start":{"line":76,"column":4},"end":{"line":76,"column":4}},{"start":{"line":76,"column":4},"end":{"line":76,"column":4}}]},"6":{"line":97,"type":"binary-expr","locations":[{"start":{"line":97,"column":23},"end":{"line":97,"column":33}},{"start":{"line":97,"column":37},"end":{"line":97,"column":66}}]},"7":{"line":99,"type":"binary-expr","locations":[{"start":{"line":99,"column":37},"end":{"line":99,"column":45}},{"start":{"line":99,"column":49},"end":{"line":99,"column":97}}]},"8":{"line":104,"type":"if","locations":[{"start":{"line":104,"column":4},"end":{"line":104,"column":4}},{"start":{"line":104,"column":4},"end":{"line":104,"column":4}}]},"9":{"line":108,"type":"if","locations":[{"start":{"line":108,"column":4},"end":{"line":108,"column":4}},{"start":{"line":108,"column":4},"end":{"line":108,"column":4}}]},"10":{"line":112,"type":"if","locations":[{"start":{"line":112,"column":4},"end":{"line":112,"column":4}},{"start":{"line":112,"column":4},"end":{"line":112,"column":4}}]},"11":{"line":119,"type":"if","locations":[{"start":{"line":119,"column":0},"end":{"line":119,"column":0}},{"start":{"line":119,"column":0},"end":{"line":119,"column":0}}]},"12":{"line":135,"type":"if","locations":[{"start":{"line":135,"column":0},"end":{"line":135,"column":0}},{"start":{"line":135,"column":0},"end":{"line":135,"column":0}}]},"13":{"line":135,"type":"binary-expr","locations":[{"start":{"line":135,"column":5},"end":{"line":135,"column":8}},{"start":{"line":135,"column":13},"end":{"line":135,"column":34}},{"start":{"line":135,"column":40},"end":{"line":135,"column":73}}]},"14":{"line":135,"type":"binary-expr","locations":[{"start":{"line":135,"column":42},"end":{"line":135,"column":53}},{"start":{"line":135,"column":57},"end":{"line":135,"column":72}}]},"15":{"line":143,"type":"if","locations":[{"start":{"line":143,"column":5},"end":{"line":143,"column":5}},{"start":{"line":143,"column":5},"end":{"line":143,"column":5}}]},"16":{"line":143,"type":"binary-expr","locations":[{"start":{"line":143,"column":9},"end":{"line":143,"column":12}},{"start":{"line":143,"column":17},"end":{"line":143,"column":52}}]}},"code":["(function () { YUI.add('event-touch', function (Y, NAME) {","","/**","Adds touch event facade normalization properties (touches, changedTouches, targetTouches etc.) to the DOM event facade. Adds","touch events to the DOM events whitelist. ","","@example","    YUI().use('event-touch', function (Y) {","        Y.one('#myDiv').on('touchstart', function(e) {","            ...","        });","    });","@module event","@submodule event-touch"," */","var SCALE = \"scale\",","    ROTATION = \"rotation\",","    IDENTIFIER = \"identifier\",","    win = Y.config.win,","    GESTURE_MAP = {};","","/**"," * Adds touch event facade normalization properties to the DOM event facade"," *"," * @method _touch"," * @for DOMEventFacade"," * @private"," * @param ev {Event} the DOM event"," * @param currentTarget {HTMLElement} the element the listener was attached to"," * @param wrapper {Event.Custom} the custom event wrapper for this DOM event"," */","Y.DOMEventFacade.prototype._touch = function(e, currentTarget, wrapper) {","","    var i,l, etCached, et,touchCache;","","","    if (e.touches) {","","        /**","         * Array of individual touch events for touch points that are still in","         * contact with the touch surface.","         *","         * @property touches","         * @type {DOMEventFacade[]}","         */","        this.touches = [];","        touchCache = {};","","        for (i = 0, l = e.touches.length; i < l; ++i) {","            et = e.touches[i];","            touchCache[Y.stamp(et)] = this.touches[i] = new Y.DOMEventFacade(et, currentTarget, wrapper);","        }","    }","","    if (e.targetTouches) {","","        /**","         * Array of individual touch events still in contact with the touch","         * surface and whose `touchstart` event occurred inside the same taregt","         * element as the current target element.","         *","         * @property targetTouches","         * @type {DOMEventFacade[]}","         */","        this.targetTouches = [];","","        for (i = 0, l = e.targetTouches.length; i < l; ++i) {","            et = e.targetTouches[i];","            etCached = touchCache && touchCache[Y.stamp(et, true)];","","            this.targetTouches[i] = etCached || new Y.DOMEventFacade(et, currentTarget, wrapper);","            ","        }","    }","","    if (e.changedTouches) {","","        /**","        An array of event-specific touch events.","","        For `touchstart`, the touch points that became active with the current","        event.","","        For `touchmove`, the touch points that have changed since the last","        event.","        ","        For `touchend`, the touch points that have been removed from the touch","        surface.","","        @property changedTouches","        @type {DOMEventFacade[]}","        **/","        this.changedTouches = [];","","        for (i = 0, l = e.changedTouches.length; i < l; ++i) {","            et = e.changedTouches[i];","            etCached = touchCache && touchCache[Y.stamp(et, true)];","","            this.changedTouches[i] = etCached || new Y.DOMEventFacade(et, currentTarget, wrapper);","            ","        }","    }","","    if (SCALE in e) {","        this[SCALE] = e[SCALE];","    }","","    if (ROTATION in e) {","        this[ROTATION] = e[ROTATION];","    }","","    if (IDENTIFIER in e) {","        this[IDENTIFIER] = e[IDENTIFIER];","    }","};","","//Adding MSPointer events to whitelisted DOM Events. MSPointer event payloads","//have the same properties as mouse events.","if (Y.Node.DOM_EVENTS) {","    Y.mix(Y.Node.DOM_EVENTS, {","        touchstart:1,","        touchmove:1,","        touchend:1,","        touchcancel:1,","        gesturestart:1,","        gesturechange:1,","        gestureend:1,","        MSPointerDown:1, ","        MSPointerUp:1,","        MSPointerMove:1","    });","}","","//Add properties to Y.EVENT.GESTURE_MAP based on feature detection.","if ((win && (\"ontouchstart\" in win)) && !(Y.UA.chrome && Y.UA.chrome < 6)) {","    GESTURE_MAP.start = [\"touchstart\", \"mousedown\"];","    GESTURE_MAP.end = [\"touchend\", \"mouseup\"];","    GESTURE_MAP.move = [\"touchmove\", \"mousemove\"];","}","","","","else if (win && (\"msPointerEnabled\" in win.navigator)) {","    GESTURE_MAP.start = \"MSPointerDown\";","    GESTURE_MAP.end = \"MSPointerUp\";","    GESTURE_MAP.move = \"MSPointerMove\";","}","","else {","    GESTURE_MAP.start = \"mousedown\";","    GESTURE_MAP.end = \"mouseup\";","    GESTURE_MAP.move = \"mousemove\";","}","","/**"," * A object literal with keys \"start\", \"end\", and \"move\". The value for each key is a"," * string representing the event for that environment. For touch environments, the respective"," * values are \"touchstart\", \"touchend\" and \"touchmove\". Mouse and MSPointer environments are also"," * supported via feature detection."," *"," * @property _GESTURE_MAP"," * @type Object"," * @static"," */","Y.Event._GESTURE_MAP = GESTURE_MAP;","","","}, '3.7.3', {\"requires\": [\"node-base\"]});","","}());"]};
}
var __cov_Z8bDBh_pqbHA6UGgxTBUmA = __coverage__['build/event-touch/event-touch.js'];
__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['1']++;YUI.add('event-touch',function(Y,NAME){__cov_Z8bDBh_pqbHA6UGgxTBUmA.f['1']++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['2']++;var SCALE='scale',ROTATION='rotation',IDENTIFIER='identifier',win=Y.config.win,GESTURE_MAP={};__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['3']++;Y.DOMEventFacade.prototype._touch=function(e,currentTarget,wrapper){__cov_Z8bDBh_pqbHA6UGgxTBUmA.f['2']++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['4']++;var i,l,etCached,et,touchCache;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['5']++;if(e.touches){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['1'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['6']++;this.touches=[];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['7']++;touchCache={};__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['8']++;for(i=0,l=e.touches.length;i<l;++i){__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['9']++;et=e.touches[i];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['10']++;touchCache[Y.stamp(et)]=this.touches[i]=new Y.DOMEventFacade(et,currentTarget,wrapper);}}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['1'][1]++;}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['11']++;if(e.targetTouches){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['2'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['12']++;this.targetTouches=[];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['13']++;for(i=0,l=e.targetTouches.length;i<l;++i){__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['14']++;et=e.targetTouches[i];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['15']++;etCached=(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['3'][0]++,touchCache)&&(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['3'][1]++,touchCache[Y.stamp(et,true)]);__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['16']++;this.targetTouches[i]=(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['4'][0]++,etCached)||(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['4'][1]++,new Y.DOMEventFacade(et,currentTarget,wrapper));}}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['2'][1]++;}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['17']++;if(e.changedTouches){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['5'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['18']++;this.changedTouches=[];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['19']++;for(i=0,l=e.changedTouches.length;i<l;++i){__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['20']++;et=e.changedTouches[i];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['21']++;etCached=(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['6'][0]++,touchCache)&&(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['6'][1]++,touchCache[Y.stamp(et,true)]);__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['22']++;this.changedTouches[i]=(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['7'][0]++,etCached)||(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['7'][1]++,new Y.DOMEventFacade(et,currentTarget,wrapper));}}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['5'][1]++;}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['23']++;if(SCALE in e){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['8'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['24']++;this[SCALE]=e[SCALE];}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['8'][1]++;}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['25']++;if(ROTATION in e){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['9'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['26']++;this[ROTATION]=e[ROTATION];}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['9'][1]++;}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['27']++;if(IDENTIFIER in e){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['10'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['28']++;this[IDENTIFIER]=e[IDENTIFIER];}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['10'][1]++;}};__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['29']++;if(Y.Node.DOM_EVENTS){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['11'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['30']++;Y.mix(Y.Node.DOM_EVENTS,{touchstart:1,touchmove:1,touchend:1,touchcancel:1,gesturestart:1,gesturechange:1,gestureend:1,MSPointerDown:1,MSPointerUp:1,MSPointerMove:1});}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['11'][1]++;}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['31']++;if((__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['13'][0]++,win)&&(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['13'][1]++,'ontouchstart'in win)&&(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['13'][2]++,!((__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['14'][0]++,Y.UA.chrome)&&(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['14'][1]++,Y.UA.chrome<6)))){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['12'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['32']++;GESTURE_MAP.start=['touchstart','mousedown'];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['33']++;GESTURE_MAP.end=['touchend','mouseup'];__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['34']++;GESTURE_MAP.move=['touchmove','mousemove'];}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['12'][1]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['35']++;if((__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['16'][0]++,win)&&(__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['16'][1]++,'msPointerEnabled'in win.navigator)){__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['15'][0]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['36']++;GESTURE_MAP.start='MSPointerDown';__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['37']++;GESTURE_MAP.end='MSPointerUp';__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['38']++;GESTURE_MAP.move='MSPointerMove';}else{__cov_Z8bDBh_pqbHA6UGgxTBUmA.b['15'][1]++;__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['39']++;GESTURE_MAP.start='mousedown';__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['40']++;GESTURE_MAP.end='mouseup';__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['41']++;GESTURE_MAP.move='mousemove';}}__cov_Z8bDBh_pqbHA6UGgxTBUmA.s['42']++;Y.Event._GESTURE_MAP=GESTURE_MAP;},'3.7.3',{'requires':['node-base']});
