<?php

// Moodle2.0以降の場合はtrue, それ以前ならばfalseを返す
// fs_deprecatedlib.php中のMoodle2下位互換のためのデータベースアクセス用の関数でのみ使用
// もしかしたら$CFG->versionを閲覧できない時点で用いられているのかも知れないので，これはイジらない．
// というつもりだったが，JavaScript問題が発生したので構造を強化して用いる．
// だが，そもそも不要では？という気もする．以下，コードからは原則的に消えているはず．
function over_moodle20()
{
    global $CFG, $version, $release;
// Moodle2.5.2+(2013/10/18)あたりからJavaScriptが読み込まれない異常現象が発生し始めた原因はversion.phpをsetup.phpの段階で読み込んでしまうことによる
//  if ((empty($version) or empty($release)) and is_readable("$CFG->dirroot/version.php")) {
    if ((empty($CFG->version) or empty($CFG->release)) and is_readable("$CFG->dirroot/version.php")) {
        if (empty($version) or empty($release)) {
            include("$CFG->dirroot/version.php");              # defines $version
            if ($version >= 2007101600) return true;
            return false;
        }
    }
    if ($CFG->version >= 2007101600) return true;
    return false;
}

// Moodle2.0から変更になったデータベースへのアクセスに用いる関数
// lib/dmllib.php
// lib/dml/moodle_database.p
// over_moodle20() で$DBの使用の可否を調べていたが，この関数による副作用が発生してしまったので，
// 考え方を変えて，$DBがグローバル変数として定義されているかどうかで現状は判断する．
// 将来的に$DBにMoodle2と互換性のないバージョンが現れた場合に，その識別方法を考えなくてはいけない．


// function get_record($table, $field1, $value1, $field2='', $value2='', $field3='', $value3='', $fields='*')
// function get_record($table, array $conditions, $fields='*', $strictness=IGNORE_MISSING)
function fs_get_record($table, $field1, $value1, $field2='', $value2='', $field3='', $value3='', $fields='*')
{
    global $DB;
    if (!empty($DB)) {
        $conditions = array();

        $conditions[$field1] = $value1;
        if (!empty($field2)) $conditions[$field2] = $value2;
        if (!empty($field3)) $conditions[$filed3] = $value3;
        return $DB->get_record($table, $conditions, $fields);
    }
    return get_record($table, $field1, $value1, $field2, $value2, $field3, $value3, $fields);
}

// function get_records($table, $field='', $value='', $sort='', $fields='*', $limitfrom='', $limitnum='')
// function get_records($table, array $conditions=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0)
function fs_get_records($table, $field='', $value='', $sort='', $fields='*', $limitfrom='', $limitnum='')
{
    global $DB;
    if (!empty($DB)) {
        $conditions = null;

        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        if (!empty($field)) $conditions[$field] = $value;
        return $DB->get_records($table, $conditions, $sort, $fields, $limitfrom, $limitnum);
    }
    return get_records($table, $field, $value, $sort, $fields, $limitfrom, $limitnum);
}

// function get_records_select($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
// function get_records_select($table, $select, array $params=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0)
function fs_get_records_select($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
{
    global $DB;
    if (!empty($DB)) {
        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        return $DB->get_records_select($table, $select, null, $sort, $fields, $limitfrom, $limitnum);
    }
    return get_records_select($table, $select, $sort, $fields, $limitfrom, $limitnum);
}

// function get_records_select_menu($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
// function get_records_select_menu($table, $select, array $params=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0)
function fs_get_records_select_menu($table, $select='', $sort='', $fields='*', $limitfrom='', $limitnum='')
{
    global $DB;
    if (!empty($DB)) {
        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        return $DB->get_records_select_menu($table, $select, null, $sort, $fields, $limitfrom, $limitnum);
    }
    return get_records_select_menu($table, $select, $sort, $fields, $limitfrom, $limitnum);
}

// function get_record_sql($sql, $expectmultiple=false, $nolimit=false)
// function get_record_sql($sql, array $params=null, $strictness=IGNORE_MISSING)
function fs_get_record_sql($sql, $expectmultiple=false, $nolimit=false)
{
    global $DB;
    if (!empty($DB)) {
        $strictness = IGNORE_MISSING;
        if ($exceptmultiple) $strictness = IGNORE_MULTIPLE;
        if ($nolimit)        $strictness = MUST_EXIST;

        return $DB->get_record_sql($sql, null, $strictness);
    }
    return get_record_sql($sql, $expectmultiple, $nolimit);
}

// function get_records_sql($sql, $limitfrom='', $limitnum='')
// function get_records_sql($sql, array $params=null, $limitfrom=0, $limitnum=0)
function fs_get_records_sql($sql, $limitfrom='', $limitnum='')
{
    global $DB;
    if (!empty($DB)) {
        if (empty($limitfrom)) $limitfrom = 0;
        if (empty($limitnum))  $limitnum  = 0;
        return $DB->get_records_sql($sql, null, $limitfrom, $limitnum);
    }
    return get_records_sql($sql, $limitfrom, $limitnum);
}

// Moodle2からは無くなった
function fs_isadmin()
{
    global $USER, $CFG;
    if (function_exists('isadmin')) {
        return isadmin();
    }
    $admin = get_admin();
    return ($USER->id == $admin->id);
}

// (Shirai086): 言語パックのアップデート時にlocalフォルダ内のdefault.ttfをfontsフォルダにコピーする機能の追加 (2008/08/27)
// 言語パック：　default.ttfファイルをlocalからコピー
// この機能は理解不足で実装してしまったもの．実際には，
// (Moodle2.0以前): moodledata/lang/ja_utf8_local/fonts
// (Moodle2.0以降): moodledata/lang/ja_local/fonts
// に各言語用のdefault.ttfを置いておけば問題なし．
function restore_fontfile($pack)
{
    global $CFG;
    $fontfile = 'default.ttf';

    $src  = $CFG->dataroot.'/lang/'.$pack.'_local';
    $dest = $CFG->dataroot.'/lang/'.$pack.'/fonts';

    if (file_exists($src."/$fontfile") && file_exists($dest)) {
        if (!file_exists($dest."/$fontfile")) @copy($src."/$fontfile", $dest."/$fontfile");
    }
}

?>
