<?php
require_once 'Mail/mimeDecode.php';

class MailDecoder{
    
    // テキスト本文
    var $body_text;
    // HTML本文
    var $body_html;
    
    // 添付ファイル
    var $attachments = array();
    
    // Mail_mimeDecode オブジェクト
    var $_decoder;
    var $_structure;
    
    /**
     * コンストラクタ
     */
    function MailDecoder($source)
    {
        $params = array();
        $params['include_bodies'] = true; // ボディを解析する
        $params['decode_bodies']  = true; // ボディをコード変換する
        $params['decode_headers']  = true; // ヘッダをコード変換する
        
        $this->_decoder = new Mail_mimeDecode($source);
        $this->_structure = $this->_decoder->decode($params);
        
        $this->getMailData($this->_structure);
    }
    
    /**
     * ヘッダ取得
     */
    function getDecodedHeader($header_name){
        return mb_convert_encoding(mb_decode_mimeheader($this->_structure->headers[$header_name]), 'UTF-8', 'auto');
    }
    
    /**
     * ヘッダから送信元アドレスの取得
     */
    function getFromAddress(){
        $_from = $this->_structure->headers['from'];
        if (mb_eregi('^.*<([^>]+)>', $_from, $match)) {
            return trim($match[1]);
        }else{
            return trim($_from);
        }
    }
    
    /**
     * メール本文部分の処理
     */
    function getMailData($structure){
        static $i = 0;
        // マルチパートの場合
        if (strtolower($structure->ctype_primary) == "multipart") {
            // 各パートを解析する
            foreach ($structure->parts as $part) {
                // 添付ファイルの場合
                if (isset($part->disposition) && $part->disposition=="attachment") {
                    //添付ファイル
                    $this->attachments[$i]['type'] = strtolower($part->ctype_primary)."/".strtolower($part->ctype_secondary);
                    $this->attachments[$i]['name'] = $part->ctype_parameters['name'];
                    $this->attachments[$i]['binary'] = $part->body;
                    $i++;
                } else {
                    switch (strtolower($part->ctype_primary)) {
                        case "text": // テキスト本文
                            if ($part->ctype_secondary=="plain") {
                                $this->body_text = trim(mb_convert_encoding($part->body, 'UTF-8', 'auto'));
                            } else { // HTML本文
                                $this->body_html = trim(mb_convert_encoding($part->body, 'UTF-8', 'auto'));
                            }
                            break;
                        case "image": // マルチパート内に画像がある場合
                            $this->attachments[$i]['type'] = strtolower($part->ctype_primary)."/".strtolower($part->ctype_secondary);
                            $this->attachments[$i]['name'] = $part->ctype_parameters['name'];
                            $this->attachments[$i]['binary'] = $part->body;
                            $i++;
                            break;
                        case "multipart": //マルチパートの中にマルチパートがある場合は再帰的に自分自身を呼び出します
                            $this->getMailData($part);
                            break;
                    }
                }
            }
        //テキスト本文のみのメール
        } elseif (strtolower($structure->ctype_primary) == "text") {
            $this->body_text = trim(mb_convert_encoding($structure->body, 'UTF-8', 'auto'));
        }
    }
    
    /**
     * 添付ファイルを返却する
     */
    function getAttach(){
        return $this->attachments;
    }
    
    /**
     * メールテキスト本文を返却する
     */
    function getBodyText(){
        return $this->body_text;
    }
    
    /**
     * メールHTML本文を返却する
     */
    function getBodyHtml(){
        return $this->body_html;
    }
}
?>
