<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

require_once('../config.php');
require_once($CFG->dirroot . '/backup/util/includes/backup_includes.php');
require_once($CFG->dirroot . '/backup/moodle2/backup_plan_builder.class.php');


$courseid = required_param('id', PARAM_INT);
$sectionid = optional_param('section', null, PARAM_INT);
$cmid = optional_param('cm', null, PARAM_INT);
/**
 * Part of the forms in stages after initial, is POST never GET
 */
$backupid = optional_param('backup', false, PARAM_ALPHANUM);

$url = new moodle_url('/backup/backup.php', array('id'=>$courseid));
if ($sectionid !== null) {
    $url->param('section', $sectionid);
}
if ($cmid !== null) {
    $url->param('cm', $cmid);
}
$PAGE->set_url($url);
$PAGE->set_pagelayout('admin');

$id = $courseid;
$cm = null;
$course = $DB->get_record('course', array('id'=>$courseid), '*', MUST_EXIST);
$type = backup::TYPE_1COURSE;
if (!is_null($sectionid)) {
    $section = $DB->get_record('course_sections', array('course'=>$course->id, 'id'=>$sectionid), '*', MUST_EXIST);
    $type = backup::TYPE_1SECTION;
    $id = $sectionid;
}
if (!is_null($cmid)) {
    $cm = get_coursemodule_from_id(null, $cmid, $course->id, false, MUST_EXIST);
    $type = backup::TYPE_1ACTIVITY;
    $id = $cmid;
}
require_login($course, false, $cm);
// (Shirai003): Backup/Restoreの際のログを記録してデバッグを助ける機能の追加 (2013/10/12)
// (Shirai003): ここから追加
fs_log_backup(fs_class2str(__FILE__, __LINE__), "[TOP] courseid = $courseid, sectionid = $sectionid, cmid = $cmid, backupid = $backupid, Type = $type");
// (Shirai003): ここまで追加

switch ($type) {
    case backup::TYPE_1COURSE :
        require_capability('moodle/backup:backupcourse', context_course::instance($course->id));
        $heading = get_string('backupcourse', 'backup', $course->shortname);
        break;
    case backup::TYPE_1SECTION :
        $coursecontext = context_course::instance($course->id);
        require_capability('moodle/backup:backupsection', $coursecontext);
        if ((string)$section->name !== '') {
            $sectionname = format_string($section->name, true, array('context' => $coursecontext));
            $heading = get_string('backupsection', 'backup', $sectionname);
            $PAGE->navbar->add($sectionname);
        } else {
            $heading = get_string('backupsection', 'backup', $section->section);
            $PAGE->navbar->add(get_string('section').' '.$section->section);
        }
        break;
    case backup::TYPE_1ACTIVITY :
        require_capability('moodle/backup:backupactivity', context_module::instance($cm->id));
        $heading = get_string('backupactivity', 'backup', $cm->name);
        break;
    default :
        print_error('unknownbackuptype');
}

if (!($bc = backup_ui::load_controller($backupid))) {
    $bc = new backup_controller($type, $id, backup::FORMAT_MOODLE,
                            backup::INTERACTIVE_YES, backup::MODE_GENERAL, $USER->id);
}
$backup = new backup_ui($bc);
$backup->process();
if ($backup->get_stage() == backup_ui::STAGE_FINAL) {
// (Shirai003): ここから追加
    fs_log_backup(fs_class2str(__FILE__, __LINE__), "\$backup->execute() : Start");
// (Shirai003): ここまで追加
    $backup->execute();
// (Shirai003): ここから追加
    fs_log_backup(fs_class2str(__FILE__, __LINE__), "\$backup->execute() : End");
// (Shirai003): ここまで追加
} else {
// (Shirai003): ここから追加
    fs_log_backup(fs_class2str(__FILE__, __LINE__), "\$backup->save_controller() : Start");
// (Shirai003): ここまで追加
    $backup->save_controller();
// (Shirai003): ここから追加
    fs_log_backup(fs_class2str(__FILE__, __LINE__), "\$backup->save_controller() : End");
// (Shirai003): ここまで追加
}

$PAGE->set_title($heading.': '.$backup->get_stage_name());
$PAGE->set_heading($heading);
$PAGE->navbar->add($backup->get_stage_name());

$renderer = $PAGE->get_renderer('core','backup');
echo $OUTPUT->header();
if ($backup->enforce_changed_dependencies()) {
    debugging('Your settings have been altered due to unmet dependencies', DEBUG_DEVELOPER);
}
echo $renderer->progress_bar($backup->get_progress_bar());
echo $backup->display($renderer);
$backup->destroy();
unset($backup);
echo $OUTPUT->footer();