<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Gradereport user plugin upgrade code
 *
 * @package    gradereport_user
 * @copyright  2014 Zachary Durber
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * @param int $oldversion the version we are upgrading from
 * @return bool result
 */
function xmldb_gradereport_user_upgrade($oldversion) {

    if ($oldversion < 2014101500) {
        // Need to always show weight and contribution to course total.
        set_config('grade_report_user_showweight', 1);

        // User savepoint reached.
        upgrade_plugin_savepoint(true, 2014101500, 'gradereport', 'user');
    }

    // Moodle v2.8.0 release upgrade line.
    // Put any upgrade step following this.

    return true;
}
