<?php

// (Shirai075): fs_moodleの設定を表示するメニューをサイト管理に追加 (2008/07/21)

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_fs_originalfunctions()
{
    global $CFG, $fsCFG;

    print_notice_message('案内', 'ここではfs_moodle独自の代表的な機能に関する設定を表示します．他の設定も全てfs_moodle独自の設定ですが，ここで表示するのは特に大掛かりな拡張や機能追加を行った機能です．');

    print_section_header('小型の端末を便利に使うための設定');
    print_subsection_header_fs_switch('FS_DISABLE_MOBILEMODE');
    echo '　モバイルモードはfs_moodleの最もユニークな機能です．';
    echo '画面サイズが小さな携帯端末機器（フルブラウザ搭載機種のみ）でMoodleの全機能を実用的に利用可能とするための機能拡張です．';
    newline();
    print_fs_switch_condition('FS_DISABLE_MOBILEMODE');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_DISABLE_FSADVMENUDISPLAY');
    echo '　fs_moodle独自の機能，たとえばモバイルモード，チョイ読み機能，PDF2JPEG機能，私に送信機能，のOn/Offを制御するためのボタンをフッターに表示しますが，';
    echo 'これらの機能を使うつもりが無い，あるいは一時的に使用を禁止したい場合にまとめてすべて表示を消すことができます．';
    echo 'デフォルトではこれらのボタンはすべて表示されます．';
    echo 'なるべく目障りにならないように，JavaScriptで表示をOn/Offするチェックボックスを追加しましたが，';
    echo 'それでも気になる場合はいっそのこと表示を消してしまいましょう．';
    echo '当然ですが，表示されないということは，これらの拡張機能は使用できなくなります．';
    print_fs_switch_condition('FS_DISABLE_FSADVMENUDISPLAY');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_MOBILE_DISPLAY');
    echo '　小型携帯端末（ゲーム機，携帯電話，PDAなど）に搭載されているWebブラウザの多くは，';
    echo '搭載さいされているフォントやCSSの機能などがデスクトップＰＣのブラウザに比べて不足しています．';
    echo '本機能を有効にすると，可能な限り画面表示が正しくなるように出力するHTMLを調整します．';
    newline();
    echo '　クライアント端末が小型携帯端末かそれ以外かを自動的に判別しています．';
    echo 'したがって本機能を有効にしても，クライアント端末が一般的なＰＣであれば特に悪影響はありません．';
    echo 'ただし当方で把握している小型携帯端末以外は認識できませんので，';
    echo '新たに対応して貰いたい小型携帯端末が登場した場合はご連絡下さい．';
    newline();
    newline();
    echo '　現時点で対応している機能はナビゲーション等で表示される矢印記号（►）を>に変換する機能のみです．';
    newline();
    print_fs_switch_condition('FS_ENABLE_MOBILE_DISPLAY');
    print_subsection_footer();

    print_subsection_header('PDFファイルを表示できないクライアントでPDFファイルを表示する機能', link2shirai(76));
    echo '　PDFファイルを閲覧できない端末（PSP, Nintendo DS, PS3, Wii，一部の携帯電話など）で，';
    echo 'Moodleサーバ上のPDFファイルを画面表示可能とする機能に関する設定です．';
    newline();
    echo '　PDF2JPEG変換出力機能は，サーバ上にインストールされたGhostscriptを利用して';
    echo 'PDFファイルをJPEGファイルに変換してクライアントへ送出する仕組みです．';
    newline();
    newline();
    print_subsubsection_header_fs_switch('FS_ENABLE_PDF2JPEG');
    echo '　この機能を利用するには，スイッチ'.color_blue('FS_ENABLE_PDF2JPEG').'を有効にするのと同時に，パラメータ'.color_blue('$fsCFG->gsexec').'にGhostscriptの実行ファイル名を設定する必要があります．';
    $enable = print_fs_switch_condition('FS_ENABLE_PDF2JPEG');
    newline();
    print_subsubsection_footer();
    print_subsubsection_header_fs_cfg('gsexec');
    if (empty($fsCFG->gsexec)) {
        echo  ($enable ? '　しかし' : '　');
        echo color_red('$fsCFG->gsexec（Ghostscriptの実行コマンド名）が設定されていません').'．';
        echo 'PDF2JPEG機能を利用するにはGhostscriptのインストールと$fsCFG->gsexecの設定が必要です．';
        newline();
    } else {
        global $titleonly;
        if (empty($titleonly)) {
            echo '　Ghostscriptの実行コマンド名は"'.color_blue($fsCFG->gsexec).'"が設定されています．';
            newline();
            fs_box_start();
            echo '  --- 実行結果 ---';
            newline();
            exec($fsCFG->gsexec.' -h', $ret);
            if (!count($ret)){
                echo color_red('  実行できませんでした').'．';
                newline();
                echo '  Ghostscriptは正しくインストールされているでしょうか？';
                newline();
                echo '  コマンド名をもう一度，よく確認して下さい．';
                newline();
            } else {
                if (isset($ret[0])) echo '　　'.$ret[0].newline(false);
                if (isset($ret[1])) echo '　　'.$ret[1].newline(false);
            }
            echo '  --- ここまで ---';
            newline();
            fs_box_end();
        }
    }
    print_fs_cfg_condition('gsexec');
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_DISABLE_DISPLAYATTACHEDFILEiPods');
    echo '　iPod touch/iPhone上に搭載されているブラウザSafariはファイルのダウンロード保存に非対応です．';
    echo 'その結果，Moodleから添付ファイル属性（Attachment）で送信されたファイルはブロックされてしまいます．';
    echo '添付ファイルをブラウザ上に直接表示する属性（Inline）でMoodleが送信しないのは，XSS攻撃に対するセキュリティです．';
    echo 'もし害のあるJavascriptを含むファイルをユーザが（意図して／無知で）添付してしまった場合，';
    echo 'それをダウンロードしたユーザに被害が生じる恐れがあるためです．';
    newline();
    echo '　この機能を有効にすると，Excel(xls)，Word(doc), PDF(pdf)に加えて，';
    echo 'テキストファイル（mimetype=text/plain)が閲覧可能になります．';
    echo 'ただしセキュリティ上の問題から，';
    echo color_red('HTML(html, htm)ファイルは閲覧できません').'．';
    newline();
    echo '　当方でXSSコード（Javascript）を含む様々なファイルを用いて実験を行っていますが，';
    echo '不安を感じる方はこの機能を無効にできます．';
    echo '本家でも対応の検討が始まっています．';
    echo 'もし本採用になった場合でも機能のOn/Offが可能なこの設定は残しておく予定です．';
    newline();
    print_fs_switch_condition('FS_DISABLE_DISPLAYATTACHEDFILEiPods');
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_DISABLE_SENDTHISCONTENTS2ME');
    echo '　モバイル機器はMoodle上のデータ（フォーラム投稿やWikiなど）をコピー＆ペーストして参照するのが苦手です．';
    echo 'モバイル機器でMoodleを閲覧していて「あ，この情報良いな」と思っても忘れてしまいます．';
    echo '返信する必要のある投稿があった場合，現在は「チョイ読み」機能を使えば，既読を未読に戻すことはできますが，';
    echo 'ハイライトさせる訳ではありません．';
    newline();
    echo '　そこでフォーラム投稿やWikiページに「送信」ボタンを設置し，';
    echo 'このボタンを押せばそのコンテンツをテキスト形式（要約メール同様のイメージ）で自分自身のメールアドレスへ送信します．';
    echo 'その際にそのコンテンツへのリンクも付けて送れば（現在の要約メールもURLは付いていたと思います），';
    echo 'あとでメールを見れば「ああ，これに対して返信するんだった」と忘れずに対応することができます．';
    print_fs_switch_condition('FS_DISABLE_SENDTHISCONTENTS2ME');
    print_subsection_footer();
    print_section_footer();

    print_section_header('セキュアなRSSに関する設定');
    echo '　オリジナルのMoodleはフォーラム投稿（学生が利用可能なコースのみ）とブログ（全世界に公開されているもののみ）の更新情報を取得可能なRSS機能が装備されています．';
    echo 'しかしセキュリティは皆無であり，多少の知識があるならばサイトにアカウントを持たない者でも，比較的簡単にフォーラムの投稿を盗み読み可能です．';
    echo 'Moodle2.0では安全性を高めたセキュアなRSS機能が搭載されるとアナウンスされています．';
    echo '本機能はセキュアなRSS機能が標準装備されるまでの”つなぎ”です．';
    newline();
    newline();

    print_subsection_header_fs_cfg('rss_secure_level');
//  echo '　RSSの安全レベル（$fsCFG->rss_secure_level）は0から5の値を指定可能です．それぞれの値には以下の意味があります．';
    echo '　この変数には以下の選択肢があります．';
    table_of_select_data('rss_secure_level');
/*
    echo '<ul>';
    echo '<li>0: 旧アドレス形式を出力．全アドレス形式を受け入れる（オリジナルに近い，安全性最低）</li>';
    echo '<li>1: 共通鍵アドレス形式を出力．全アドレス形式を受け入れる（過渡期向け，安全性低い）</li>';
    echo '<li>2: コース別暗号化形式を出力．全アドレス形式を受け入れる（過渡期向け，安全性低い）</li>';
    echo '<li>3: 共通鍵アドレス形式を出力．暗号化アドレス形式（共通鍵／コース別）のみ受け入れる（過渡期向け，安全性中）</li>';
    echo '<li>4: コース別アドレス形式を出力．暗号化アドレス形式（共通鍵／コース別）のみ受け入れる（安全性高い）</li>';
    echo '<li>5: コース別アドレス形式を出力．コース別アドレス形式のみ受け入れる（安全性最高）</li>';
    echo '</ul>';
*/
    echo 'これからRSSを有効にしようと考えている方は最も安全性の高い"5"の設定を薦めます．';
    echo '既にRSSを利用しているサイトの場合は"2"の設定を薦めます．年度の切り替わり時に"5"に変更すれば良いでしょう．';
    echo 'Moodle2.0からは本家でもSecureなRSSを導入する予定のようです．それまではこのfs_moodleの安全なRSSの使用を薦めます．';
    echo '現状のRSSには致命的な脆弱性があります．コースどころかサイトのアカウントを持たないユーザでも，';
    echo 'RSSフィードを受信できてしまいます．';
    echo '詳しくは，<a href="http://moodle.org/mod/forum/discuss.php?d=93299">こちら</a>のディスカッションをご一読下さい．';
    newline();
    newline();
    echo '　現在，'.color_blue('$fsCFG->rss_secure_level').'には'.color_blue($fsCFG->rss_secure_level).'が設定されています．';
    print_fs_cfg_condition('rss_secure_level');
    print_subsection_footer();

    print_subsection_header('セキュアなRSS秘密鍵A/Bの設定');
    echo '　セキュアなRSSは管理者が設定した二つの秘密鍵を元にしてURLを暗号化することで第三者による盗み読みを防いでいます．';
    echo color_blue('$fsCFG->rssCryptKeyA').'と'.color_blue('$fsCFG->rssCryptKeyB').'には特に優先順位等はないので自由な半角英数文字列を指定して下さい．';
    print_notice_message('警告', 'したがってここで設定する二つの秘密鍵は絶対に第三者に知られてはいけません．また，この秘密鍵を変更してしまうと，変更前にユーザが取得したRSSのリンクアドレスは全て無効になってしまうので安易に変更してはいけません．');

    print_subsubsection_header_fs_cfg('rssCryptKeyA');
    echo '　RSS共通秘密鍵Aには，"'.color_blue($fsCFG->rssCryptKeyA).'"が設定されています．';
    newline();
    if ($fsCFG->rssCryptKeyA === get_fs_cfg_default('rssCryptKeyA'))  print_notice_message('注意', '$fsCFG->rssCryptKeyAがデフォルトの値のままです．危険ですので変更して下さい．');
    print_fs_cfg_condition('rssCryptKeyA');
    print_subsubsection_footer();

    print_subsubsection_header_fs_cfg('rssCryptKeyB');
    echo '　RSS共通秘密鍵Bには，"'.color_blue($fsCFG->rssCryptKeyB).'"が設定されています．';
    newline();
    if ($fsCFG->rssCryptKeyB === get_fs_cfg_default('rssCryptKeyB')) print_notice_message('注意', '$fsCFG->rssCryptKeyBがデフォルトの値のままです．危険ですので変更して下さい．');
    print_fs_cfg_condition('rssCryptKeyB');
    print_subsubsection_footer();

    echo 'インストール後にユニークな文字列に設定した後はRSS共通秘密鍵が漏洩したと疑われる場合以外は変更しない方が良いでしょう．コース単位で安全なRSSリンクアドレスを変更したい場合は，各コースの登録キーを変更して下さい．';
    print_subsection_footer();
    print_section_footer();

    print_section_header('その他の設定');
    print_subsection_header_fs_switch('FS_ENABLE_FOOTER_BANNER');
    echo '　画面下のフッター部にバナーなどの表示を可能とします．';
    echo '単にHTMLを流し込むだけの機能に加えて，';
    echo '指定した関数（単一の関数．マルチステートメント不可）や指定したPHPファイルを実行する機能もあります．';
    echo '単にバナーを追加するだけではなく，カウンターを仕込むなど管理者の好みにより様々な応用が可能でしょう．';
    print_fs_switch_condition('FS_ENABLE_FOOTER_BANNER');
    echo '　表示するバナーの追加はfsconfig_option.phpに指定された書式で関数を記述することで行います．';
    newline();
    if (!empty($fsCFG->footer_banner)) {
        echo '　'.color_blue(count($fsCFG->footer_banner).'件').'のデータが追加されています．';
        newline();
        printout_banner_settings();
    }
    notice_fsconfig2fsconfig_option();

    print_subsection_footer();
    print_section_footer();
}

function printout_banner_settings()
{
    global $fsCFG, $CFG;
    echo '<table border="1" width="95%" align="center" cellpadding="5" cellspacing="0" style="bordercolor:#333333">';
    echo '<caption align="top">フッターに表示されるバナー設定の一覧表</caption>';
    echo '<tr bgcolor="#cccccc">';
    echo '<th>コースID</th><th>コース名</th><th>Type</th><th>パラメータ</th></tr>';
    foreach ($fsCFG->footer_banner as $footer_banner) {
        echo '<tr>';
        echo '<td align="center">';
        echo $footer_banner->courseid;
        echo '</td><td>';
        if ($footer_banner->courseid == -1) {
            echo '全コース';
            if ($footer_banner->courseonly) echo '<br />（コースページのみ）';
        } else {
            if (! ($course = fs_get_record("course", "id", $footer_banner->courseid))) {
                echo '（存在しないコース）&nbsp;('.$footer_banner->courseid.')';
            } else {
                echo '<a href="'.$CFG->wwwroot.'/course/view.php?id='.$footer_banner->courseid.'" target="_blank">';
                echo $course->fullname;
                echo '</a>';
                echo 'のみ';
            }
        }
        echo '</td><td align="center">';
        if (!empty($footer_banner->html)) {
            echo 'html';
        } else if (!empty($footer_banner->func)) {
            echo 'func';
        } else if (!empty($footer_banner->php)) {
            echo 'php';
        } else {
            echo '(Error!!!)';
        }
        echo '</td><td>';
        if (!empty($footer_banner->html)) {
            echo '（省略）';
        } else if (!empty($footer_banner->func)) {
            echo "{$footer_banner->func}(";
            if (!empty($footer_banner->option)) {
                echo "{$footer_banner->option}";
            }
            echo ')';
        } else if (!empty($footer_banner->php)) {
            echo $footer_banner->php;
        } else {
            echo '(Error!!!)';
        }
    }
    echo '</table>';
}

fsconfig_check_fs_originalfunctions();

?>