<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Code to search for users in response to an ajax call from a user selector.
 *
 * @package core_user
 * @copyright 1999 Martin Dougiamas  http://dougiamas.com
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define('AJAX_SCRIPT', true);

require_once(__DIR__ . '/../../config.php');
require_once($CFG->dirroot . '/user/selector/lib.php');

$PAGE->set_context(context_system::instance());
$PAGE->set_url('/user/selector/search.php');

echo $OUTPUT->header();

// Check access.
require_login();
require_sesskey();

// Get the search parameter.
$search = required_param('search', PARAM_RAW);

// Get and validate the selectorid parameter.
$selectorhash = required_param('selectorid', PARAM_ALPHANUM);
if (!isset($USER->userselectors[$selectorhash])) {
    print_error('unknownuserselector');
}

// Get the options.
$options = $USER->userselectors[$selectorhash];

// Create the appropriate userselector.
$classname = $options['class'];
unset($options['class']);
$name = $options['name'];
unset($options['name']);
if (isset($options['file'])) {
    require_once($CFG->dirroot . '/' . $options['file']);
    unset($options['file']);
}
// (Shirai005): サイトの”ユーザ一覧を表示する”とコースの"登録ユーザ"の一覧においてユーザ名の表示とソーティングを可能とする改良(2013/10/14)
// (Shirai005): ここから追加
if (fs_function_enable('FS_DISABLE_DISPLAYandSORT_BY_USERNAME')) {
    for ($i = 0; $i < sizeof($options['extrafields']); $i++) {
        if (($options['extrafields'][$i] === 'username') ||
            ($options['extrafields'][$i] === 'email')) unset($options['extrafields'][$i]);
    }
    if (optional_param('userselector_searchusername', true, PARAM_BOOL)) $options['extrafields'][] = 'username';
    if (optional_param('userselector_searchemail', true, PARAM_BOOL))    $options['extrafields'][] = 'email';
}
// (Shirai005): ここまで追加
$userselector = new $classname($name, $options);

// Do the search and output the results.
$results = $userselector->find_users($search);
$jsonresults = array();
foreach ($results as $groupname => $users) {
    $groupdata = array('name' => $groupname, 'users' => array());
    foreach ($users as $user) {
        $output = new stdClass;
        $output->id = $user->id;
        $output->name = $userselector->output_user($user);
        if (!empty($user->disabled)) {
            $output->disabled = true;
        }
        if (!empty($user->infobelow)) {
            $output->infobelow = $user->infobelow;
        }
        $groupdata['users'][] = $output;
    }
    $jsonresults[] = $groupdata;
}

$json = array('results' => $jsonresults);

// Also add users' group membership summaries, if possible.
if (is_callable(array($userselector, 'get_user_summaries')) && isset($options['courseid'])) {
    $json['userSummaries'] = $userselector->get_user_summaries($options['courseid']);
}

echo json_encode($json);
