<?php
require_once 'Mail.php';

class MailSender
{
    /**
     * コンストラクタ
     */
    public function MailSender()
    {
    }
    
    /**
     * メール送信
     */
    function send($from_name, $from_mail, $subject, $body, $to)
    {
        //sendmailのパス
        $params['sendmail_path'] = '/usr/sbin/sendmail';
        
        //fromの名前をエンコード
        $from_name = mb_convert_encoding($from_name, "JIS", "auto");
        $from_name = "=?iso-2022-jp?B?" . base64_encode($from_name) . "?=";
        $from = ($from_mail) ? "$from_name<$from_mail>" : "$from_name<root@$HTTP_POST>";
        
        //タイトルをエンコード
        $subject = mb_convert_encoding($subject, "JIS", "auto");
        $subject = "=?iso-2022-jp?B?" . base64_encode($subject) . "?=";
        
        //bodyをエンコード
        $body = str_replace("\r\n", "\n", $body);
        $body = str_replace("\r", "\n", $body);
        $body = mb_convert_encoding($body, "JIS", "auto");
        
        //ヘッダを整理
        $recipients = $to;
        $headers['From']    = $from;
        $headers['To']      = $to;
        $headers['Subject'] = $subject;
        $headers['MIME-version'] = '1.0';
        $headers['Content-Type'] = 'text/plain; charset="iso-2022-jp"';
        $headers['Content-Transfer-Encoding'] = '7bit';
        
        //メールの送信
        $mail_object =& Mail::factory('sendmail', $params);
        $mail_object->send($recipients, $headers, $body);
    }

}
?>
