<?php // (Shirai017): コースバックアップファイルをダウンロードではなくmoodledata/temp/backupへ直接コピーする機能 (2013/10/15)

    require('../../../config.php');

    $userid      = required_param('userid', PARAM_INT);
    $courseid    = optional_param('courseid', 0, PARAM_INT); // needed for user tabs and c
    $action      = required_param('action', PARAM_ALPHANUM);
    $srcname     = required_param('filename', PARAM_PATH);
    $srcpath     = required_param('filepath', PARAM_PATH);
    $srcarea     = required_param('filearea', PARAM_AREA);
    $srccontexid = optional_param('filecontextid', 0, PARAM_INT);
    $srcitemid   = optional_param('itemid', 0, PARAM_INT);
    $destpath    = optional_param('destpath', NULL, PARAM_PATH);

    if (!fs_function_enable('FS_ENABLE_BLOGEXPORT')) {
        error('Blog Export function is not enabled!');
    }

    require_login();
    // 権限のチェック
    if (!can_export_blog($userid)) {
        print_error('youcannotexporttheseblogs', 'fs_moodle');
    }

    if (empty($courseid)) {
        $courseid = SITEID;
    }
    if (!$course = fs_get_record('course', 'id', $courseid)) {
        error('The course number was incorrect ('. $courseid .')');
    }
// $sitecontext = get_context_instance(CONTEXT_SYSTEM);
    $coursecontext   = get_context_instance(CONTEXT_COURSE, $course->id);

    course_setup($courseid);

    if (!$user = fs_get_record('user', 'id', $userid)) {
       error('Wrong user id');
    }
    $navlinks = array();
    $strblogexport = get_string('blogexport', 'fs_moodle');
    $strparticipants   = get_string("participants");

    if ($course->id != SITEID && has_capability('moodle/course:viewparticipants', $coursecontext)) {
        $navlinks[] = array('name' => $strparticipants, 'link' => "{$CFG->wwwroot}/user/index.php?id=$course->id", 'type' => 'misc');
    }

    $navlinks[] = array('name' => fullname($user), 'link' => "{$CFG->wwwroot}/user/view.php?id=$user->id&amp;course=$course->id", 'type' => 'misc');
    $navlinks[] = array('name' => $strblogexport, 'link' => null, 'type' => 'misc');
//  $navlinks[] = array('name' => $strmode, 'link' => null, 'type' => 'misc');
    $navigation = build_navigation($navlinks);

    print_header("$course->shortname: $strblogexport", $course->fullname, $navigation);

    require_capability('moodle/course:managefiles', get_context_instance(CONTEXT_COURSE, $course->id));

    if ($action === 'choosebackupfile') $destpath = $CFG->dataroot.'/temp/backup/');

// UI

    // Checking destpath
    if ($destpath === NULL) {
        error('Destpath is NULL');
    } else if (fs_file_exist($destpath)) {
        error('Destpath does not exist');
    }

/*  作成中．filelib.phpのfile_pluginfile()を参考に．
    // filecopy
    $fs = get_file_storage();

    if ($action === 'choosebackupfile') {
        if ($filearea === 'course' and $context->contextlevel == CONTEXT_COURSE) {
            require_login($course);
            require_capability('moodle/backup:downloadfile', $context);

            $filename = array_pop($args);
            $filepath = $args ? '/'.implode('/', $args).'/' : '/';
            if (!$file = $fs->get_file($context->id, 'backup', 'course', 0, $filepath, $filename) or $file->is_directory()) {
                send_file_not_found();
            }

            \core\session\manager::write_close(); // Unlock session during file serving.
            send_stored_file($file, 0, 0, $forcedownload, array('preview' => $preview));

        } else if ($filearea === 'section' and $context->contextlevel == CONTEXT_COURSE) {
            require_login($course);
            require_capability('moodle/backup:downloadfile', $context);

            $sectionid = (int)array_shift($args);

            $filename = array_pop($args);
            $filepath = $args ? '/'.implode('/', $args).'/' : '/';
            if (!$file = $fs->get_file($context->id, 'backup', 'section', $sectionid, $filepath, $filename) or $file->is_directory()) {
                send_file_not_found();
            }

            \core\session\manager::write_close();
            send_stored_file($file, 60*60, 0, $forcedownload, array('preview' => $preview));
    }
*/

    output_CloseWindowButton();

    print_footer($course);

?>
