<?php

// ------------------------------------------------------------
pagecheck();
// ------------------------------------------------------------

function fsconfig_check_languageSettings()
{
    global $CFG;

    print_section_header('言語パックに関する設定');

    print_subsection_header('グラフ表示で使用する日本語フォントファイル');

    if (fs_get_major_version() < 2.0)   $localfolder = $CFG->dataroot.'/lang/ja_utf8_local';
        else                            $localfolder = $CFG->dataroot.'/lang/ja_local';
    $fontfolder = $localfolder.'/fonts';
    echo '　Moodleでは統計データのグラフ表示にGDライブラリを使用します．';
    echo 'このライブラリでは文字の表示にdefault.ttfというファイル名のTrueTypeフォントを使用します．';
    echo 'Moodle1.9でもMoodle2.0以降でもlibフォルダにdefault.ttfというmoodle.orgが配布するフリーのフォントが格納されていますが，';
    echo 'このフォントファイルには漢字のデータが完全には含まれていません．';
    echo 'したがってMoodleサイトの管理者はなんらかの著作権フリーの漢字対応TrueTypeフォントを用意して適切な場所に配置する必要があります．';
    newline();
    echo '　たとえば'.fs_linktext('http://ossipedia.ipa.go.jp/ipafont/index.html', true, 'IPAフォント').'などがあります．';
    echo '等幅ゴシックフォント（ipag00303.zip：2012/04/11現在，4.09MB）のzipファイルをダウンロードしたとします．';
    echo 'このzipファイルの中の'.color_blue('ipag.ttf').'を'.color_blue('default.ttf').'というファイル名に変更して下さい．';
    echo 'そしてそれを'.color_blue($fontfolder).'へコピーして下さい．';
    echo 'このフォルダは言語パックを更新したとしても削除されることはありません．';
    newline();
    newline();
    echo '（参考URL）';
    newline();
    echo '　・'.link2shirai('86');
    newline();
    echo '　・'.fs_linktext('http://moodle.org/mod/forum/discuss.php?d=200261', true, 'moodle.org/Japanese Moodle');
    newline();
    newline();
    print_subsubsection_header('システムのチェック');
    echo '【フォントフォルダのチェック】';
    newline();
    if (is_dir($fontfolder)) {
        echo color_blue('OK').':'.$fontfolder.'が存在します．';
    } else {
        echo color_red('NG').':'.$fontfolder.'が存在しません！';
        newline();
        if (is_dir($localfolder)) {
            echo '　'.color_blue($localfolder).'は存在しますので，この下に'.color_blue('/fonts').'を作成して下さい．';
        } else {
            echo '　そもそも'.color_blue($localfolder).'が存在しません．';
            echo 'なお，'.color_blue($localfolder).'はサイト管理ブロック内の言語設定でローカルにて言語パックの編集を行うと自動作成されますが，どの道，/fontsは手作業で作成する必要がありますので…．';
        }
        newline();
        echo '　なお，手作業でフォルダを作成する際にパーミッションとオーナーの設定に注意して下さい．';
    }
    newline();
    newline();
    echo '【フォントファイルのチェック】';
    newline();
    if (file_exists($fontfolder.'/default.ttf')) {
        echo color_blue('OK').':'.$fontfolder.'にdefault.ttfが存在します．';
    } else {
        echo color_red('NG').':'.$fontfolder.'にdefault.ttfが存在しません！';
    }
    print_subsubsection_footer();
    print_subsection_footer();

    print_subsection_header_fs_switch('FS_ENABLE_MODIFIEDPARENTLANGUAGE');
    print_notice_message('注意', 'この設定は多くの場合において有効にする必要がありません．');
    echo '　Moodleの多言語対応機能には”親言語”という柔軟性の高い機能があります．';
    echo '各言語パックで親言語を指定してある場合，もしその言語に翻訳語が登録されていない時に，';
    echo '英語の単語（や文章）を表示するのではなく，親言語の言語パックを検索してくれます．';
    echo 'たとえば”関西弁”言語パックを作ったとしましょう．この関西弁言語パックのlangconfig.php内に';
    echo color_blue('$string['."'parentlanguage'] = 'ja_utf8';").'という記述を追加しておけば，';
    echo '関西弁言語パックに含まれていない翻訳語は日本語（ja）の言語パックから探してくれます．';
    newline();
    echo '　しかし，2010年5月現在，標準のMoodleの実装にバグがあります．標準の言語パックであれば問題はありません．';
    echo 'サードパーティ製プラグインの言語パックは各プラグインフォルダ内のlangフォルダ内に各言語用の言語パックを格納します．';
    echo 'この非標準の言語パックを参照する際に親言語の指定が正しく機能しません（ヘルプファイルだけは対応）．';
    echo 'fs_moodleの言語パックも同様です．';
    newline();
    echo '　この問題点はmoodle.orgに報告しますが，速やかに対処されるとは限りません．';
    echo color_red('もしあなたが日本語（ja）や英語（en）の言語パックしか使用しないのであれば全く問題はありません．無効のままご利用下さい．');
    newline();
    echo '　一方，もし独自の関西弁言語パックのような言語パックを作成して使用している場合や，';
    echo '2010年４月よりスタートした';
    echo '<a href="http://sourceforge.jp/projects/jak12/" target="_blank">K-12向け日本語言語パック</a>';
    echo 'などを利用する場合はこの機能を有効にして修正版のget_string()関数を利用する必要があります．';
    newline();
    print_fs_switch_condition('FS_ENABLE_MODIFIEDPARENTLANGUAGE');
    print_subsection_footer();

    print_section_footer();
}

fsconfig_check_languageSettings();

?>