###############################################################################
#
# åHTMLѡ
#
###############################################################################
package Wiki::CacheParser;
use Wiki::HTMLParser;
use vars qw(@ISA);
use strict;

@ISA = qw(Wiki::HTMLParser);
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	my $self  = Wiki::HTMLParser->new($wiki,0);
	return bless $self,$class;
}

#==============================================================================
# إåɥ饤
#==============================================================================
sub l_headline {
	my $self  = shift;
	my $level = shift;
	my $obj   = shift;
	my $wiki  = $self->{wiki};
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $html  = join("",@$obj);
	
	# ᥤɽΰǤʤȤ
	$self->{html} .= "<h".($level+1)."><!--p=".$self->{p_cnt}."-->".$html."<!--/p--></h".($level+1).">\n";
	$self->{p_cnt}++;
}

#==============================================================================
# ץ饰
#==============================================================================
sub plugin {
	my $self   = shift;
	my $plugin = shift;
	
	my $html = "\n<!--inline_plugin=".$plugin->{command}."-->\n";
	foreach my $arg (@{$plugin->{args}}){
		$html .= "  <!--arg=$arg-->\n";
	}
	$html .= "<!--/inline_plugin-->\n";
	
	return ($html);
}

#==============================================================================
# ѥ饰եץ饰
#==============================================================================
sub l_plugin {
	my $self   = shift;
	my $plugin = shift;
	
	if($self->{para}==1){
		$self->{html} .= "</p>";
		$self->{para} = 0;
	}
	
	$self->end_list;
	$self->end_verbatim;
	$self->end_table;
	$self->end_quote;
	
	my $html = "\n<!--paragraph_plugin=".$plugin->{command}."-->\n";
	foreach my $arg (@{$plugin->{args}}){
		$html .= "  <!--arg=$arg-->\n";
	}
	$html .= "<!--/paragraph_plugin-->\n";
	
	if(defined($html) && $html ne ""){
		$self->{html} .= $html;
	}
}

#==============================================================================
# åưŪʬޤ
#==============================================================================
sub process_cache {
	my $self = shift;
	my $html = shift;
	my $main = shift;
	
	my $result = "";
	my $count  = 0;
	
	$html =~ s/\r//g;
	my @lines = split(/\n/,$html);
	
	for($count=0;$count<=$#lines;$count++){
		$self->{html} = "";
		my $line = $lines[$count];
		# Фν
		if($line =~ /<!--p=([0-9]+?)-->/){
			if($main){
				$line =~ s/<!--p=([0-9]+?)-->/<a name="p$1">/;
				$line =~ s/<!--\/p-->/<\/a>/;
			}
			$result .= $line;
		# 饤ץ饰ν
		} elsif($line =~ /<!--inline_plugin=(.+?)-->/){
			my $plugin = {command=>$1,args=>[]};
			while(!($lines[$count] =~ /<!--\/inline_plugin-->/)){
				if($lines[$count] =~ /<!--arg=(.+?)-->/){
					push(@{$plugin->{args}},$1);
				}
				$count++;
			}
			my @plugin_result = $self->{wiki}->process_plugin($plugin,$self);
			$result .= join("",@plugin_result);
			
		# ѥ饰եץ饰ν
		} elsif($line =~ /<!--paragraph_plugin=(.+?)-->/){
			my $plugin = {command=>$1,args=>[]};
			while(!($lines[$count] =~ /<!--\/paragraph_plugin-->/)){
				if($lines[$count] =~ /<!--arg=(.+?)-->/){
					push(@{$plugin->{args}},$1);
				}
				$count++;
			}
			my $plugin_result = $self->{wiki}->process_plugin($plugin,$self);
			if(defined($plugin_result) && $plugin_result ne ""){
				$result .= $plugin_result;
			} else {
				$result .= $self->{html};
			}
		} else {
			$result .= $line;
		}
	}
	return $result;
}

1;
