###############################################################################
# <p>
# FSWikiǥեȤΥȥ졼ץ饰
# </p>
# <p>
# setup.datbackup=1⤷backupǥ쥯ƥ֤άϣΤߡ
# backup=2ʾ⤷0ꤷХååפбޤ
# backup=0ꤷ̵¤˥ХååפԤޤ
# </p>
###############################################################################
package Wiki::DefaultStorage;
use File::Copy;
use strict;

# ڡκǽϿե
$Wiki::DefaultStorage::MODTIME_FILE = "modtime.dat";

#==============================================================================
# <p>
# 󥹥ȥ饯
# </p>
#==============================================================================
sub new {
	my $class  = shift;
	my $wiki   = shift;
	my $backup = $wiki->{config}->{'backup'};
	
	if(!defined($backup) || $backup eq ""){
		$backup = 1;
	}
	
	my $self = {};
	$self->{wiki}          = $wiki;
	$self->{backup}        = $backup;
	$self->{exists_cache}  = {};
	$self->{modtime_cache} = undef;
	return bless $self,$class;
}

#==============================================================================
# <p>
# ڡ
# </p>
#==============================================================================
sub get_page {
	my $self = shift;
	my $page = shift;
	my $path = shift;
	
	my $dir = $self->{wiki}->config('data_dir');
	if($path ne ""){
		$dir = "$dir/$path";
	}
	
	my $content = "";
	my $filename = &Util::make_filename($dir,&Util::url_encode($page),"wiki");
	if(-e $filename){
		open(DATA,$filename) or die $!;
		binmode(DATA);
		while(<DATA>){
			$content = $content.$_;
		}
		close(DATA);
	}
	
	return $content;
}

#==============================================================================
# <p>
# ڡ¸
# </p>
#==============================================================================
sub save_page {
	my $self    = shift;
	my $page    = shift;
	my $content = shift;
	my $sage    = shift;
	my $wiki    = $self->{wiki};
	
	$content = '' if($content =~ /^[\r\n]+$/s); # added for opera
	
	# ڡ̾ȥڡƤ
	$page = Util::trim($page);
	$content =~ s/\r\n/\n/g;
	$content =~ s/\r/\n/g;
    
	# Хåå
	my $BACKUP = $self->get_page($page);
	if($BACKUP ne ""){
		my $backupfile = "";
		if($self->{backup}==1){
			$backupfile = &Util::make_filename($wiki->config('backup_dir'),&Util::url_encode($page),"bak");
		} else {
			$self->_rename_old_history($page);
			my $number = $self->_get_backup_number($page);
			$backupfile = &Util::make_filename($wiki->config('backup_dir'),&Util::url_encode($page),"$number.bak");
		}
		open(DATA,">$backupfile") or die $!;
		binmode(DATA);
		print DATA $BACKUP;
		close(DATA);
	}

	# Ͽե뤬ʤϺ
	unless(-e $wiki->config('config_dir')."/".$Wiki::DefaultStorage::MODTIME_FILE){
		my @list = $self->get_page_list();
		my $hash = {};
		foreach my $p (@list){
			$hash->{$p}=$self->get_last_modified($p);
		}
		&Util::save_config_hash($wiki,$Wiki::DefaultStorage::MODTIME_FILE,$hash);
	}
	
	# 񤭹
	if($content eq ""){
		unlink(&Util::make_filename($wiki->config('data_dir'),&Util::url_encode($page),"wiki"));
		# ϥХååץեĤ
		#unlink(&Util::make_filename($wiki->config('backup_dir'),&Util::url_encode($page),"bak"));
	} else {
		# 񤭤
		open(DATA,">".&Util::make_filename($wiki->config('data_dir'),&Util::url_encode($page),"wiki")) or die $!;
		binmode(DATA);
		print DATA $content;
		close(DATA);		
		# sageǤʤϹ򹹿
		if($sage != 1){
			my $modtime = &Util::load_config_hash($wiki,$Wiki::DefaultStorage::MODTIME_FILE);
			$modtime->{$page} = time();
			&Util::save_config_hash($wiki,$Wiki::DefaultStorage::MODTIME_FILE,$modtime);
		}
	}
}

#------------------------------------------------------------------------------
# <p>
# ХååץեͿֹץ饤١ȥ᥽å
# </p>
#------------------------------------------------------------------------------
sub _get_backup_number {
	my $self = shift;
	my $page = shift;
	my $wiki = $self->{wiki};
	my $num  = 0;
	my @backups = glob($wiki->config('backup_dir')."/".&Util::url_encode($page).".*.bak");
	foreach my $backup (@backups){
		if($backup =~ /^.+\.([0-9]+)\.bak$/){
			if($num < $1){
				$num = $1;
			}
		}
	}
	return $num + 1;
}

#------------------------------------------------------------------------------
# <p>
# ¸Ķʬץ饤١ȥ᥽å
# </p>
#------------------------------------------------------------------------------
sub _rename_old_history {
	my $self  = shift;
	my $page  = shift;
	my $wiki  = $self->{wiki};
	
	# ̵¤ξϲ⤷ʤ
	if($self->{backup}==0){
		return;
	}
	
	my @files = glob($wiki->config('backup_dir')."/".&Util::url_encode($page).".*.bak");
	
	@files = sort {
		$a =~ /^.+\.([0-9]+)\.bak$/;
		my $num_a = $1;
		$b =~ /^.+\.([0-9]+)\.bak$/;
		my $num_b = $1;
		return $num_a <=> $num_b;
	} @files;
	
	my $count = 1;
	for(my $i=0;$i<=$#files;$i++){
		if($i > $#files - $self->{backup} + 1){
			my $newfile = &Util::make_filename($wiki->config('backup_dir'),&Util::url_encode($page),"$count.bak");
			move($files[$i],$newfile) or die $!;
			$count++;
		} else {
			unlink($files[$i]);
		}
	}
}

#==============================================================================
# <p>
# ڡΰ
# </p>
#==============================================================================
sub get_page_list {
	my $self   = shift;
	my $args   = shift;
	my $wiki   = $self->{wiki};
	my $sort   = "name";
	my $permit = "all";
	my $max    = 0;
	
	# 
	if(defined($args)){
		if(defined($args->{-sort})){
			$sort = $args->{-sort};
		}
		if(defined($args->{-permit})){
			$permit = $args->{-permit};
		}
		if(defined($args->{-max})){
			$max = $args->{-max};
		}
	}
	
	# ڡΰ
	opendir(DIR,$self->{wiki}->config('data_dir')) or die $!;
	my ($entry,@list);
	while($entry = readdir(DIR)){
		my $name = &Util::url_decode(substr($entry,0,rindex($entry,".")));
		my $type = substr($entry,rindex($entry,"."));
		my $flag = 0;
		if($type eq ".wiki"){
			# ȸΤڡΤ
			if($permit eq "show"){
				if($wiki->can_show($name)){
					$flag = 1;
				}
				
			} elsif($permit eq "modify"){
				if($wiki->can_modify_page($name)){
					$flag = 1;
				}
				
			# ƤΥڡ
			} elsif($permit eq "all"){
				$flag = 1;
			
			# ʳξϥ顼
			} else {
				die "permitץλ꤬Ǥ";
			}
		}
		if($flag == 1){
			push(@list,$name);
		}
	}
	closedir(DIR);
	
	# ̾ǥ
	if($sort eq "name"){
		@list = sort { $a cmp $b } @list;
		
	# ʿˤ˥
	} elsif($sort eq "last_modified"){
		@list = sort {
			my $mod1 = $wiki->get_last_modified2($a);
			my $mod2 = $wiki->get_last_modified2($b);
			return $mod2 <=> $mod1;
		} @list;
	
	# ʳξϥ顼
	} else {
		die "sortץλ꤬Ǥ";
	}
	
	if($max==0){
		return @list;
	} else {
		my @result;
		my $items = $#list;
		for(my $i=0;$i<$max && $i<$items+1;$i++){
			push(@result,shift(@list));
		}
		return @result;
	}
}

#==============================================================================
# <p>
# ڡκǽʪŪ
# </p>
#==============================================================================
sub get_last_modified {
	my $self   = shift;
	my $page   = shift;
	my @status = stat(&Util::make_filename($self->{wiki}->config('data_dir'),&Util::url_encode($page),"wiki"));
	
	return $status[9];
}

#==============================================================================
# <p>
# ڡκǽŪ
# </p>
#==============================================================================
sub get_last_modified2 {
	my $self    = shift;
	my $page    = shift;
	my $modtime = $self->{modtime_cache};
	
	unless(defined($modtime)){
		$modtime = &Util::load_config_hash($self->{wiki},$Wiki::DefaultStorage::MODTIME_FILE);
		$self->{modtime_cache} = $modtime;
	}
	
	if(defined($modtime->{$page})){
		return $modtime->{$page};
	} else {
		return $self->get_last_modified($page);
	}
}

#===============================================================================
# <p>
# ڡ¸ߤ뤫ɤĴ٤
# </p>
#===============================================================================
sub page_exists {
	my $self = shift;
	my $page = shift;
	my $path = shift;
	
	if($self->{exists_cache} and defined($self->{exists_cache}->{"$path:$page"})){
		return $self->{exists_cache}->{"$path:$page"};
	}
	
	my $dir = $self->{wiki}->config('data_dir');
	if(defined $path and $path ne ""){
		$dir = "$dir/$path";
	}
	
	my $exists = (-e &Util::make_filename($dir,&Util::url_encode($page),"wiki"));
	$self->{exists_cache}->{"$path:$page"} = $exists;
	
	return $exists;
}

#==============================================================================
# <p>
# Хååץפ(single|all)
# setup.datƤˤäơΤߤξsingle
# ХååפԤäƤallֵѤޤ
# </p>
#==============================================================================
sub backup_type {
	my $self = shift;
	
	if($self->{backup}==1){
		return "single";
	} else {
		return "all";
	}
}

#==============================================================================
# <p>
# ХååפԤäƤ˥Хåå׻ΰޤ
# ΤߥХååפưƤundef֤ޤ
# </p>
#==============================================================================
sub get_backup_list {
	my $self = shift;
	my $page = shift;
	
	if($self->{backup}==1){
		return undef;
	} else {
		my $wiki = $self->{wiki};
		my @files = glob($wiki->config('backup_dir')."/".Util::url_encode($page).".*.bak");
		
		@files = sort {
			$a =~ /^.+\.([0-9]+)\.bak$/;
			my $num_a = $1;
			$b =~ /^.+\.([0-9]+)\.bak$/;
			my $num_b = $1;
			return $num_b <=> $num_a;
		} @files;
		
		my @datelist;
		
		foreach my $file (@files){
			my @status = stat($file);
			push(@datelist,Util::format_date($status[9]));
		}
		
		return @datelist;
	}
}

#==============================================================================
# <p>
# Хååפޤ
# backup_type=allξ(0)ꤷޤ
# </p>
#==============================================================================
sub get_backup {
	my $self     = shift;
	my $page     = shift;
	my $gen      = shift;
	my $content  = "";
	my $filename = "";
	
	if($self->{backup}!=1){
		# Хååפ꤬ʤϺǿΥХååפ
		if(!defined($gen) || $gen eq ""){
			my @list = $self->get_backup_list($page);
			$gen = $#list;
		}
		$filename = &Util::make_filename($self->{wiki}->config('backup_dir'),&Util::url_encode($page),($gen+1).".bak");
		Util::debug("Хååץե̾:$filename");
	} else {
		$filename = &Util::make_filename($self->{wiki}->config('backup_dir'),&Util::url_encode($page),"bak");
	}
	if(-e $filename){
		open(DATA,$filename) or die $!;
		binmode(DATA);
		while(<DATA>){
			$content = $content.$_;
		}
		close(DATA);
	}
	
	return $content;
}

#==============================================================================
# <p>
# ڡ뤷ޤ
# </p>
#==============================================================================
sub freeze_page {
	my $self     = shift;
	my $pagename = shift;
	
	if(!$self->is_freeze($pagename)){
		open(DATA,">>".$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
		binmode(DATA);
		print DATA $pagename."\n";
		close(DATA);
		
		# 쥯Ȥפɡ
		push(@{$self->{freeze_list}},$pagename);
	}
}

#==============================================================================
# <p>
# ڡޤ
# </p>
#==============================================================================
sub un_freeze_page {
	my $self = shift;
	my $pagename = shift;
	
	if($self->is_freeze($pagename)){
		my $buf = "";
		open(DATA,$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
		while(<DATA>){
			chomp $_;
			if($pagename ne $_){
				$buf .= $_."\n";
			}
		}
		close(DATA);
		
		open(DATA,">".$self->{wiki}->config('log_dir')."/".$self->{wiki}->config('freeze_file')) or die $!;
		binmode(DATA);
		print DATA $buf;
		close(DATA);
		
		# 쥯Ȥפɡ
		@{$self->{freeze_list}} = grep(!/^\Q$pagename\E$/,@{$self->{freeze_list}});
	}
}

#==============================================================================
# <p>
# ꥹȤ
# </p>
#==============================================================================
sub get_freeze_list {
	my $self = shift;
	my $path = shift;
	
	if(!defined($path)){
		$path = "";
	}
	
	if(defined($self->{"$path:freeze_list"})){
		return @{$self->{"$path:freeze_list"}};
	}
	
	my $logdir = $self->{wiki}->config('log_dir');
	if($path ne ""){
		$logdir .= "/$path";
	}
	
	my @list;
	if(!-e "$logdir/".$self->{wiki}->config('freeze_file')){
		return @list;
	}
	
	open(DATA,"$logdir/".$self->{wiki}->config('freeze_file')) or die $!;
	while(<DATA>){
		chomp $_;
		push @list,$_;
	}
	close(DATA);
	
	$self->{"$path:freeze_list"} = \@list;
	return @list;
}

#==============================================================================
# <p>
# Ϥڡ椫ɤ٤ޤ
# </p>
#==============================================================================
sub is_freeze {
	my $self     = shift;
	my $pagename = shift;
	my $path     = shift;
	
	foreach my $freeze_page ($self->get_freeze_list($path)){
		if($freeze_page eq $pagename){
			return 1;
		}
	}
	
	return 0;
}

#==============================================================================
# <p>
# ڡλȥ٥ꤷޤ
# </p>
#==============================================================================
sub set_page_level {
	my $self  = shift;
	my $page  = shift;
	my $level = shift;
	
	my $all = &Util::load_config_hash($self->{wiki},"showlevel.log");
	$all->{$page} = $level;
	&Util::save_config_hash($self->{wiki},"showlevel.log",$all);
}

#==============================================================================
# <p>
# ڡλȥ٥ޤ
# </p>
#==============================================================================
sub get_page_level {
	my $self = shift;
	my $page = shift;
	my $path = shift;
	
	if(!defined($path)){
		$path = "";
	}
	
	unless(defined($self->{"$path:show_level"})){
		# config_dir򺹤ؤƼ¹
		my $configdir = $self->{wiki}->config('config_dir');
		if($path ne ""){
			$self->{wiki}->config('config_dir',"$configdir/$path");
		}
		
		$self->{"$path:show_level"} = &Util::load_config_hash($self->{wiki},"showlevel.log");
		
		# config_dir򸵤᤹
		$self->{wiki}->config('config_dir',$configdir);
	}
	
	if(defined($page)){
		if(defined($self->{"$path:show_level"}->{$page})){
			return $self->{"$path:show_level"}->{$page};
		} else {
			return 0;
		}
	} else {
		return $self->{"$path:show_level"};
	}
}

#==============================================================================
# <p>
# λ˸ƤӽФޤ󥹥ѿλȤޤ
# </p>
#==============================================================================
sub finalize {
	my $self = shift;
	undef($self->{wiki});
}

1;
