###############################################################################
#
# ɥѡ
#
###############################################################################
package Wiki::Keyword;

#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	
	my $self  = {};
	$self->{wiki} = $wiki;
	bless $self,$class;

	$self->parse;
	return bless $self;
}

#==============================================================================
# ɤޤޤ뤫ɤå
#==============================================================================
sub exists_keyword {
	my $self = shift;
	my $str  = shift;
	
	my @keywords = @{$self->{keywords}};
	
	if(defined(@keywords)){
		foreach(@keywords){
			my $index = index($str,$_->{word});
			if($index!=-1){
				$g_pre   = substr($str,0,$index);
				$g_post  = substr($str,($index+length($_->{word})));
				$g_label = $_->{word};
				$g_url   = $_->{url};
				$g_page  = $_->{page};
				return 1;
			}
		}
	}
	return 0;
}

#==============================================================================
# ǥХå
#==============================================================================
sub print_string {
	my $self = shift;
	my @keywords = @{$self->{keywords}};
	if(defined(@keywords)){
		foreach(@keywords){
			print $_->{word},"-",$_->{url},"-",$_->{page},"\n";
		}
	}
}

#==============================================================================
# ѡʥ󥹥ȥ饯ƤФޤ
#==============================================================================
sub parse {
	my $self = shift;
	my $wiki = $self->{wiki};
	if($wiki->page_exists("Keyword")){
		my $source = $wiki->get_page("Keyword");
		$source =~ s/\r//g;
		my @lines = split(/\n/,$source);
		foreach my $line (@lines){
			if(index($line,"*")==0){
				$self->parse_line($line);
			}
		}
	}
	if($main::auto_keyword_page==1){
		my @pages = $wiki->get_page_list;
		# A,B,A+BȤȤ
		# A+BΥɤA,Bʬ򤵤ʤ褦ʸĹǥ
		@pages = sort {
			my $len_a = length($a);
			my $len_b = length($b);
			return $len_b <=> $len_a;
	    } @pages;
		foreach my $page (@pages){
			$self->parse_line("[[$page|$page]]");
		}
	}
}

sub parse_line {
	my $self   = shift;
	my $source = shift;
	
	# ̾
	if($source =~ /\[([^\[]+?)\|((http|https|ftp):[a-zA-Z0-9\.%~^_+\-%\/\?&=:;\*#@]*)\]/){
		#my $pre   = $`;
		#my $post  = $';
		my $label = $1;
		my $url   = $2;
		#if($pre ne ""){ $self->parse_line($pre); }
		push @array,$self->url_anchor($url,$label);
		#if($post ne ""){ $self->parse_line($post); }
		
	# ڡ̾
	} elsif($source =~ /\[\[([^\[]+?)\|(.+?)\]\]/){
		#my $pre   = $`;
		#my $post  = $';
		my $label = $1;
		my $page  = $2;
		#if($pre ne ""){ $self->parse_line($pre); }
		push @array,$self->wiki_anchor($page,$label);
		#if($post ne ""){ $self->parse_line($post); }
	}
}

#==============================================================================
# URL
#==============================================================================
sub url_anchor {
	my $self = shift;
	my $url  = shift;
	my $name = shift;
	
	if($name eq ""){
		$name = $url;
	}
	my $keyword = {};
	$keyword->{word} = $name;
	$keyword->{url}  = $url;
	push(@{$self->{keywords}},$keyword);
}

#==============================================================================
# Wiki
#==============================================================================
sub wiki_anchor {
	my $self = shift;
	my $page = shift;
	my $name = shift;
	
	if($name eq ""){
		$name = $page;
	}
	my $keyword = {};
	$keyword->{word} = $name;
	$keyword->{page} = $page;
	push(@{$self->{keywords}},$keyword);
}

1;
