################################################################################
#
# ѡΥѡ饹
#
################################################################################
package Wiki::Parser;
use Wiki::Keyword;
use Wiki::InterWiki;

#===============================================================================
# 󥹥ȥ饯
#===============================================================================
sub new {
	my $class   = shift;
	my $wiki    = shift;
	
	my $self = {};
	$self->{wiki}    = $wiki;
	$self->{keyword} = Wiki::Keyword->new($wiki);
	$self->{interwiki} = Wiki::InterWiki->new($wiki);
	
	$self->{dl_flag} = 0;
	$self->{dt} = "";
	$self->{dd} = "";
	
	return bless $self,$class;
}

#===============================================================================
# ѡ
#===============================================================================
sub parse {
	my $self   = shift;
	my $source = shift;
	
	$self->start_parse;
	$source =~ s/\r//g;
	
	my @lines = split(/\n/,$source);
	
	foreach my $line (@lines){
		chomp $line;
		
		# ʣԤ
		$self->multi_explanation($line);
		
		# PRE
		if(index($line," ")==0 || index($line,"\t")==0){
			$self->l_verbatim($line);
			
		# Ф
		} elsif(index($line,"!!!")==0){
			my @obj = $self->parse_line(substr($line,3));
			$self->l_headline(1,\@obj);
			
		} elsif(index($line,"!!")==0){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_headline(2,\@obj);
			
		} elsif(index($line,"!")==0){
			my @obj = $self->parse_line(substr($line,1));
			$self->l_headline(3,\@obj);

		# 
		} elsif(index($line,"***")==0){
			my @obj = $self->parse_line(substr($line,3));
			$self->l_list(3,\@obj);
			
		} elsif(index($line,"**")==0){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_list(2,\@obj);
			
		} elsif(index($line,"*")==0){
			my @obj = $self->parse_line(substr($line,1));
			$self->l_list(1,\@obj);
		
		# ʿ
		} elsif($line eq "----"){
			$self->l_line();
		
		# 
		} elsif(index($line,"\"\"")==0){
			my @obj = $self->parse_line(substr($line,2));
			$self->l_quotation(\@obj);
			
		# 
		} elsif(index($line,":")==0 && index($line,":",1)!=-1){
			if(index($line,":::")==0){
				$self->{dd} .= substr($line,3);
				next;
			}			
			if(index($line,"::")==0){
				if($self->{dt} ne "" || $self->{dd} ne ""){
					$self->multi_explanation;
				}
				$self->{dt} = substr($line,2);
				$self->{dl_flag} = 1;
				next;
			}
			my $dt = substr($line,1,index($line,":",1)-1);
			my $dd = substr($line,index($line,":",1)+1);
			my @obj1 = $self->parse_line($dt);
			my @obj2 = $self->parse_line($dd);
			$self->l_explanation(\@obj1,\@obj2);
			
		# 
		} elsif($line eq ""){
			$self->l_paragraph();
			
		# ץ饰
		#} elsif($line =~ /^{{((.|\s)+?)}}/){
		#	my $right = $';
		#	$self->{html} .= $self->plugin($1);
		#	if($right ne ""){
		#		my @obj = $self->parse_line($');
		#		$self->l_text(\@obj);
		#	}
			
		# ơ֥
		} elsif(index($line,",")==0){
			my @spl = split(/,/,substr($line,1));
			my @array;
			foreach(@spl){
				my @cell = $self->parse_line($_);
				push @array,\@cell;
			}
			$self->l_table(\@array);
			
		# ʤ
		} else {
			my @obj = $self->parse_line($line);
			$self->l_text(\@obj);
		}
	}
	
	# ʣԤ
	$self->multi_explanation;
	
	$self->end_parse;
}

#===============================================================================
# ʣԤ
#===============================================================================
sub multi_explanation {
	my $self = shift;
	my $line = shift;
	if($self->{dl_flag}==1 && (index($line,":")!=0 || !defined($line))){
		my @obj1 = $self->parse_line($self->{dt});
		my @obj2 = $self->parse_line($self->{dd});
		$self->l_explanation(\@obj1,\@obj2);
		$self->{dl_flag} = 0;
		$self->{dt} = "";
		$self->{dd} = "";
	}
}

#===============================================================================
# ʬѡ
#===============================================================================
sub parse_line {
	my $self   = shift;
	my $source = shift;
	my @array;
	# ܡ
	if($source =~ /(''')(.+?)(''')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->bold($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
	
	# å
	} elsif($source =~ /('')(.+?)('')/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->italic($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
	
	# 
	} elsif($source =~ /(__)(.+?)(__)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->underline($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }

	# Ǥä
	} elsif($source =~ /(==)(.+?)(==)/){
		my $pre   = $`;
		my $post  = $';
		my $label = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->denialline($label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# ̾
	} elsif($source =~ /\[([^\[]+?)\|((http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?&=:;\*#@]*)\]/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $url   = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->url_anchor($url,$label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# URL
	} elsif($source =~ /(http|https|ftp|mailto):[a-zA-Z0-9\.,%~^_+\-%\/\?&=:;\*#@]*/
	    ||  $source =~ /\[([^\[]+?)\|(file:[^\[\]]*)\]/){
		my $pre   = $`;
		my $post  = $';
		my $url = $&;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->url_anchor($url);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# InterWikiName
	} elsif($self->{interwiki}->exists_interwiki($source)){
		my $pre   = $Wiki::InterWiki::g_pre;
		my $post  = $Wiki::InterWiki::g_post;
		my $label = $Wiki::InterWiki::g_label;
		my $url   = $Wiki::InterWiki::g_url;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->url_anchor($url,$label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# ڡ̾
	} elsif($source =~ /\[\[([^\[]+?)\|(.+?)\]\]/){
		my $pre   = $`;
		my $post  = $';
		my $label = $1;
		my $page  = $2;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->wiki_anchor($page,$label);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
	
	# ڡ
	} elsif($source =~ /\[\[([^\[]+?)\]\]/){
		my $pre   = $`;
		my $post  = $';
		my $page = $1;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->wiki_anchor($page);
		if($post ne ""){ push(@array,$self->parse_line($post)); }

	# ץ饰
	} elsif($source =~ /{{((.|\s)+?)}}/){
		my $pre  = $`;
		my $post = $';
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->plugin($1);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
	
	# 
	} elsif($self->{keyword}->exists_keyword($source)){
		my $pre   = $Wiki::Keyword::g_pre;
		my $post  = $Wiki::Keyword::g_post;
		my $label = $Wiki::Keyword::g_label;
		my $url   = $Wiki::Keyword::g_url;
		my $page  = $Wiki::Keyword::g_page;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		if($url ne ""){
			push @array,$self->url_anchor($url,$label);
		} else {
			push @array,$self->wiki_anchor($page,$label);
		}
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	# WikiName
	} elsif($main::wikiname==1 && $source =~ /[A-Z]+?[a-z]+?([A-Z]+?[a-z]+)+/){
		my $pre   = $`;
		my $post  = $';
		my $page  = $&;
		if($pre ne ""){ push(@array,$self->parse_line($pre)); }
		push @array,$self->wiki_anchor($page);
		if($post ne ""){ push(@array,$self->parse_line($post)); }
		
	} else {
		push @array,$self->text($source);
	}
	
	return @array;
}

# ѡ򳫻
sub start_parse {}

# ѡλ
sub end_parse {}

# URL
sub url_anchor {}

# ڡ̾
sub wiki_anchor {}

# å
sub italic {}

# ܡ
sub bold {}

# 
sub underline {}

# Ǥä
sub denialline {}

# ץ饰
sub plugin {}

# ƥ
sub text{}

# 
sub l_list {}

# Ф
sub l_headline {}

# PRE
sub l_verbatim {}

# ʿ
sub l_line {}

# äˤʤˤʤ
sub l_text {}

# 
sub l_explanation {}

# 
sub l_quotation {}

# ѥ饰դζڤ
sub l_paragraph {}

# ơ֥
sub l_table {}



1;
