###############################################################################
#
# bugtrackץ饰Ƥ줿Хΰɽޤ
# 2formͿȾѹѤΥեबޤ
# <pre>
# {{buglist ץ̾[,form]}}
# </pre>
#
###############################################################################
package plugin::bugtrack::BugList;
use plugin::bugtrack::BugState;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}
#==============================================================================
# 饤᥽å
#==============================================================================
sub inline {
	my $self = shift;
	my $wiki = shift;
	my $project = shift;
	my $form = shift;

	if($project eq ""){
		return "<font class=\"error\">ץ̾ꤵƤޤ</font>";
	}

	# formʳʸ̵
	if($form ne "form"){
	    $form = 0;
	}
	
	my @pages = $wiki->get_page_list;
	my $bugs = {};
	foreach(@pages){
		if($_ =~ /^BugTrack-$project\/([0-9]+)$/){
			my $pagename = $_;
			my $count    = $1;
			my $category = "";
			my $status   = "";
			my $priority = "";
			my $name     = "";
			my $subject  = "";
			
			my $page = $wiki->get_page($pagename);
			my @lines = split(/\n/,$page);
			my $first = 0;
			foreach(@lines){
				$_ =~ s/\r//;
				if($first==0 && $_ =~ /^!!!(.*)/){
					$subject = $1;
				} elsif($_ =~ /^\*ƥꡧ\s*(.*)/){
					$category = $1;
				} elsif($_ =~ /^\*ͥ١\s*(.*)/){
					$priority = $1;
				} elsif($_ =~ /^\*֡\s*(.*)/){
					$status = $1;
				} elsif($_ =~ /^\*Ƽԡ\s*(.*)/){
					$name = $1;
				} elsif($_ =~ /^\*\s*(.*)/){
					$date = $1;
				}
			}
			my $bug = {page     =>$pagename,
			           count    =>$count,
			           category =>$category,
			           status   =>$status,
			           priority =>$priority,
			           name     =>$name,
			           date     =>$date,
			           subject  =>$subject,
				   form     =>$form };
			
			push(@{$bugs->{$status}},$bug);
		}
	}
	
	my $buf = "<table border>\n".
	          "<tr>".
	          "<th><br></th>".
	          "<th>ƥ</th>".
	          "<th>ͥ</th>".
	          "<th></th>".
	          "<th>Ƽ</th>".
	          "<th>ޥ</th>".
	          "</tr>\n";
	
	my $tmp = $buf;
	
	$buf .= make_row(@{$bugs->{""}}       ,"#FFDDDD",$wiki);
	$buf .= make_row(@{$bugs->{""}}       ,"#FFFFDD",$wiki);
	$buf .= make_row(@{$bugs->{"λ"}}       ,"#DDFFDD",$wiki);
	$buf .= make_row(@{$bugs->{"꡼"}}  ,"#DDDDFF",$wiki);
	$buf .= make_row(@{$bugs->{"α"}}       ,"#DDDDDD",$wiki);
	$buf .= make_row(@{$bugs->{"Ѳ"}}       ,"#FFFFFF",$wiki);
	
	if($buf eq $tmp){
		$buf .= "<tr><td colspan=\"6\" align=\"center\">ХݡȤϤޤ</td></tr>\n";
	}
	
	return $buf .= "</table>\n";
}

#==============================================================================
# ʬΥǡϤѴؿ
#==============================================================================
sub make_row {
        my $wiki = pop;
	my $color = pop;
	my @row   = sort by_count @_;
	my $buf = "";
	
	foreach(@row){
		$buf .= "<tr bgcolor=\"$color\">".
		        "<td><a href=\"$main::script_name?page=".Util::url_encode($_->{page})."\">".Util::escapeHTML($_->{page})."</a></td>".
		        "<td>".Util::escapeHTML($_->{category})."</td>".
		        "<td>".Util::escapeHTML($_->{priority})."</td>".
		        "<td>".Util::escapeHTML($_->{status})."</td>".
		        "<td>".Util::escapeHTML($_->{name})."</td>".
		        "<td>".Util::escapeHTML($_->{subject})."</td>".
		        "</tr>\n";

		# եɽ
		if($_->{form}){
		    my $page = $wiki->get_CGI->param("page");
		    my $source = $_->{page};
		    my $form = plugin::bugtrack::BugState::make_form($wiki,$page,$source);
		    $buf .= "<tr bgcolor=\"$color\"><td colspan=\"6\">".
			$form."</td></tr>";
		}
	}
	return $buf;
}

#==============================================================================
# ȴؿ
#==============================================================================
sub by_count {
	my $a_count = $a->{count};
	my $b_count = $b->{count};
	return $b_count <=> $a_count;
}

1;
