################################################################################
#
# CalendarΥϥɥ顣
#
################################################################################
package plugin::calendar::CalendarHandler;
#===============================================================================
# 󥹥ȥ饯
#===============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#===============================================================================
# ڡ̾
#===============================================================================
sub make_pagename {
	my $year  = shift;
	my $month = shift;
	my $day   = shift;
	my $name  = shift;
	
	return $name."/".$year."-".$month."-".$day;
}

#===============================================================================
# 
#===============================================================================
sub make_calendar {
	my $wiki     = shift;
	my $o_year   = shift;
	my $o_month  = shift;
	my $name     = shift;
	my $template = shift;
	
	# ڡȤΥ
	my $style = "font-weight: bold; font-size: 120%;";
	my @week = ("","","","","","","");
	my $time = time();
	
	my ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
	$year += 1900;
	$mon  += 1;
	my $today_year  = $year;
	my $today_month = $mon;
	my $today_day   = $mday;
	
	my $o_yearmon = sprintf("%04d%02d",$o_year,$o_month);
	
	while($year!=$o_year || $mon!=$o_month){
		my $yearmon = sprintf("%04d%02d",$year,$mon);
		if($o_yearmon > $yearmon){
			$time += 24 * 60 * 60;
		} else {
			$time -= 24 * 60 * 60;
		}
		($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
		$year += 1900;
		$mon  += 1;
	}
	
	my $buf = "<table>\n".
	          "<tr><th colspan=\"7\">".
	          "<a href=\"$main::script_name?action=CALENDAR&amp;".&make_anchor($year,$mon,-1,$name,$template)."\">&lt;&lt;</a> ".
	          "<a href=\"$main::script_name?action=CALENDAR&amp;".&make_anchor($year,$mon, 0,$name,$template)."\">$o_year-$o_month</a> ".
	          "<a href=\"$main::script_name?action=CALENDAR&amp;".&make_anchor($year,$mon,+1,$name,$template)."\">&gt;&gt;</a></th></tr>\n".
	          "<tr>";
	foreach(@week){
		$buf.="<th>".$_."</th>";
	}
	$buf .= "</tr>\n";
	
	my $time = $time - (($mday-1) * 24 * 60 * 60);
	my $now_month = $mon;
	
	my $start_flag = 1;
	while($now_month==$mon){
		($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
		$year += 1900;
		$mon  += 1;
		if($mon!=$now_month){
			last;
		}
		if($start_flag){
			$buf .= "<tr>";
			for(my $i=0;$i<$wday;$i++){
				$buf .= "<td></td>";
			}
			$start_flag = 0;
		}
		my $page =&make_pagename($year,$mon,$mday,$name);
		$buf .= "<td align=\"right\"";
		# 
		if($year==$today_year && $mon==$today_month && $mday==$today_day){
			$buf .= " bgcolor=\"#FF8888\"";
		}
		$buf .= ">";
		if($wiki->page_exists($page)){
			$buf .= "<a href=\"$main::script_name?page=".Util::url_encode($page)."\" style=\"$style\">$mday</a>";
		} else {
			$buf .= "<a href=\"$main::script_name?page=".Util::url_encode($page)."&amp;template=".Util::url_encode($template)."\">$mday</a>";
		}
		$buf .= "</td>";
		
		if($wday==6){
			$buf .= "</tr>\n";
			$start_flag = 1;
		}
		$time += 24 * 60 * 60;
	}
	$buf .= "</tr>\n";
	
	return $buf."</table>\n"

}

#===============================================================================
# 󥫤Υѥ᡼
#===============================================================================
sub make_anchor {
	my $year  = shift;
	my $month = shift;
	my $plus  = shift;
	my $name  = shift;
	my $template = shift;
	
	$month += $plus;
	if($month==13){
		$year += 1;
		$month = 1;
	} elsif($month==0){
		$year -= 1;
		$month = 12;
	}
	
	return "year=".$year."&amp;month=".$month."&amp;name=".Util::url_encode($name).
	       "&template=".Util::url_encode($template);
}

#===============================================================================
# ʬ
#===============================================================================
sub make_month_pages {
	my $wiki = shift;
	my $year = shift;
	my $month = shift;
	my $name = shift;
	
	my $cgi = $wiki->get_CGI;
	my $page = $cgi->param("page");
	my $buf = "";
	
	for(my $i=31;$i>=1;$i--){
		my $pagename = &make_pagename($year,$month,$i,$name);
		if($wiki->page_exists($pagename)){
			my $content = $wiki->get_page($pagename);
			$cgi->param("page",$pagename);
			$buf .= $wiki->process_wiki("!!![[$year-$month-$i|$pagename]]\n".$content);
			$cgi->param("page",$page);
		}
	}
	
	return $buf;
}

#===============================================================================
# κǿxɽ
# RecentCalendarȤΤǥ᥽åɤǤϤʤ⥸塼ؿȤƼ
#===============================================================================
sub make_recent_pages {
	my $wiki = shift;
	my $name = quotemeta(shift);
	my $count = shift;
	my $cgi = $wiki->get_CGI;
	my $buf = "";

	if($count eq ""){
		$count = 1;
	}

	my @pages = $wiki->get_page_list;

	# ̾/ǯ--Ф
	@pages = grep(/^$name\/\d+-\d+-\d+$/,@pages);
	
	# ս˥
	@pages = sort {
		$a=~/^$name\/(\d+)-(\d+)-(\d+)$/;
		my $a_tmp = sprintf("%04d%02d%02d",$1,$2,$3);
		
		$b=~/^$name\/(\d+)-(\d+)-(\d+)$/;
		my $b_tmp = sprintf("%04d%02d%02d",$1,$2,$3);
		
		return $b_tmp<=>$a_tmp;
	} @pages ;

	# ̤ΤΤϽ
	my @peges2;
	my ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime(time());
	my $today = sprintf("%04d%02d%02d",$year+1900,$mon+1,$mday);
	foreach(@pages){
		$_=~/^$name\/(\d+)-(\d+)-(\d+)$/;
		my $tmp = sprintf("%04d%02d%02d",$1,$2,$3);
		if($tmp <= $today){
			push(@pages2,$_);
		}
	}
	
	# calendarץ饰Ʊͤɽ
	foreach my $page (@pages2){
		$page =~ /(\d+)-(\d+)-(\d+)$/;
		#$buf .= "\n!!![[$1-$2-$3|$page]]\n";
		my $pagetmp = $cgi->param("page");
		$cgi->param("page",$page);
		$buf .= $wiki->process_wiki("!!![[$1-$2-$3|$page]]\n".$wiki->get_page($page));
		$cgi->param("page",$pagetmp);
	
		$count--;
		last unless $count;
	}
	return $buf;
}

#===============================================================================
# ϥɥ᥽å
#===============================================================================
sub do_action {
	my $self = shift;
	my $wiki = shift;
	my $cgi = $wiki->get_CGI;
	
	my $name     = $cgi->param("name");
	my $year     = $cgi->param("year");
	my $month    = $cgi->param("month");
	my $template = $cgi->param("template");
	
	if($name eq "" || !Util::check_numeric($year) || !Util::check_numeric($month)){
		return $wiki->error("ѥ᡼Ǥ");
		
	} else {
		$wiki->set_title("$name/$year-$month");
		return &make_calendar($wiki,$year,$month,$name,$template).
		       &make_month_pages($wiki,$year,$month,$name);
	}
}
1;
