###############################################################################
#
# RSSץ饰
#
###############################################################################
package plugin::core::RSS;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}
#==============================================================================
# ϥɥ᥽å
#==============================================================================
sub do_action {
	my $self = shift;
	my $wiki = shift;
	
	# 
	my @list = $wiki->get_page_list;
	@list = sort by_mod_date(@list);
	
	# URI
	my $uri = "http://".$ENV{'SERVER_NAME'};
	if($ENV{'SERVER_PORT'}!=80){
		$uri .= ":".$ENV{'SERVER_PORT'};
	}
	$uri .= $ENV{'SCRIPT_NAME'};
	
	# RSS쥹ݥ
	print "Content-Type: text/xml\n\n";
	print "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>\n";
	print "<!DOCTYPE rss PUBLIC \"-//Netscape Communications//DTD RSS 0.91//EN\"\n";
	print "            \"http://my.netscape.com/publish/formats/rss-0.91.dtd\">\n";
	print "<rss version=\"0.91\">\n";
	print "  <channel>\n";
	print "    <title>$main::site_title</title>\n";
	print "    <link>$uri?action=RSS</link>\n";
	print "    <description>$main::site_title RecentChanges</description>\n";
	print "    <language>ja</language>\n";
	my $count = 0;
	foreach(@list){
		if($count==15){
			last;
		}
		print "    <item>\n";
		print "      <title>".Util::escapeHTML($_)."</title>\n";
		print "      <link>$uri?page=".Util::url_encode($_)."</link>\n";
		print "      <description>".&format_date($wiki->get_last_modified($_))."</description>\n";
		print "    </item>\n";
		$count++;
	}
	print "  </channel>\n";
	print "</rss>\n";
	
	exit;
}

#==============================================================================
# դեޥå
#==============================================================================
sub format_date {
	my $time = shift;
	my ($sec, $min, $hour, $mday, $mon, $year, $wday) = localtime($time);
	return sprintf("%04d/%02d/%02d %02d:%02d:%02d",
	               $year+1900,$mon+1,$mday,$hour,$min,$sec);
}
#==============================================================================
# դǥ
#==============================================================================
sub by_mod_date {
	my $mod1 = (stat(Util::make_filename($main::data_dir,Util::url_encode($a),"wiki")))[9];
	my $mod2 = (stat(Util::make_filename($main::data_dir,Util::url_encode($b),"wiki")))[9];
	
	if($mod1 > $mod2){
		return -1;
	} elsif($mod1 < $mod2){
		return 1;
	} else {
		return 0;
	}
}

1;
