###############################################################################
#
# Wiki API
#
###############################################################################
package Wiki;
use strict;
use Util;
use Wiki::HTMLParser;
use Wiki::DefaultStorage;
#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	
	$self->{"handler"} = {};
	$self->{"handler_permission"} = {};
	
	$self->{"plugin"}  = {};
	$self->{"title"}   = "";
	$self->{"menu"}    = [];
	$self->{"CGI"}     = shift;
	$self->{"hook"}    = {};
	$self->{"storage"} = Wiki::DefaultStorage->new($self);
	$self->{"config"}  = &Util::load_config_hash(undef,"setup.dat");
	$self->{"config"}->{"plugin_dir"} = ".";
	$self->{"user"}       = ();
	$self->{"admin_menu"} = ();
	$self->{"editform"}   = ();
	$self->{"edit"}       = 0;
	
	return bless $self,$class;
}

#==============================================================================
# Х⤷ѹޤ
#==============================================================================
sub config {
	my $self  = shift;
	my $name  = shift;
	my $value = shift;
	if(defined($value)){
		$self->{config}->{$name} = $value;
	} else {
		return $self->{config}->{$name};
	}
}

#==============================================================================
# 桼ɲäޤ
#==============================================================================
sub add_user {
	my $self = shift;
	my $id   = shift;
	my $pass = shift;
	my $type = shift;
	
	push(@{$self->{"user"}},{id=>$id,pass=>$pass,type=>$type});
}

#==============================================================================
# 桼¸ߤ뤫ɤǧޤ
#==============================================================================
sub user_exists {
	my $self = shift;
	my $id   = shift;
	foreach my $user (@{$self->{"user"}}){
		if($user->{id} eq $id){
			return 1;
		}
	}
	return 0;
}

#==============================================================================
# ԽեѤΥץ饰ɲäޤ
#==============================================================================
sub add_editform_plugin {
	my $self   = shift;
	my $plugin = shift;
	my $weight = shift;
	push(@{$self->{"editform"}},{class=>$plugin,weight=>$weight});
}

#==============================================================================
# ԽեѤΥץ饰νϤޤ
#==============================================================================
sub get_editform_plugin {
	my $self = shift;
	my $buf = "";
	foreach my $plugin (sort { $b->{weight}<=>$a->{weight} } @{$self->{"editform"}}){
		my $class = $plugin->{class};
		if(defined($class) && !defined($self->{instance}->{$class})){
			eval("use $class;");
			my $obj = $class->new();
			$self->{instance}->{$class} = $obj;
		}
		$buf .= $self->{instance}->{$class}->editform($self)."\n";
	}
	return $buf;
}

#==============================================================================
# ѤΥ˥塼ɲäޤ
# ԥ桼󤷤ɽޤ
#==============================================================================
sub add_admin_menu {
	my $self  = shift;
	my $label = shift;
	my $url   = shift;
	push(@{$self->{"admin_menu"}},{label=>$label,url=>$url});
}

#==============================================================================
# ѤΥ˥塼ޤ
#==============================================================================
sub get_admin_menu {
	my $self = shift;
	return @{$self->{"admin_menu"}};
}

#==============================================================================
# ȥ졼ꤷޤ
#==============================================================================
sub set_storage {
	my $self = shift;
	$self->{storage} = shift;
}
#==============================================================================
# ޤ
#==============================================================================
sub get_login_info {
	my $self = shift;
	my $cgi  = $self->get_CGI();
	my $id   = $cgi->cookie(-name=>'wiki_id');
	foreach(@{$self->{"user"}}){
		if($_->{id} eq $id){
			return {id=>$id,pass=>$_->{pass},type=>$_->{type}};
		}
	}
	return undef;
}

#==============================================================================
# åԤޤ
#==============================================================================
sub login_check {
	my $self = shift;
	my $id   = shift;
	my $pass = shift;
	foreach(@{$self->{"user"}}){
		if($_->{id} eq $id && $_->{pass} eq $pass){
			return {id=>$id,pass=>$pass,type=>$_->{type}};
		}
	}
	return undef;
}

#==============================================================================
# ڡԽǤ뤫ɤåޤ
#==============================================================================
sub can_modify_page {
	my $self = shift;
	my $page = shift;
	my $login = $self->get_login_info();
	if($self->config('accept_edit')==0 && !defined($login)){
		return 0;
	}
	if($self->is_freeze($page) && (!defined($login) || $login->{type}!=0)){
		return 0;
	}
	return 1;
}

#==============================================================================
# ץ饰򥤥󥹥ȡ뤷ޤ
#==============================================================================
sub install_plugin {
	my $self   = shift;
	my $plugin = shift;
	eval('use plugin::'.$plugin.'::Install;');
	eval('plugin::'.$plugin.'::Install::install($self);');
}

#==============================================================================
# ڡ뤷ޤ
#==============================================================================
sub freeze_page {
	my $self = shift;
	$self->{"storage"}->freeze_page(@_);
}

#==============================================================================
# ڡޤ
#==============================================================================
sub un_freeze_page {
	my $self = shift;
	$self->{"storage"}->un_freeze_page(@_);
}

#==============================================================================
# ꥹȤ
#==============================================================================
sub get_freeze_list {
	my $self = shift;
	return $self->{"storage"}->get_freeze_list();
}

#==============================================================================
# Ϥڡ椫ɤ٤ޤ
#==============================================================================
sub is_freeze {
	my $self = shift;
	return $self->{"storage"}->is_freeze(@_);
}

#==============================================================================
# ȥ
#==============================================================================
sub set_title {
	my $self  = shift;
	my $title = shift;
	my $edit  = shift;
	$self->{"title"} = $title;
	$self->{"edit"}  = 1 if $edit;
}

#==============================================================================
# ȥ
#==============================================================================
sub get_title {
	my $self = shift;
	return $self->{"title"};
}

#==============================================================================
# ڡΰ
#==============================================================================
sub get_page_list {
	my $self = shift;
	return $self->{"storage"}->get_page_list();

}

#==============================================================================
# ڡκǽ
#==============================================================================
sub get_last_modified {
	my $self = shift;
	return $self->{"storage"}->get_last_modified(@_);
}

#==============================================================================
# ˥塼ܤɲäޤ
#==============================================================================
sub add_menu {
	my $self   = shift;
	my $name   = shift;
	my $href   = shift;
	my $weight = shift;
	
	my $flag = 0;
	foreach(@{$self->{"menu"}}){
		if($_->{name} eq $name){
			$_->{href} = $href;
			$flag = 1;
			last;
		}
	}
	if($flag==0){
		push(@{$self->{"menu"}},{name=>$name,href=>$href,weight=>$weight});
	}
}

#===============================================================================
# եåϿ
#===============================================================================
sub add_hook {
	my $self = shift;
	my $name = shift;
	my $obj  = shift;
	
	push(@{$self->{"hook"}->{$name}},$obj);
}

#===============================================================================
# եåθƤӽФ
#===============================================================================
sub do_hook {
	my $self = shift;
	my $name = shift;
	
	foreach my $class (@{$self->{"hook"}->{$name}}){
		if(defined($class) && !defined($self->{instance}->{$class})){
			eval("use $class;");
			my $obj = $class->new();
			$self->{instance}->{$class} = $obj;
		}
		$self->{instance}->{$class}->hook($self,$name);
	}
}

#==============================================================================
# ڡ
#==============================================================================
sub get_page {
	my $self = shift;
	return $self->{"storage"}->get_page(@_);
}

#==============================================================================
# Хååפ
#==============================================================================
sub get_backup {
	my $self = shift;
	return $self->{"storage"}->get_backup(@_);
}

#==============================================================================
# ڡ¸
#==============================================================================
sub save_page {
	my $self = shift;
	my $pagename = shift;
	my $content  = shift;
	$self->do_hook("save_before");
	
	$self->{"storage"}->save_page($pagename,$content);
	$self->get_CGI->param("page"   ,$pagename);
	$self->get_CGI->param("content",$content);
	
	if($content ne ""){
		$self->do_hook("save_after");
	} else {
		$self->do_hook("delete");
	}
}

#==============================================================================
# ϥɥɲ
#==============================================================================
sub add_handler {
	my $self = shift;
	my $action = shift;
	my $class = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 1;
}

#==============================================================================
# ѤΥϥɥɲ
#==============================================================================
sub add_admin_handler {
	my $self = shift;
	my $action = shift;
	my $class = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 0;
}

#==============================================================================
# ץ饰ɲ
#==============================================================================
sub add_plugin {
	my $self = shift;
	my $name = shift;
	my $class = shift;
	
	$self->{"plugin"}->{$name}=$class;
}

#==============================================================================
# ϥɥưޤ
#==============================================================================
sub call_handler {
	my $self = shift;
	my $action = shift;
	my $class  = $self->{"handler"}->{$action};
	
	if(defined($class) && !defined($self->{instance}->{$class})){
		eval("use $class;");
		my $obj = $class->new();
		$self->{instance}->{$class} = $obj;
	}
	
	if($self->{"handler_permission"}->{$action}==0){
		# ѤΥ
		my $login = $self->get_login_info();
		if(!defined($login)){
			return $self->error("󤷤Ƥޤ");
			
		} elsif($login->{type}!=0){
			return $self->error("Ը¤ɬפǤ");
		}
		return $self->{instance}->{$class}->do_action($self).
		       "<div class=\"comment\"><a href=\"".$self->config('script_name')."?action=LOGIN\">˥塼</a></div>";
	
	} else {
		# ̤Υ
		return $self->{instance}->{$class}->do_action($self);
	}
}

#==============================================================================
# 顼ξ硢ƤӽФޤ
# ϥɥ餫饨顼𤹤ݤ˻ѤƤ
#==============================================================================
sub error {
	my $self = shift;
	my $message = shift;
	$self->set_title("顼");
	return "<div class=\"error\">".Util::escapeHTML($message)."</div>";
}

#===============================================================================
# Ϥ줿ʸWikiޤ
#===============================================================================
sub process_wiki {
	my $self    = shift;
	my $source  = shift;
	my $mainflg = shift;
	my $parser = Wiki::HTMLParser->new($self,$mainflg);
	$parser->parse($source);
	return $parser->{html};
}

#===============================================================================
# 饤ץ饰θƤӽФѤδؿ
#===============================================================================
sub process_inline {
	my $self = shift;
	my $text = shift;
	
	# 򸵤᤹
	$text =~ s/&quot;/"/g;
	$text =~ s/&lt;/</g;
	$text =~ s/&gt;/>/g;
	$text =~ s/&amp;/&/g;
	
	my $inline = $self->parse_inline_plugin($text);
	
	if($inline->{error} ne ""){
		return "<font class=\"error\">".$inline->{error}."</font>";
	}
	
	my $name = $inline->{command};
	my @args = @{$inline->{args}};
	
	my $class = $self->{plugin}->{$name};
	if($class ne "" && !defined($self->{instance}->{$class})){
		eval("use $class;");
		my $obj = $class->new();
		$self->{instance}->{$class} = $obj;
	}
	
	if($class eq ""){
		return "<font class=\"error\">{{$name}}ץ饰¸ߤޤ</font>";
	} else {
		return $self->{instance}->{$class}->inline($self,@args);
	}
}

#===============================================================================
# 饤ץ饰ѡƥޥɤȰʬ
#===============================================================================
sub parse_inline_plugin {
	my $self = shift;
	my $text = shift;
	my ($cmd,@args_tmp) = split(/ /,$text);
	my $args_txt = Util::trim(join(" ",@args_tmp));
	
	my @ret_args;
	my $tmp    = "";
	my $escape = 0;
	my $quote  = 0;
	
	for(my $i=0;$i<length($args_txt);$i++){
		my $c = substr($args_txt,$i,1);
		
		if($quote!=1 && $c eq ","){
			if($tmp ne ""){
				push(@ret_args,$tmp);
				$tmp = "";
				$quote = 0;
			}
		} elsif($quote==1 && $c eq "\\"){
			if($escape==0){
				$escape = 1;
			} else {
				$tmp .= $c;
				$escape = 0;
			}
		} elsif($quote==0 && $c eq '"'){
			if($tmp eq ""){
				$quote = 1;
			} else {
				$tmp .= $c;
			}
		} elsif($quote==1 && $c eq '"'){
			if($escape==1){
				$tmp .= $c;
				$escape = 0;
			} else {
				$quote = 2;
			}
		} elsif($quote==2){
			return {error=>"饤ץ饰ιʸǤ"};
		} else {
			$tmp .= $c;
		}
	}
	
	if($tmp ne ""){
		push(@ret_args,$tmp);
	}
	
	return {command=>$cmd,args=>\@ret_args};
}

#===============================================================================
# ڡ¸ߤ뤫ɤĴ٤
#===============================================================================
sub page_exists {
	my $self = shift;
	return $self->{"storage"}->page_exists(@_);
}

#===============================================================================
# CGI֥Ȥ
#===============================================================================
sub get_CGI {
	my $self = shift;
	return $self->{"CGI"};
}

#===============================================================================
# إåɽ
#===============================================================================
sub printHTMLHeader {
	my $self  = shift;
	my $title = $self->get_title();
	
	if(&Util::handyphone()){
		print "Content-Type: text/html;charset=Shift_JIS\n";
	} else {
		print "Content-Type: text/html;charset=EUC-JP\n";
	}
	print "Pragma: no-cache\n";
	print "Cache-Control: no-cache\n\n";
	
#	print "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
	print "<html lang=\"ja\">\n";
	print "<head>\n";
	if(&Util::handyphone()){
		
	} else {
		if($self->{edit}==1){
			print "<meta name=\"ROBOTS\" content=\"NOINDEX, NOFOLLOW\">\n";
		}
		print "<meta http-equiv=\"Content-Style-Type\" content=\"text/css\">\n";
		print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=EUC-JP\">\n";
		print "<link rel=\"stylesheet\" type=\"text/css\" href=\"",$self->config('css'),"\">\n";
		my $usercss = &Util::load_config_text($self,$self->config('usercss_file'));
		if($usercss ne ""){
			print "<style type=\"text/css\">\n";
			print "<!--\n";
			print &Util::escapeHTML($usercss);
			print "-->\n";
			print "</style>\n";
		}
	}
	
	if(&Util::handyphone()){
		&Jcode::convert(\$title,"sjis");
	}
	print "<title>".&Util::escapeHTML($title)." - ".$self->config('site_title')."</title>\n";
	
	print "</head>\n";
	print "<body>\n";
	
}

#===============================================================================
# ˥塼ɽ
#===============================================================================
sub print_menu {
	my $self = shift;
	my $title = shift;
	my $count = 0;
	
	my $template = HTML::Template->new(filename=>$self->config('tmpl_dir')."/header.tmpl",
	                                   die_on_bad_params => 0);
	my @menu = ();
	foreach(sort {$b->{weight}<=>$a->{weight}} @{$self->{menu}}){
		if($_->{href} ne ""){
			push(@menu,$_);
		}
	}
	
	$template->param(MENU=>\@menu);
	my $output = $template->output;
	if(&Util::handyphone()){
		&Jcode::convert(\$output,"sjis");
	}
	print $output;
}

#===============================================================================
# եåɽ
#===============================================================================
sub printHTMLFooter {
	my $self = shift;
	my $template = HTML::Template->new(filename=>$self->config('tmpl_dir')."/footer.tmpl");
	
	my $name = $self->config('admin_name');
	my $mail = $self->config('admin_mail_pub');
	my $out  = 1;
	if($name eq ""){ $name = $mail; }
	if($name eq "" && $mail eq ""){ $out = 0; }
	
	$template->param(
		ADMIN_NAME=>$name,
		ADMIN_MAIL=>$mail,
		OUT_COPYRIGHT=>$out
	);
	
	my $output = $template->output;
	if(Util::handyphone){
		&Jcode::convert(\$output,"sjis");
	}
	print $output;
}

1;
