################################################################################
#
# ƥΥåԤեå
# save_afterեåǵưޤ
#
################################################################################
package plugin::category::CategoryCache;
use strict;
use plugin::category::CategoryHandler;
#===============================================================================
# 󥹥ȥ饯
#===============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	return bless $self,$class;
}
#===============================================================================
# å򹹿⤷Ϻ
#===============================================================================
sub hook {
	my $self = shift;
	my $wiki = shift;
	my $name = shift;
	my $cgi  = $wiki->get_CGI();
	
	my $pagename = $cgi->param('page');
	my $cachefile = $wiki->config('log_dir')."/category.cache";
	
	if(-e $cachefile){
		my $hash = &Util::load_config_hash(undef,$cachefile);
		$hash = &update_cache($wiki,$hash,$pagename);
		&Util::save_config_hash(undef,$cachefile,$hash);
	} else {
		&create_cache($wiki);
	}
}

#==============================================================================
# ƥꥭåؿ
#==============================================================================
sub create_cache {
	my $wiki = shift;
	my $hash = {};
	my @pages = $wiki->get_page_list();
	foreach my $page (@pages){
		&update_cache($wiki,$hash,$page);
	}
	&Util::save_config_hash(undef,$wiki->config('log_dir')."/category.cache",$hash);
}

#==============================================================================
# ƥꥭå򥢥åץǡȤؿ
#==============================================================================
sub update_cache {
	my $wiki     = shift;
	my $hash     = shift;
	my $pagename = shift;
	my $pageptn  = quotemeta($pagename);
	
	foreach my $category (keys(%$hash)){
		$hash->{$category} =~ s/\t$pageptn(\t|$)/$1/g;
	}
	
	my $content  = $wiki->get_page($pagename);
	my @categories = &get_page_category($wiki,$content);
	foreach my $category (@categories){
		my @pages = split(/\t/,$hash->{$category});
		my $flag = 0;
		foreach my $page (@pages){
			if($page eq $pagename){
				$flag = 1;
				last;
			}
		}
		if($flag==0){
			$hash->{$category} = $hash->{$category}."\t$pagename";
		}
	}
	return $hash;
}

#==============================================================================
# ڡΥƥФؿ
#==============================================================================
sub get_page_category {
	my $wiki   = shift;
	my $source = shift;
	my @category;
	foreach my $line (split(/\n/,$source)){
		if(index($line," ")!=0 && index($line,"\t")!=0){
			while($line =~ /{{(category\s+(.+?)\s*)}}/g){
				my $inline = $wiki->parse_inline_plugin($1);
				push(@category,@{$inline->{args}}[0]);
			}
		}
	}
	return @category;
}

1;
