############################################################
# 
# ʬɽץ饰
# 
############################################################
package plugin::core::Diff;
#use lib "D:/httpd132f/root/fswiki/lib";
use Algorithm::Diff qw(traverse_sequences);
use strict;

#===========================================================
# ⥸塼ǻѤѿ
#===========================================================
my $diff_text;
my $msgrefA;
my $msgrefB;
my @diff_added;
my @diff_deleted;

#===========================================================
# 󥹥ȥ饯
#===========================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#===========================================================
# μ¹
#===========================================================
sub do_action {
	my $self = shift;
	my $wiki = shift;
	my $cgi = $wiki->get_CGI;
	
	my $pagename = $cgi->param("page");
	if($pagename eq ""){
		$pagename = "FrontPage";
	}
	
	if($wiki->{storage}->backup_type eq "all"){
		if($cgi->param("generation") eq ""){
			return $self->show_history($wiki,$pagename);
		} else {
			return $self->show_diff($wiki,$pagename,$cgi->param("generation"));
		}
	} else {
		return $self->show_diff($wiki,$pagename,0);
	}
}

#===========================================================
# ΰɽ
# ȥ졼backup_type=allΤȤ
#===========================================================
sub show_history {
	my $self = shift;
	my $wiki = shift;
	my $pagename = shift;
	
	$wiki->set_title($pagename."ѹ");
	my $buf = "<ul>\n";
	my $count = 0;
	foreach($wiki->{storage}->get_backup_list()){
		$buf .= "<li><a href=\"".$wiki->config('script_name')."?action=DIFF".
		        "&page=".&Util::url_encode($pagename).
		        "&generation=$count\">".&Util::escapeHTML($_)."</a></li>\n";
		$count++;
	}
	return $buf."</ul>\n";
}

#===========================================================
# ʬɽ
#===========================================================
sub show_diff {
	my $self = shift;
	my $wiki = shift;
	my $pagename   = shift;
	my $generation = shift;
	
	$wiki->set_title($pagename."ѹ");
	
	my @msg1 = split(/\n/,$wiki->get_page($pagename));
	my @msg2 = split(/\n/,$wiki->get_backup($pagename,$generation));
	$msgrefA = \@msg2;
	$msgrefB = \@msg1;
	
	traverse_sequences($msgrefA, $msgrefB,
		{MATCH => \&df_match,DISCARD_A => \&df_delete,DISCARD_B => \&df_add,});
	&diff_flush;
	
	return "<pre>".Util::escapeHTML($diff_text)."</pre>";
}

#===========================================================
# YukiWikiܿAlgorithm::DiffΥեåؿ
#===========================================================
sub diff_flush {
    $diff_text .= join('', map { "-$_\n" } splice(@diff_deleted));
    $diff_text .= join('', map { "+$_\n" } splice(@diff_added));
}

sub df_match {
    my ($a, $b) = @_;
    &diff_flush;
    #$diff_text .= "=$msgrefA->[$a]\n";
}

sub df_delete {
    my ($a, $b) = @_;
    push(@diff_deleted, $msgrefA->[$a]);
}

sub df_add {
    my ($a, $b) = @_;
    push(@diff_added, $msgrefB->[$b]);
}

#===========================================================
# ڡɽΥեå᥽å
# ֺʬץ˥塼ͭˤޤ
#===========================================================
sub hook {
	my $self = shift;
	my $wiki = shift;
	my $cgi  = $wiki->get_CGI;
	
	my $pagename = $cgi->param("page");
	if($pagename eq ""){
		$pagename = "FrontPage";
	}
	
	$wiki->add_menu("ʬ",$wiki->config('script_name')."?action=DIFF&amp;page=".&Util::url_encode($pagename));
}

1;
