#!/usr/bin/perl
###############################################################################
#
# CGIץ
#
###############################################################################
BEGIN {
	if(exists $ENV{MOD_PERL}){
		# ȥǥ쥯ȥѹ
		use Cwd;
		chdir("C:/Apache/htdocs/fswiki/");
		
		# exitؿξ
		use subs 'exit';
		require Apache;
		*exit = \&Apache::exit;
		$| = 1;
	}
}
#==============================================================================
# ⥸塼Υ󥯥롼
#==============================================================================
use lib lib;
use strict;
use CGI::Carp qw(fatalsToBrowser);
use CGI2;
use Farm;
use Util;
use Jcode;
use HTML::Template;

#==============================================================================
# CGIWikiΥ󥹥󥹲
#==============================================================================
my $cgi  = CGI2->new();
my $wiki = Farm->new($cgi);

#==============================================================================
# FarmȤư
#==============================================================================
my $path_info  = $cgi->path_info();
my $path_count = 0;
if(length($path_info) > 0){
	# ȤꤢPATH_INFOκǸ"/"Ϲͤʤ褦ˤ
	$path_info =~ m</([^/]+)$>;
	$wiki->config('script_name', $1);
	$wiki->config('data_dir'   , $wiki->config('data_dir'  ).$path_info);
	$wiki->config('config_dir' , $wiki->config('config_dir').$path_info);
	$wiki->config('backup_dir' , $wiki->config('backup_dir').$path_info);
	$wiki->config('log_dir'    , $wiki->config('log_dir'   ).$path_info);
	
	if(!($wiki->config('theme_uri') =~ /^(http:|https:|ftp:)/)){
		my @paths = split(/\//,$path_info);
		$path_count = $#paths;
		for(my $i=0;$i<$path_count;$i++){
			$wiki->config('theme_uri','../'.$wiki->config('theme_uri'));
		}
	}
}

#==============================================================================
# ȿ
# ȥ桼ɤ߹ߤWiki.pmǤäۤ褤⡣
#==============================================================================
my $config = &Util::load_config_hash($wiki,$wiki->config('config_file'));

$wiki->config('site_title'           ,$config->{site_title});
$wiki->config('css'                  ,$wiki->config('theme_uri')."/".$config->{theme}."/".$config->{theme}.".css");
$wiki->config('use_sidebar'          ,$config->{use_sidebar});
$wiki->config('accept_edit'          ,$config->{accept_edit});
$wiki->config('wikiname'             ,$config->{wikiname});
$wiki->config('pagelist'             ,$config->{pagelist});
$wiki->config('admin_name'           ,$config->{admin_name});
$wiki->config('admin_mail'           ,$config->{admin_mail});
$wiki->config('admin_mail_pub'       ,$config->{admin_mail_pub});
$wiki->config('br_mode'              ,$config->{br_mode});
$wiki->config('auto_keyword_page'    ,$config->{auto_keyword_page});
$wiki->config('accept_attach_delete' ,$config->{accept_attach_delete});

#==============================================================================
# 桼ɤ߹
#==============================================================================
my $users = &Util::load_config_hash($wiki,$wiki->config('userdat_file'));
foreach my $id (keys(%$users)){
	my ($pass,$type) = split(/\t/,$users->{$id});
	$wiki->add_user($id,$pass,$type);
	
	# WikiΥ桼ɤ߹
	my $tmp_config_dir = $wiki->config('config_dir');
	for(my $i=0;$i<$path_count;$i++){
		$wiki->config('config_dir',$wiki->config('config_dir')."/..");
		my $parent_users = &Util::load_config_hash($wiki,$wiki->config('userdat_file'));
		foreach my $parent_id (keys(%$parent_users)){
			my ($parent_pass,$parent_type) = split(/\t/,$parent_users->{$parent_id});
			$wiki->add_user($parent_id,$parent_pass,$parent_type);
		}
	}
	$wiki->config('config_dir',$tmp_config_dir);
}

#==============================================================================
# ץ饰Υ󥹥ȡȽ
#==============================================================================
my @plugins = split(/\n/,&Util::load_config_text($wiki,$wiki->config('plugin_file')));
foreach(sort(@plugins)){
	$wiki->install_plugin($_);
}
# ץ饰󤴤Ȥνư
$wiki->do_hook("initialize");

#==============================================================================
# ϥɥθƤӽФ
#==============================================================================
my $action = $cgi->param("action");
my $content = $wiki->call_handler($action);

#==============================================================================
# 쥹ݥ
#==============================================================================
$wiki->printHTMLHeader($wiki->get_title());

if(!&Util::handyphone() && $wiki->page_exists("Menu") && $wiki->config('use_sidebar')==1){
	print "<div class=\"main\">\n";
}

$wiki->print_menu();

if($cgi->param('action') eq "" && $wiki->page_exists($cgi->param('page'))){
	print "<h1><a href=\"?action=SEARCH&word=".&Util::url_encode($wiki->get_title())."\">".
	      &Util::escapeHTML($wiki->get_title())."</a></h1>\n";
} else {
	print "<h1>".&Util::escapeHTML($wiki->get_title())."</h1>\n";
}
print "<div class=\"day\">\n";
print "<div class=\"body\">\n";
print "<div class=\"section\">\n";

if(&Util::handyphone()){
	&Jcode::convert(\$content,"sjis");
}
print $content;

print "</div>\n";
print "</div>\n";
print "</div>\n";

$wiki->printHTMLFooter();

if(!&Util::handyphone()){
	if($wiki->page_exists("Menu") && $wiki->config('use_sidebar')==1){
		print "</div>\n";
		print "<div class=\"sidebar\">\n";
		print $wiki->process_wiki($wiki->get_page("Menu"));
		print "</div>\n";
	}
}

print "</body></html>\n";

print $ENV{'PATH_INFO'} = undef;
