/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test;

import com.ftinc.si.assist.test.ArgumentIF;
import com.ftinc.si.assist.test.Record;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectRecord
extends Record
implements ArgumentIF {
    public String id;
    public String stack;
    public int testID;
    public String testCase;
    public String className;
    public String jSON;
    public boolean isPOJO = true;
    public boolean completed = false;
    public String typeName;

    public ObjectRecord() {
        super(0);
    }

    public ObjectRecord(int i) {
        super(i);
    }

    public ObjectRecord(int i, String caseName, int testid, int position, String cname, String xstack) {
        super(i);
        this.testCase = caseName;
        this.testID = testid;
        this.id = String.valueOf(Integer.toString(testid)) + "$" + Integer.toString(position);
        this.className = cname;
        this.stack = xstack;
    }

    @Override
    public void read(ResultSet r) throws SQLException {
        this.id = r.getString("ID");
        this.stack = r.getString("Stack");
        this.isPOJO = r.getBoolean("IsPOJO");
        this.testID = r.getInt("TestID");
        this.jSON = r.getString("JSON");
        this.testCase = r.getString("TestCase");
        this.className = r.getString("ClassName");
        this.completed = r.getBoolean("Completed");
    }

    public ObjectRecord _dup(boolean not_new) {
        ObjectRecord t_rec = new ObjectRecord(2);
        t_rec.testCase = this.testCase;
        t_rec.className = this.className;
        t_rec.isPOJO = this.isPOJO;
        t_rec.jSON = this.jSON;
        t_rec.stack = this.stack;
        if (not_new) {
            t_rec.m_status = this.m_status;
        }
        t_rec.id = this.id;
        t_rec.testID = this.testID;
        t_rec.removed = this.removed;
        t_rec.completed = this.completed;
        return t_rec;
    }

    public boolean equals(ObjectRecord rec) {
        boolean res = true;
        if (!this.testCase.equals(rec.testCase)) {
            res = false;
        }
        if (!this.className.equals(rec.className)) {
            res = false;
        }
        if (this.jSON == null) {
            if (rec.jSON != null) {
                res = false;
            }
        } else if (!this.jSON.equals(rec.jSON)) {
            res = false;
        }
        if (!this.stack.equals(rec.stack)) {
            res = false;
        }
        if (this.isPOJO != rec.isPOJO) {
            res = false;
        }
        return res;
    }

    public String _id() {
        return this.id;
    }

    private String _jSON() {
        return this.esq(this.jSON);
    }

    @Override
    public String getUpdateSQL() {
        if (this.removed && this.isNew()) {
            return null;
        }
        if (this._id() == null) {
            return null;
        }
        String t_sql = null;
        if (this.removed) {
            return "delete from \"tbl_ObjectRecord\" where \"ID\"='" + this._id() + "'";
        }
        if (this.isNew()) {
            t_sql = "insert into \"tbl_ObjectRecord\" (\"ID\", \"Stack\", \"IsPOJO\", \"JSON\", \"TestID\", \"TestCase\", \"ClassName\", \"Completed\")values ('" + this._id() + "','" + this.stack + "'," + Boolean.toString(this.isPOJO) + ",'" + this._jSON() + "'," + Integer.toString(this.testID) + ",'" + this.testCase + "','" + this.className + "','" + Boolean.toString(this.isCompleted()) + "')";
        } else if (this.isUpdated()) {
            t_sql = "update \"tbl_ObjectRecord\" set \"IsPOJO\"=" + Boolean.toString(this.isPOJO) + ", \"JSON\"='" + this._jSON() + "',\"Stack\"='" + this.stack + "', \"TestCase\"='" + this.testCase + "', \"Completed\"='" + Boolean.toString(this.isCompleted()) + "' where \"ID\"='" + this._id() + "'";
        }
        return t_sql;
    }

    public boolean isCompleted() {
        return this.completed || this.stack.matches("^[0-9]+\\$[0-9_]+$") || !this.isPOJO;
    }

    @Override
    public String getTestCase() {
        return this.testCase;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getTestID() {
        return this.testID;
    }

    @Override
    public String getStack() {
        return this.stack;
    }

    @Override
    public void setStack(String s) {
        this.stack = s;
        this.changed();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public void setClassName(String s) {
        this.className = s;
    }

    @Override
    public String getJSON() {
        return this.jSON;
    }

    @Override
    public void setJSON(String s) {
        this.jSON = s;
        this.completed = s != null && s.length() > 0;
        this.changed();
    }

    @Override
    public boolean isPOJO() {
        return this.isPOJO;
    }

    @Override
    public void setPOJO(boolean b) {
        this.isPOJO = b;
        this.changed();
    }
}

