/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.CodingAssistMenu;
import com.ftinc.si.assist.test.gui.TestCaseEditor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;

public class AssertEditor
extends JDialog {
    private JTextField idText;
    private JComboBox<String> typeCombo;
    private JTextArea regText;
    private JTextPane targetText;
    boolean is_OK = false;
    AssertRecord m_assert;
    TestCommandRecord m_cmd;
    private String m_checked;
    private HashMap<String, Class<?>> m_cmap = null;

    public AssertEditor(JDialog owner, AssertRecord rec, TestCommandRecord cmd) {
        super((Dialog)owner, true);
        this.m_assert = rec;
        this.m_cmd = cmd;
        this.setResizable(false);
        this.setTitle(Messages.getString("AssertEditor.0"));
        this.getContentPane().setLayout(null);
        this.setBounds(owner.getX() + 100, owner.getY() + 100, 600, 500);
        JLabel lblId = new JLabel(Messages.getString("AssertEditor.1"));
        lblId.setBounds(12, 10, 50, 13);
        this.getContentPane().add(lblId);
        this.idText = new JTextField();
        this.idText.setEnabled(false);
        this.idText.setEditable(false);
        this.idText.setBounds(74, 7, 200, 19);
        this.idText.setText(new Integer(rec.id).toString());
        this.getContentPane().add(this.idText);
        this.idText.setColumns(10);
        JLabel lblType = new JLabel(Messages.getString("AssertEditor.2"));
        lblType.setBounds(324, 10, 50, 13);
        this.getContentPane().add(lblType);
        this.typeCombo = new JComboBox();
        this.typeCombo.setBounds(382, 7, 200, 19);
        this.typeCombo.addItem("Exception");
        this.typeCombo.addItem("Inspect");
        this.typeCombo.setSelectedItem(rec.criteriaType);
        this.getContentPane().add(this.typeCombo);
        JLabel lblCriteria = new JLabel(Messages.getString("AssertEditor.8"));
        lblCriteria.setBounds(12, 33, 50, 13);
        this.getContentPane().add(lblCriteria);
        JLabel lblRegularex = new JLabel(Messages.getString("AssertEditor.11"));
        lblRegularex.setBounds(12, 311, 72, 13);
        this.getContentPane().add(lblRegularex);
        final JButton btnOk = new JButton(Messages.getString("AssertEditor.13"));
        btnOk.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!btnOk.isEnabled()) {
                    return;
                }
                if (AssertEditor.this.isSyntaxOK()) {
                    AssertEditor.this.updating();
                } else {
                    int option = JOptionPane.showConfirmDialog(null, String.valueOf(AssertEditor.this.m_checked) + Messages.getString("AssertEditor.19"), Messages.getString("AssertEditor.20"), 2, 3);
                    if (option == 0) {
                        AssertEditor.this.targetText.setText("!" + AssertEditor.this.targetText.getText());
                        AssertEditor.this.updating();
                    }
                }
            }
        });
        btnOk.setBounds(168, 440, 91, 21);
        btnOk.setEnabled(!TestCaseEditor.unableMode);
        this.getContentPane().add(btnOk);
        JButton btnCancel = new JButton(Messages.getString("AssertEditor.14"));
        btnCancel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AssertEditor.this.setVisible(false);
            }
        });
        btnCancel.setBounds(291, 440, 91, 21);
        this.getContentPane().add(btnCancel);
        JScrollPane scrollPane_1 = new JScrollPane();
        scrollPane_1.setBounds(22, 334, 560, 96);
        this.getContentPane().add(scrollPane_1);
        this.regText = new JTextArea(this.m_assert.criteriaRex);
        this.regText.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, AssertEditor.this.regText.getFont());
                if (t_font != null) {
                    AssertEditor.this.regText.setFont(t_font);
                }
            }
        });
        this.regText.setFont(new Font("MS UI Gothic", 0, 14));
        this.regText.setEditable(!TestCaseEditor.unableMode);
        scrollPane_1.setViewportView(this.regText);
        JScrollPane scrollPane_2 = new JScrollPane();
        scrollPane_2.setBounds(25, 56, 557, 245);
        this.getContentPane().add(scrollPane_2);
        this.targetText = new JTextPane();
        this.targetText.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                Font t_font = Tool.resizeFont(e, AssertEditor.this.targetText.getFont());
                if (t_font != null) {
                    AssertEditor.this.targetText.setFont(t_font);
                }
            }
        });
        this.targetText.setFont(new Font("MS UI Gothic", 0, 14));
        scrollPane_2.setViewportView(this.targetText);
        this.targetText.setToolTipText("");
        this.targetText.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    AssertEditor.this.popupTargetField(e);
                }
            }
        });
        this.targetText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '.') {
                    AssertEditor.this.popupCandidate(e);
                }
            }
        });
        this.targetText.setEditable(!TestCaseEditor.unableMode);
        if (this.m_assert.targetObj != null && this.m_assert.targetObj.startsWith("!")) {
            this.targetText.setText(this.m_assert.targetObj.substring(1));
        } else {
            this.targetText.setText(this.m_assert.targetObj);
        }
        this.typeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AssertEditor.this.typeCombo.isEnabled()) {
                    return;
                }
                String t_str = (String)AssertEditor.this.typeCombo.getSelectedItem();
                if (t_str != null && t_str.length() > 0) {
                    AssertEditor.this.targetText.setText("");
                    if (t_str.equals("Exception")) {
                        AssertEditor.this.targetText.setEnabled(false);
                        AssertEditor.this.regText.setText("");
                    } else if (t_str.equals("Inspect")) {
                        AssertEditor.this.targetText.setEnabled(true);
                        AssertEditor.this.regText.setText("[]");
                    }
                }
                AssertEditor.this.m_assert.criteriaType = (String)AssertEditor.this.typeCombo.getSelectedItem();
            }
        });
        this.typeCombo.setEnabled(!TestCaseEditor.unableMode);
        this.initTarget();
    }

    private void initTarget() {
        if (this.m_cmap == null) {
            try {
                this.m_cmap = new HashMap();
                if (!this.m_cmd.returnType.matches("^[a-z]+$")) {
                    this.m_cmap.put("$_", Tool.forName(this.m_cmd.returnType));
                }
                this.m_cmap.put("$0", Tool.forName(this.m_cmd.className));
                int i = 0;
                while (i < this.m_cmd.numArgs()) {
                    String arg_cname = this.m_cmd.getArgClass(i);
                    if (!arg_cname.endsWith("[]")) {
                        this.m_cmap.put("$" + Integer.toString(i + 1), Tool.forName(arg_cname));
                    }
                    ++i;
                }
            }
            catch (ClassNotFoundException e) {
                Tool.alertMSG(null, String.valueOf(Messages.getString("AssertEditor.31")) + e.getMessage() + ".");
                return;
            }
        }
    }

    private void updating() {
        this.is_OK = true;
        DefaultComboBoxModel t_model = (DefaultComboBoxModel)this.typeCombo.getModel();
        String i_name = (String)t_model.getSelectedItem();
        if (i_name != null) {
            this.m_assert.criteriaType = i_name;
        }
        this.m_assert.targetObj = this.targetText.getText();
        this.m_assert.criteriaRex = this.regText.getText();
        this.m_assert.changed();
        this.setVisible(false);
    }

    private void popupTargetField(MouseEvent e) {
        ArrayList<String> t_list = new ArrayList<String>();
        if ("Exception".equals(this.typeCombo.getSelectedItem())) {
            Class<?>[] arg_classes = Tool.getArgClasses(this.m_cmd);
            try {
                Method t_verb = Tool.forName(this.m_cmd.className).getDeclaredMethod(this.m_cmd.methodName, arg_classes);
                Class<?>[] exs = t_verb.getExceptionTypes();
                int k = 0;
                while (k < exs.length) {
                    t_list.add(exs[k].getName());
                    ++k;
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e1) {
                Tool.alertMSG(null, e1.getMessage());
            }
        } else if ("Inspect".equals(this.typeCombo.getSelectedItem())) {
            Pattern t_pat = Pattern.compile("ASSERTING\\(\\s*([0-9]+)\\s*,");
            Matcher t_m = t_pat.matcher(this.targetText.getText());
            int n = 0;
            while (t_m.find()) {
                String num = t_m.group(1);
                Integer t_i = new Integer(num);
                if (t_i < n) continue;
                n = t_i + 1;
            }
            t_list.add("ASSERTING(" + Integer.toString(n) + ", );\n");
            t_list.add("XROOT();\n");
            t_list.add("XELM(\"//*[@id='']\")");
        }
        JPopupMenu t_pop = new JPopupMenu();
        int i = 0;
        while (i < t_list.size()) {
            t_pop.add(new JMenuItem(new InsertAction((String)t_list.get(i), this)));
            ++i;
        }
        t_pop.show(e.getComponent(), e.getX(), e.getY());
    }

    private void popupCandidate(KeyEvent e) {
        if (!"Inspect".equals(this.m_assert.criteriaType)) {
            return;
        }
        Caret tc = this.targetText.getCaret();
        Point op = this.targetText.getLocationOnScreen();
        Point pt = tc.getMagicCaretPosition();
        Point pos = new Point(op.x + pt.x, op.y + pt.y);
        final CodingAssistMenu _popup = new CodingAssistMenu(this, null, this.targetText.getText(), this.targetText.getCaretPosition(), this.m_cmap, pos, null);
        if (_popup.countCandidate() > 0) {
            Thread t_thread = new Thread(){

                @Override
                public void run() {
                    try {
                        8.sleep(1000L);
                        SwingUtilities.getWindowAncestor(_popup).toFront();
                        _popup.requestFocusInWindow();
                    }
                    catch (InterruptedException e) {
                        Tool.logIfDebug(e, "@AssertEditor#popupCandidate");
                    }
                }
            };
            t_thread.run();
            _popup.setVisible(true);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AssertEditor.this.insertAtCaret(_popup.m_answer, _popup.m_target, _popup.m_catches);
                }
            });
        }
    }

    public void insertAtCaret(String str, String tgt, String ctch) {
        if (str != null) {
            int pos = this.targetText.getCaretPosition();
            String str_h = this.targetText.getText();
            String str_tail = str_h.substring(pos);
            str_h = str_h.substring(0, pos);
            if (ctch != null) {
                str_h = str_h.replaceFirst(String.valueOf(Pattern.quote(String.valueOf(tgt) + ".")) + "$", Matcher.quoteReplacement("try{\n" + tgt + "."));
                str_h = String.valueOf(str_h) + ctch + str_tail;
            } else {
                str_h = String.valueOf(str_h) + str + str_tail;
            }
            this.targetText.setText(str_h);
            this.targetText.setCaretPosition(pos + str.length());
        }
    }

    private boolean isSyntaxOK() {
        AssertRecord t_ast = this.m_assert._dup(false);
        t_ast.targetObj = this.targetText.getText();
        t_ast.criteriaRex = this.regText.getText();
        if (!t_ast.isCompleted()) {
            Tool.alertMSG(null, Messages.getString("AssertEditor.27"));
            return false;
        }
        if ("Exception".equals(this.typeCombo.getSelectedItem())) {
            if ("$null".equals(this.regText.getText())) {
                return true;
            }
            if (!this.regText.getText().matches(".*[ExceptionROr]+$")) {
                return false;
            }
        }
        return true;
    }

    class InsertAction
    extends AbstractAction {
        String m_string;
        AssertEditor m_master;

        InsertAction(String str, AssertEditor master) {
            this.putValue("Name", str);
            this.m_string = str;
            this.m_master = master;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_master.insertAtCaret(this.m_string, null, null);
        }
    }
}

