/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.si.assist.test.gui.plugins;

import com.ftinc.si.assist.run.Messages;
import com.ftinc.si.assist.test.ArgumentIF;
import com.ftinc.si.assist.test.AssertIF;
import com.ftinc.si.assist.test.AssertRecord;
import com.ftinc.si.assist.test.ObjectRecord;
import com.ftinc.si.assist.test.TestCaseIF;
import com.ftinc.si.assist.test.TestCommandIF;
import com.ftinc.si.assist.test.TestCommandRecord;
import com.ftinc.si.assist.test.Tool;
import com.ftinc.si.assist.test.gui.ArgumentEditor;
import com.ftinc.si.assist.test.gui.AssertEditor;
import com.ftinc.si.assist.test.gui.ClassReadDialog;
import com.ftinc.si.assist.test.gui.Plugin;
import com.ftinc.si.assist.test.gui.TestCaseEditor;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class DefaultPlugin
implements Plugin {
    private boolean isStatic;
    private String className;
    private int v_argpos;
    private String[] argTypes;

    @Override
    public JMenuItem getMenuItem(String s) {
        if (s.equals("addCommand")) {
            return TestCaseEditor.getMenuItem(s, Messages.getString("DefaultPlugin.2"), null, this);
        }
        if (s.equals("editArg")) {
            return TestCaseEditor.getMenuItem(s, Messages.getString("DefaultPlugin.1"), null, this);
        }
        if (s.equals("addArg")) {
            return TestCaseEditor.getMenuItem(s, Messages.getString("DefaultPlugin.0"), null, this);
        }
        if (s.equals("editAssert")) {
            return TestCaseEditor.getMenuItem(s, Messages.getString("DefaultPlugin.3"), null, this);
        }
        return null;
    }

    @Override
    public int getPriority(TestCaseIF cs, TestCommandIF rec, String stack) {
        if (rec != null && stack != null) {
            return 1;
        }
        if (stack == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int initCommand(TestCommandIF cmd) {
        ClassReadDialog m_dial = new ClassReadDialog(null, Tool.target_dirs, (TestCommandRecord)cmd);
        m_dial.setVisible(true);
        if (m_dial.className != null && m_dial.methodName != null) {
            cmd.setClassName(m_dial.className);
            this.className = m_dial.className;
            String[] m_info = m_dial.methodName.split(" ");
            this.isStatic = false;
            this.v_argpos = -1;
            String mName = "";
            if (m_info.length == 1) {
                mName = m_info[0];
            } else if (m_info.length == 2) {
                if (m_info[0].matches("^.*static")) {
                    this.isStatic = true;
                    mName = m_info[1];
                } else {
                    mName = m_info[0].equals("^final") ? m_info[1] : m_info[0];
                }
            } else if (m_info.length == 3) {
                if (m_info[0].matches("^.*static")) {
                    this.isStatic = true;
                }
                mName = m_info[1];
                this.v_argpos = new Integer(m_info[2]);
            } else {
                return -1;
            }
            cmd.setMethod(mName, this.isStatic, this.v_argpos);
            int a_size = m_dial.objs.length;
            int count = 0;
            this.argTypes = new String[a_size];
            int i = 0;
            while (a_size > i) {
                String obj_rep = m_dial.objs[i];
                if (obj_rep.startsWith("$_")) {
                    cmd.setReturnType(obj_rep.replaceAll("\\$_=", ""));
                } else if (obj_rep.startsWith("$0")) {
                    this.argTypes[0] = m_dial.className;
                    ++count;
                } else {
                    String num = obj_rep.replaceAll("^\\$([0-9]+)=.*$", "$1");
                    Integer n = new Integer(num);
                    if (this.v_argpos + 1 != n) {
                        this.argTypes[n.intValue()] = obj_rep.replaceAll("^\\$[0-9]+=(.*)$", "$1");
                    }
                    ++count;
                }
                ++i;
            }
            return count;
        }
        return -2;
    }

    @Override
    public void initArguments(ArgumentIF[] a) {
        int i = 0;
        while (i < a.length) {
            if (i == 0) {
                if (!this.isStatic) {
                    a[i].setClassName(this.className);
                    a[i].setStack("$0");
                }
            } else {
                a[i].setClassName(this.argTypes[i]);
                String t_stack = "$" + Integer.toString(i);
                a[i].setStack(t_stack);
            }
            ++i;
        }
    }

    @Override
    public void initArgument(ArgumentIF a, String opt) {
        String t_cname = this.argTypes[this.argTypes.length - 1];
        a.setClassName(t_cname);
    }

    @Override
    public int varArgsPos() {
        return this.v_argpos;
    }

    @Override
    public boolean hasSubject() {
        return !this.isStatic;
    }

    @Override
    public boolean hasAssert() {
        return true;
    }

    @Override
    public void editArgument(ArgumentIF a, AssertIF ast, String opt) {
        ObjectRecord xa = (ObjectRecord)a;
        String id = a.getId().replaceFirst("^[0-9]+(\\$.*$)", "$1");
        if ("$_".equals(id)) {
            String t_data = JOptionPane.showInputDialog(ArgumentEditor.s_owner, Messages.getString("DefaultPlugin.5"), xa.getClassName());
            if (t_data != null && !xa.getClassName().equals(t_data)) {
                xa.className = t_data;
                xa.changed();
            }
        } else {
            ArgumentEditor t_ae = new ArgumentEditor(ArgumentEditor.s_owner, xa, id);
            t_ae.setVisible(true);
        }
    }

    @Override
    public TestCommandIF extendCommand(TestCommandIF a) {
        return null;
    }

    @Override
    public void initAssert(AssertIF ast) {
    }

    @Override
    public void editProperties(HashMap<String, String> map) {
    }

    @Override
    public void initProperties(HashMap<String, String> map) {
    }

    @Override
    public void editAssert(AssertIF ast, TestCommandIF atd) {
        AssertEditor a_edit = null;
        try {
            a_edit = new AssertEditor(ArgumentEditor.s_owner, (AssertRecord)ast, (TestCommandRecord)atd);
            a_edit.setVisible(true);
        }
        catch (Exception e) {
            Tool.alertMSG(null, String.valueOf(Messages.getString("TestCaseEditor.44")) + e.getMessage() + "\n" + Tool.getStackMessage(e, 0, 10));
            return;
        }
    }

    @Override
    public void destroy() {
    }
}

